/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class SoundRegistryModule
implements AdditionalCatalogRegistryModule<SoundType>,
AlternateCatalogRegistryModule<SoundType> {
    @RegisterCatalog(value=SoundTypes.class)
    private final Map<String, SoundType> soundMappings = Maps.newHashMap();

    public static SoundRegistryModule inst() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, SoundType> provideCatalogMap() {
        HashMap<String, SoundType> soundTypeMap = new HashMap<String, SoundType>();
        for (Map.Entry<String, SoundType> entry : this.soundMappings.entrySet()) {
            soundTypeMap.put(entry.getKey().replace("minecraft:", "").replace('.', '_'), entry.getValue());
        }
        return soundTypeMap;
    }

    @Override
    public void registerDefaults() {
        for (ResourceLocation key : SoundEvent.field_187505_a.func_148742_b()) {
            this.soundMappings.put(key.toString(), (SoundType)SoundEvent.field_187505_a.func_82594_a((Object)key));
        }
    }

    @Override
    public Optional<SoundType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.soundMappings.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SoundType> getAll() {
        return ImmutableList.copyOf(this.soundMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(SoundType extraCatalog) {
        String catalogId = new ResourceLocation(((SoundType)Preconditions.checkNotNull((Object)extraCatalog)).getId().toLowerCase(Locale.ENGLISH)).toString();
        if (!this.soundMappings.containsKey(catalogId)) {
            this.soundMappings.put(catalogId, extraCatalog);
        }
    }

    private static final class Holder {
        static final SoundRegistryModule INSTANCE = new SoundRegistryModule();

        private Holder() {
        }
    }
}

