/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.data.type.OcelotTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeEntityConstants;

public class OcelotTypeRegistryModule
implements CatalogRegistryModule<OcelotType> {
    @RegisterCatalog(value=OcelotTypes.class)
    private final Map<String, OcelotType> ocelotTypeMap = new HashMap<String, OcelotType>();

    @Override
    public Optional<OcelotType> getById(String id) {
        return Optional.ofNullable(this.ocelotTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<OcelotType> getAll() {
        return ImmutableList.copyOf(this.ocelotTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.ocelotTypeMap.putAll(SpongeEntityConstants.OCELOT_TYPES);
    }
}

