/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.CustomCatalogRegistration;
import org.spongepowered.api.registry.util.DelayedRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.registry.RegistryHelper;

public final class RegistryModuleLoader {
    private RegistryModuleLoader() {
    }

    public static void tryModulePhaseRegistration(RegistryModule module) {
        try {
            if (RegistryModuleLoader.requiresCustomRegistration(module)) {
                if (RegistryModuleLoader.isCustomProperPhase(module)) {
                    Method method = RegistryModuleLoader.getCustomRegistration(module);
                    RegistryModuleLoader.invokeCustomRegistration(module, (Method)Preconditions.checkNotNull((Object)method, (Object)"Custom registration module was null!"));
                }
            } else if (RegistryModuleLoader.isDefaultProperPhase(module)) {
                module.registerDefaults();
                if (RegistryModuleLoader.hasCatalogRegistration(module)) {
                    Map<String, ?> map = RegistryModuleLoader.getCatalogMap(module);
                    if (map.isEmpty()) {
                        return;
                    }
                    RegisterCatalog regAnnot = RegistryModuleLoader.getRegisterCatalogAnnot(module);
                    HashSet ignored = regAnnot.ignoredFields().length == 0 ? null : Sets.newHashSet((Object[])regAnnot.ignoredFields());
                    RegistryHelper.mapFields(regAnnot.value(), map, (Set<String>)ignored);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to initialize module: " + module.getClass().getCanonicalName(), e);
        }
    }

    private static Method getCustomRegistration(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            CustomCatalogRegistration registration = method.getDeclaredAnnotation(CustomCatalogRegistration.class);
            if (registration == null) continue;
            return method;
        }
        return null;
    }

    private static boolean requiresCustomRegistration(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            CustomCatalogRegistration registration = method.getDeclaredAnnotation(CustomCatalogRegistration.class);
            if (registration == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCatalogRegistration(RegistryModule module) {
        RegisterCatalog catalog = module.getClass().getAnnotation(RegisterCatalog.class);
        if (catalog != null) {
            return true;
        }
        for (Field field : module.getClass().getDeclaredFields()) {
            RegisterCatalog annotation = field.getAnnotation(RegisterCatalog.class);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultProperPhase(RegistryModule module) {
        try {
            Method method = module.getClass().getMethod("registerDefaults", new Class[0]);
            DelayedRegistration delay = method.getDeclaredAnnotation(DelayedRegistration.class);
            if (delay == null) {
                return SpongeImpl.getRegistry().getPhase() == RegistrationPhase.PRE_REGISTRY;
            }
            return SpongeImpl.getRegistry().getPhase() == delay.value();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isCustomProperPhase(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            CustomCatalogRegistration registration = method.getDeclaredAnnotation(CustomCatalogRegistration.class);
            DelayedRegistration delay = method.getDeclaredAnnotation(DelayedRegistration.class);
            if (registration == null) continue;
            if (delay == null) {
                return SpongeImpl.getRegistry().getPhase() == RegistrationPhase.PRE_REGISTRY;
            }
            return SpongeImpl.getRegistry().getPhase() == delay.value();
        }
        return false;
    }

    private static Map<String, ?> getCatalogMap(RegistryModule module) {
        if (module instanceof AlternateCatalogRegistryModule) {
            return (Map)Preconditions.checkNotNull(((AlternateCatalogRegistryModule)module).provideCatalogMap());
        }
        for (Field field : module.getClass().getDeclaredFields()) {
            RegisterCatalog annotation = field.getAnnotation(RegisterCatalog.class);
            if (annotation == null) continue;
            try {
                field.setAccessible(true);
                Map map = (Map)field.get(module);
                Preconditions.checkState((!map.isEmpty() ? 1 : 0) != 0, (Object)("The registered module: " + module.getClass().getSimpleName() + " cannot have an empty mapping during registration!"));
                return (Map)Preconditions.checkNotNull((Object)map);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().error("Failed to retrieve a registry field from module: " + module.getClass().getCanonicalName());
            }
        }
        throw new IllegalStateException("Registry module does not have a catalog map! Registry: " + module.getClass().getCanonicalName());
    }

    private static RegisterCatalog getRegisterCatalogAnnot(RegistryModule module) {
        RegisterCatalog catalog = module.getClass().getAnnotation(RegisterCatalog.class);
        if (catalog != null) {
            return catalog;
        }
        for (Field field : module.getClass().getDeclaredFields()) {
            RegisterCatalog annotation = field.getAnnotation(RegisterCatalog.class);
            if (annotation == null) continue;
            return annotation;
        }
        throw new IllegalArgumentException("The module does not have a registry to register! " + module.getClass().getCanonicalName());
    }

    private static void invokeCustomRegistration(RegistryModule module, Method method) {
        try {
            if (RegistryModuleLoader.isCustomProperPhase(module)) {
                method.invoke((Object)module, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SpongeImpl.getLogger().error("Error when calling custom catalog registration for module: " + module.getClass().getCanonicalName(), (Throwable)e);
        }
    }

    public static void tryAdditionalRegistration(RegistryModule module) {
        Method additionalRegistration = RegistryModuleLoader.getAdditionalMethod(module);
        if (additionalRegistration != null) {
            try {
                additionalRegistration.invoke((Object)module, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static Method getAdditionalMethod(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            AdditionalRegistration registration = method.getDeclaredAnnotation(AdditionalRegistration.class);
            if (registration == null) continue;
            return method;
        }
        return null;
    }
}

