/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.ban;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.management.UserList;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListIPBans;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.UserListUtils;

public class SpongeBanService
implements BanService {
    public Collection<Ban> getBans() {
        Collection<Ban> bans = this.getProfileBans();
        bans.addAll(this.getIpBans());
        return bans;
    }

    @Override
    public Collection<Ban.Profile> getProfileBans() {
        this.getUserBanList().func_152680_h();
        return new ArrayList<Ban.Profile>(this.getUserBanList().func_152688_e().values());
    }

    @Override
    public Collection<Ban.Ip> getIpBans() {
        this.getIPBanList().func_152680_h();
        return new ArrayList<Ban.Ip>(this.getIPBanList().func_152688_e().values());
    }

    @Override
    public Optional<Ban.Profile> getBanFor(GameProfile profile) {
        UserListBans bans = this.getUserBanList();
        bans.func_152680_h();
        return Optional.ofNullable((Ban.Profile)bans.func_152688_e().get(bans.func_152681_a((com.mojang.authlib.GameProfile)profile)));
    }

    @Override
    public Optional<Ban.Ip> getBanFor(InetAddress address) {
        UserListIPBans bans = this.getIPBanList();
        bans.func_152680_h();
        return Optional.ofNullable((Ban.Ip)bans.func_152688_e().get(bans.func_152681_a((Object)bans.func_152707_c((SocketAddress)new InetSocketAddress(address, 0)))));
    }

    @Override
    public boolean isBanned(GameProfile profile) {
        UserListBans bans = this.getUserBanList();
        bans.func_152680_h();
        return bans.field_152696_d.containsKey(bans.func_152681_a((com.mojang.authlib.GameProfile)profile));
    }

    @Override
    public boolean isBanned(InetAddress address) {
        UserListIPBans bans = this.getIPBanList();
        bans.func_152680_h();
        return bans.func_152688_e().containsKey(bans.func_152681_a((Object)bans.func_152707_c((SocketAddress)new InetSocketAddress(address, 0))));
    }

    @Override
    public boolean pardon(GameProfile profile) {
        this.getUserBanList().func_152680_h();
        boolean hadBan = this.isBanned(profile);
        UserListUtils.removeEntry((UserList)this.getUserBanList(), profile);
        return hadBan;
    }

    @Override
    public boolean pardon(InetAddress address) {
        UserListIPBans banList = this.getIPBanList();
        banList.func_152680_h();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address, 0);
        boolean hadBan = this.isBanned(address);
        UserListUtils.removeEntry((UserList)banList, banList.func_152707_c((SocketAddress)inetSocketAddress));
        return hadBan;
    }

    @Override
    public boolean removeBan(Ban ban) {
        if (ban.getType().equals(BanTypes.PROFILE)) {
            return this.pardon(((Ban.Profile)ban).getProfile());
        }
        if (ban.getType().equals(BanTypes.IP)) {
            return this.pardon(((Ban.Ip)ban).getAddress());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    @Override
    public Optional<? extends Ban> addBan(Ban ban) {
        Optional<Ban> prevBan;
        if (ban.getType().equals(BanTypes.PROFILE)) {
            prevBan = this.getBanFor(((Ban.Profile)ban).getProfile());
            User user = Sponge.getServiceManager().provideUnchecked(UserStorageService.class).getOrCreate(((Ban.Profile)ban).getProfile());
            Sponge.getEventManager().post(SpongeEventFactory.createBanUserEvent(Sponge.getCauseStackManager().getCurrentCause(), (Ban.Profile)ban, user));
            UserListUtils.addEntry((UserList)this.getUserBanList(), (UserListEntry)ban);
        } else if (ban.getType().equals(BanTypes.IP)) {
            prevBan = this.getBanFor(((Ban.Ip)ban).getAddress());
            Sponge.getEventManager().post(SpongeEventFactory.createBanIpEvent(Sponge.getCauseStackManager().getCurrentCause(), (Ban.Ip)ban));
            UserListUtils.addEntry((UserList)this.getIPBanList(), (UserListEntry)ban);
        } else {
            throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
        }
        return prevBan;
    }

    @Override
    public boolean hasBan(Ban ban) {
        if (ban.getType().equals(BanTypes.PROFILE)) {
            return this.isBanned(((Ban.Profile)ban).getProfile());
        }
        if (ban.getType().equals(BanTypes.IP)) {
            return this.isBanned(((Ban.Ip)ban).getAddress());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    private UserListBans getUserBanList() {
        return SpongeImpl.getServer().func_184103_al().func_152608_h();
    }

    private UserListIPBans getIPBanList() {
        return SpongeImpl.getServer().func_184103_al().func_72363_f();
    }
}

