/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.RemoteSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;

public class SpongeContextCalculator
implements ContextCalculator<Subject> {
    private final LoadingCache<RemoteSource, Set<Context>> remoteIpCache = this.buildAddressCache("remoteip", input -> input.getConnection().getAddress().getAddress());
    private final LoadingCache<RemoteSource, Set<Context>> localIpCache = this.buildAddressCache("localip", input -> input.getConnection().getVirtualHost().getAddress());

    private LoadingCache<RemoteSource, Set<Context>> buildAddressCache(final String contextKey, final Function<RemoteSource, InetAddress> function) {
        return CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<RemoteSource, Set<Context>>(){

            public Set<Context> load(RemoteSource key) throws Exception {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                InetAddress addr = (InetAddress)Preconditions.checkNotNull(function.apply(key), (Object)"addr");
                builder.add((Object)new Context(contextKey, addr.getHostAddress()));
                for (String set : Maps.filterValues(SpongeImpl.getGlobalConfig().getConfig().getIpSets(), input -> input.apply((Object)addr)).keySet()) {
                    builder.add((Object)new Context(contextKey, set));
                }
                return builder.build();
            }
        });
    }

    @Override
    public void accumulateContexts(Subject subject, Set<Context> accumulator) {
        Optional<CommandSource> subjSource = subject.getCommandSource();
        if (subjSource.isPresent()) {
            CommandSource source = subjSource.get();
            if (source instanceof Locatable) {
                World currentExt = ((Locatable)((Object)source)).getWorld();
                accumulator.add(currentExt.getContext());
                accumulator.add(currentExt.getDimension().getContext());
            }
            if (source instanceof RemoteSource) {
                RemoteSource rem = (RemoteSource)source;
                accumulator.addAll((Collection)this.remoteIpCache.getUnchecked((Object)rem));
                accumulator.addAll((Collection)this.localIpCache.getUnchecked((Object)rem));
                accumulator.add(new Context("localport", String.valueOf(rem.getConnection().getVirtualHost().getPort())));
                accumulator.add(new Context("localhost", rem.getConnection().getVirtualHost().getHostName()));
            }
        }
    }

    @Override
    public boolean matches(Context context, Subject subject) {
        Optional<CommandSource> subjSource = subject.getCommandSource();
        if (subjSource.isPresent()) {
            CommandSource source = subjSource.get();
            if (source instanceof Locatable && context.getType().equals("world")) {
                Locatable located = (Locatable)((Object)source);
                if (context.getType().equals("world")) {
                    return located.getWorld().getContext().equals(context);
                }
                if (context.getType().equals("dimension")) {
                    return located.getWorld().getDimension().getContext().equals(context);
                }
            }
            if (source instanceof RemoteSource) {
                RemoteSource remote = (RemoteSource)source;
                if (context.getType().equals("localhost")) {
                    return context.getValue().equals(remote.getConnection().getVirtualHost().getHostName());
                }
                if (context.getType().equals("localport")) {
                    return context.getValue().equals(String.valueOf(remote.getConnection().getVirtualHost().getPort()));
                }
                if (context.getType().equals("localip")) {
                    return ((Set)this.localIpCache.getUnchecked((Object)remote)).contains(context);
                }
                if (context.getType().equals("remoteip")) {
                    return ((Set)this.remoteIpCache.getUnchecked((Object)remote)).contains(context);
                }
            }
        }
        return false;
    }
}

