/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.api.data.manipulator.mutable.entity.GameModeData;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentHolder;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.ArgumentTypes;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.text.selector.SelectorTypes;
import org.spongepowered.api.util.Functional;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.OptionalUtils;

public class SelectorResolver {
    private static final Function<CommandSource, String> GET_NAME = CommandSource::getName;
    private static final Vector3d ORIGIN = new Vector3d(0.0f, 0.0f, 0.0f);
    private static final Set<ArgumentType<?>> LOCATION_BASED_ARGUMENTS;
    private static final Function<Number, Double> TO_DOUBLE;
    private static final Collection<SelectorType> INFINITE_TYPES;
    private final Collection<Extent> extents;
    private final Vector3d position;
    private final Optional<CommandSource> original;
    private final Selector selector;
    private final Predicate<Entity> selectorFilter;
    private final boolean alwaysUsePosition;

    private static Extent extentFromSource(CommandSource origin) {
        if (origin instanceof Locatable) {
            return ((Locatable)((Object)origin)).getWorld();
        }
        return null;
    }

    private static Vector3d positionFromSource(CommandSource origin) {
        if (origin instanceof Locatable) {
            return ((Locatable)((Object)origin)).getLocation().getPosition();
        }
        return null;
    }

    private static <I, R> Predicate<I> requireTypePredicate(Class<I> inputType, Class<R> requiredType) {
        return requiredType::isInstance;
    }

    public SelectorResolver(Collection<? extends Extent> extents, Selector selector, boolean force) {
        this(extents, null, null, selector, force);
    }

    public SelectorResolver(Location<World> location, Selector selector, boolean force) {
        this((Collection<? extends Extent>)ImmutableSet.of((Object)location.getExtent()), location.getPosition(), null, selector, force);
    }

    public SelectorResolver(CommandSource origin, Selector selector, boolean force) {
        this(OptionalUtils.asSet(Optional.ofNullable(SelectorResolver.extentFromSource(origin))), SelectorResolver.positionFromSource(origin), origin, selector, force);
    }

    private SelectorResolver(Collection<? extends Extent> extents, Vector3d position, CommandSource original, Selector selector, boolean force) {
        this.extents = ImmutableSet.copyOf(extents);
        this.position = position == null ? ORIGIN : position;
        this.original = Optional.ofNullable(original);
        this.selector = (Selector)Preconditions.checkNotNull((Object)selector);
        this.selectorFilter = this.makeFilter();
        this.alwaysUsePosition = force;
    }

    private Predicate<Entity> makeFilter() {
        boolean isPlayerOnlySelector;
        Selector sel = this.selector;
        Vector3d position = this.getPositionOrDefault(this.position, ArgumentTypes.POSITION);
        ArrayList filters = Lists.newArrayList();
        this.addTypeFilters(filters);
        this.addDimensionFilters(position, filters);
        this.addRadiusFilters(position, filters);
        this.addLevelFilters(filters);
        this.addGamemodeFilters(filters);
        this.addNameFilters(filters);
        this.addRotationFilters(filters);
        this.addTeamFilters(filters);
        this.addScoreFilters(filters);
        SelectorType selectorType = sel.getType();
        Optional<Argument.Invertible<EntityType>> type = sel.getArgument(ArgumentTypes.ENTITY_TYPE);
        boolean bl = isPlayerOnlySelector = selectorType == SelectorTypes.ALL_PLAYERS || selectorType == SelectorTypes.NEAREST_PLAYER || selectorType == SelectorTypes.RANDOM && type.isPresent() && !type.get().isInverted() && type.get().getValue() != EntityTypes.PLAYER;
        if (isPlayerOnlySelector) {
            filters.add(0, SelectorResolver.requireTypePredicate(Entity.class, Player.class));
        }
        return Functional.predicateAnd(filters);
    }

    private void addDimensionFilters(Vector3d position, List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Vector3d boxDimensions = this.getPositionOrDefault(ORIGIN, ArgumentTypes.DIMENSION);
        Vector3d det1 = position;
        Vector3d det2 = position.add(boxDimensions);
        Vector3d boxMin = det1.min(det2);
        Vector3d boxMax = det1.max(det2);
        if (sel.has(ArgumentTypes.DIMENSION.x())) {
            filters.add(input -> {
                Vector3d pos = input.getLocation().getPosition();
                return pos.getX() >= boxMin.getX() && pos.getX() <= boxMax.getX();
            });
        }
        if (sel.has(ArgumentTypes.DIMENSION.y())) {
            filters.add(input -> {
                Vector3d pos = input.getLocation().getPosition();
                return pos.getY() >= boxMin.getY() && pos.getY() <= boxMax.getY();
            });
        }
        if (sel.has(ArgumentTypes.DIMENSION.z())) {
            filters.add(input -> {
                Vector3d pos = input.getLocation().getPosition();
                return pos.getZ() >= boxMin.getZ() && pos.getZ() <= boxMax.getZ();
            });
        }
    }

    private void addGamemodeFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<GameMode> gamemode = sel.get(ArgumentTypes.GAME_MODE);
        if (gamemode.isPresent() && gamemode.get() != GameModes.NOT_SET) {
            GameMode actualMode = gamemode.get();
            filters.add(input -> {
                Optional<GameModeData> mode = input.get(GameModeData.class);
                return mode.isPresent() && mode.get() == actualMode;
            });
        }
    }

    private void addLevelFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<Integer> levelMin = sel.get(ArgumentTypes.LEVEL.minimum());
        Optional<Integer> levelMax = sel.get(ArgumentTypes.LEVEL.maximum());
        if (levelMin.isPresent()) {
            int actualMin = levelMin.get();
            filters.add(input -> {
                Optional<ExperienceHolderData> xp = input.get(ExperienceHolderData.class);
                return xp.isPresent() && (Integer)xp.get().level().get() >= actualMin;
            });
        }
        if (levelMax.isPresent()) {
            int actualMax = levelMax.get();
            filters.add(input -> {
                Optional<ExperienceHolderData> xp = input.get(ExperienceHolderData.class);
                return xp.isPresent() && (Integer)xp.get().level().get() <= actualMax;
            });
        }
    }

    private void addNameFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<Argument.Invertible<String>> nameOpt = sel.getArgument(ArgumentTypes.NAME);
        if (nameOpt.isPresent()) {
            String name = (String)nameOpt.get().getValue();
            boolean inverted = nameOpt.get().isInverted();
            filters.add(input -> {
                Optional<DisplayNameData> dispName = input.get(DisplayNameData.class);
                return inverted ^ (dispName.isPresent() && name.equals(((Text)dispName.get().displayName().get()).toPlain()));
            });
        }
    }

    private void addRadiusFilters(Vector3d position, List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<Integer> radiusMin = sel.get(ArgumentTypes.RADIUS.minimum());
        Optional<Integer> radiusMax = sel.get(ArgumentTypes.RADIUS.maximum());
        if (radiusMin.isPresent()) {
            int radMin = radiusMin.get();
            int radMinSquared = radMin * radMin;
            filters.add(input -> input.getLocation().getPosition().distanceSquared(position) >= (double)radMinSquared);
        }
        if (radiusMax.isPresent()) {
            int radMax = radiusMax.get();
            int radMaxSquared = radMax * radMax;
            filters.add(input -> input.getLocation().getPosition().distanceSquared(position) <= (double)radMaxSquared);
        }
    }

    private void addRotationFilters(List<Predicate<Entity>> filters) {
        Optional<Double> rotMaxY;
        Optional<Double> rotMaxX;
        Optional<Double> rotMinY;
        Selector sel = this.selector;
        Optional<Double> rotMinX = sel.get(ArgumentTypes.ROTATION.minimum().x());
        if (rotMinX.isPresent()) {
            double rmx = rotMinX.get();
            filters.add(input -> input.getRotation().getX() >= rmx);
        }
        if ((rotMinY = sel.get(ArgumentTypes.ROTATION.minimum().y())).isPresent()) {
            double rmy = rotMinY.get();
            filters.add(input -> input.getRotation().getY() >= rmy);
        }
        if ((rotMaxX = sel.get(ArgumentTypes.ROTATION.maximum().x())).isPresent()) {
            double rx = rotMaxX.get();
            filters.add(input -> input.getRotation().getX() <= rx);
        }
        if ((rotMaxY = sel.get(ArgumentTypes.ROTATION.maximum().y())).isPresent()) {
            double ry = rotMaxY.get();
            filters.add(input -> input.getRotation().getY() <= ry);
        }
    }

    private void addScoreFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        sel.getArguments();
    }

    private void addTeamFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<Argument.Invertible<String>> teamOpt = sel.getArgument(ArgumentTypes.TEAM);
        if (teamOpt.isPresent()) {
            Argument.Invertible<String> teamArg = teamOpt.get();
            final boolean inverted = teamArg.isInverted();
            final Set<Team> teams = Sponge.getGame().getServer().getServerScoreboard().get().getTeams();
            filters.add(new Predicate<Entity>(){

                @Override
                public boolean test(Entity input) {
                    if (input instanceof TeamMember) {
                        return inverted ^ this.collectMembers(teams).contains(((TeamMember)((Object)input)).getTeamRepresentation());
                    }
                    return false;
                }

                private Collection<Text> collectMembers(Collection<Team> teams2) {
                    ImmutableSet.Builder users = ImmutableSet.builder();
                    for (Team t : teams2) {
                        users.addAll(t.getMembers());
                    }
                    return users.build();
                }
            });
        }
    }

    private void addTypeFilters(List<Predicate<Entity>> filters) {
        Selector sel = this.selector;
        Optional<Argument.Invertible<EntityType>> typeOpt = sel.getArgument(ArgumentTypes.ENTITY_TYPE);
        if (typeOpt.isPresent()) {
            Argument.Invertible<EntityType> typeArg = typeOpt.get();
            boolean inverted = typeArg.isInverted();
            EntityType type = (EntityType)typeArg.getValue();
            filters.add(input -> inverted ^ input.getType() == type);
        }
    }

    private Vector3d getPositionOrDefault(Vector3d pos, ArgumentHolder.Vector3<?, ? extends Number> vecTypes) {
        Optional<Double> x = this.selector.get(vecTypes.x()).map(TO_DOUBLE);
        Optional<Double> y = this.selector.get(vecTypes.y()).map(TO_DOUBLE);
        Optional<Double> z = this.selector.get(vecTypes.z()).map(TO_DOUBLE);
        return new Vector3d(x.orElse(pos.getX()), y.orElse(pos.getY()), z.orElse(pos.getZ()));
    }

    public String getName() {
        return this.original.map(GET_NAME).orElse("SelectorResolver");
    }

    public Set<Entity> resolve() {
        SelectorType selectorType = this.selector.getType();
        int defaultCount = 1;
        if (INFINITE_TYPES.contains(selectorType)) {
            defaultCount = 0;
        }
        int maxToSelect = this.selector.get(ArgumentTypes.COUNT).orElse(defaultCount);
        Set<? extends Extent> extents = this.getExtentSet();
        int count = 0;
        ImmutableSet.Builder entities = ImmutableSet.builder();
        block0: for (Extent extent : extents) {
            Collection<Entity> allEntities = extent.getEntities();
            if (selectorType == SelectorTypes.RANDOM) {
                ArrayList<Entity> entityList = new ArrayList<Entity>(allEntities);
                Collections.shuffle(entityList);
                allEntities = entityList;
            }
            for (Entity e : allEntities) {
                if (!this.selectorFilter.test(e)) continue;
                entities.add((Object)e);
                if (maxToSelect == 0 || ++count <= maxToSelect) continue;
                continue block0;
            }
        }
        return entities.build();
    }

    private Set<? extends Extent> getExtentSet() {
        if (!this.alwaysUsePosition && Collections.disjoint(this.getArgumentTypes(this.selector.getArguments()), LOCATION_BASED_ARGUMENTS)) {
            return ImmutableSet.copyOf(SpongeImpl.getGame().getServer().getWorlds());
        }
        return ImmutableSet.copyOf(this.extents);
    }

    private Collection<ArgumentType<?>> getArgumentTypes(Collection<Argument<?>> arguments) {
        HashSet types = Sets.newHashSet();
        types.addAll(arguments.stream().map(Argument::getType).collect(Collectors.toList()));
        return types;
    }

    static {
        TO_DOUBLE = Number::doubleValue;
        INFINITE_TYPES = ImmutableSet.of((Object)SelectorTypes.ALL_ENTITIES, (Object)SelectorTypes.ALL_PLAYERS);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(ArgumentTypes.POSITION.getTypes());
        builder.addAll(ArgumentTypes.DIMENSION.getTypes());
        builder.addAll(ArgumentTypes.RADIUS.getTypes());
        LOCATION_BASED_ARGUMENTS = builder.build();
    }
}

