/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.spongepowered.common.util.graph.DirectedGraph;

public class CycleDetector<T> {
    private final DirectedGraph<T> graph;
    private Set<DirectedGraph.DataNode<T>> marked;

    public CycleDetector(DirectedGraph<T> g) {
        this.graph = g;
    }

    public boolean hasCycle() {
        this.marked = Sets.newHashSet();
        ArrayList all = Lists.newArrayList(this.graph.getNodes());
        while (!all.isEmpty()) {
            DirectedGraph.DataNode n = (DirectedGraph.DataNode)all.get(0);
            boolean cycle = this.dfs(n);
            if (cycle) {
                return true;
            }
            all.removeAll(this.marked);
            this.marked.clear();
        }
        return false;
    }

    private boolean dfs(DirectedGraph.DataNode<T> root) {
        this.marked.add(root);
        Iterator<DirectedGraph.DataNode<T>> iterator = root.getAdjacent().iterator();
        if (iterator.hasNext()) {
            DirectedGraph.DataNode<T> a = iterator.next();
            if (!this.marked.contains(a)) {
                return this.dfs(a);
            }
            return true;
        }
        return false;
    }
}

