/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.graph;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.common.util.graph.CycleDetector;
import org.spongepowered.common.util.graph.DirectedGraph;

public class TopologicalOrder<T> {
    private final DirectedGraph<T> digraph;
    private Set<T> marked;

    public TopologicalOrder(DirectedGraph<T> graph) {
        this.digraph = graph;
    }

    @Nullable
    public Iterable<T> order(DirectedGraph.DataNode<T> root) {
        CycleDetector<T> cycleDetector = new CycleDetector<T>(this.digraph);
        if (cycleDetector.hasCycle()) {
            return null;
        }
        this.marked = Sets.newHashSet();
        ArrayDeque order = new ArrayDeque();
        this.dfs(order, root);
        return order;
    }

    private void dfs(ArrayDeque<T> order, DirectedGraph.DataNode<T> root) {
        this.marked.add(root.getData());
        for (DirectedGraph.DataNode<T> n : root.getAdjacent()) {
            if (this.marked.contains(n)) continue;
            this.dfs(order, n);
        }
        order.push(root.getData());
    }

    public static <T> List<T> createOrderedLoad(DirectedGraph<T> graph) {
        ArrayList orderedList = new ArrayList();
        while (graph.getNodeCount() != 0) {
            DirectedGraph.DataNode<T> next = null;
            for (DirectedGraph.DataNode<T> node : graph.getNodes()) {
                if (node.getEdgeCount() != 0) continue;
                next = node;
                break;
            }
            if (next == null) {
                throw new IllegalStateException("Graph is cyclic!");
            }
            orderedList.add(next.getData());
            graph.delete(next);
        }
        return orderedList;
    }
}

