/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.common.interfaces.world.IMixinLocation;

public final class SpongeProxyBlockAccess
implements IBlockAccess {
    private final List<Transaction<BlockSnapshot>> transactions;
    private final List<BlockPos> poses;
    private final LinkedHashMap<BlockPos, IBlockState> processed = new LinkedHashMap();
    private int index;
    private WorldServer processingWorld;

    public SpongeProxyBlockAccess(List<Transaction<BlockSnapshot>> snapshotTransaction) {
        this.transactions = snapshotTransaction;
        this.poses = (List)this.transactions.stream().map(transaction -> ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos()).collect(ImmutableList.toImmutableList());
        this.index = 0;
        this.processingWorld = (WorldServer)snapshotTransaction.get(0).getOriginal().getLocation().get().getExtent();
    }

    public void proceed() {
        this.processed.put(this.poses.get(this.index), (IBlockState)this.transactions.get(this.index).getFinal().getState());
        ++this.index;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.processingWorld != null ? this.processingWorld.func_175625_s(pos) : null;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        BlockPos actualPos;
        if (this.processed.containsKey(pos)) {
            return this.processed.get(pos);
        }
        Transaction<BlockSnapshot> unknown = this.transactions.get(this.index);
        if (unknown != null && pos.equals((Object)(actualPos = this.poses.get(this.index)))) {
            return (IBlockState)unknown.getFinal().getState();
        }
        return this.processingWorld.func_180495_p(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.processingWorld.func_175623_d(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.processingWorld.func_175627_a(pos, direction);
    }
}

