/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;

public class BimapPalette
implements BlockPalette {
    private static final int DEFAULT_ALLOCATION_SIZE = 64;
    private final BiMap<Integer, BlockState> ids;
    private final BiMap<BlockState, Integer> idsr;
    private final BitSet allocation = new BitSet(64);
    private int maxId = 0;

    public BimapPalette() {
        this.ids = HashBiMap.create();
        this.idsr = this.ids.inverse();
    }

    public BimapPalette(int expectedSize) {
        this.ids = HashBiMap.create((int)expectedSize);
        this.idsr = this.ids.inverse();
    }

    @Override
    public BlockPaletteType getType() {
        return BlockPaletteTypes.LOCAL;
    }

    @Override
    public int getHighestId() {
        return this.maxId;
    }

    @Override
    public Optional<Integer> get(BlockState state) {
        return Optional.ofNullable(this.idsr.get((Object)state));
    }

    @Override
    public int getOrAssign(BlockState state) {
        Integer id = (Integer)this.idsr.get((Object)state);
        if (id == null) {
            int next = this.allocation.nextClearBit(0);
            if (this.maxId < next) {
                this.maxId = next;
            }
            this.allocation.set(next);
            this.ids.put((Object)next, (Object)state);
            return next;
        }
        return id;
    }

    @Override
    public Optional<BlockState> get(int id) {
        return Optional.ofNullable(this.ids.get((Object)id));
    }

    public void assign(BlockState state, int id) {
        if (this.maxId < id) {
            this.maxId = id;
        }
        this.allocation.set(id);
        this.ids.put((Object)id, (Object)state);
    }

    @Override
    public boolean remove(BlockState state) {
        Integer id = (Integer)this.idsr.get((Object)state);
        if (id == null) {
            return false;
        }
        this.allocation.clear(id);
        if (id == this.maxId) {
            this.maxId = this.allocation.previousSetBit(this.maxId);
        }
        this.ids.remove((Object)id);
        return true;
    }

    @Override
    public Collection<BlockState> getEntries() {
        return this.idsr.keySet();
    }
}

