/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;

@Singleton
public class SpongeTeleportHelper
implements TeleportHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Location<World>> getSafeLocation(Location<World> location, int height, int width, int distanceToDrop, TeleportHelperFilter filter, TeleportHelperFilter ... additionalFilters) {
        World world = location.getExtent();
        HashSet filters = Sets.newHashSet((Object[])additionalFilters);
        filters.add(filter);
        if (SpongeImpl.getGlobalConfig().getConfig().getTeleportHelper().isForceBlacklistOn()) {
            filters.add(TeleportHelperFilters.CONFIG);
        }
        IMixinChunkProviderServer chunkProviderServer = (IMixinChunkProviderServer)((WorldServer)world).func_72863_F();
        chunkProviderServer.setForceChunkRequests(true);
        try {
            Optional<Vector3i> result = this.getSafeLocation(world, this.getBlockLocations(location, height, width), distanceToDrop, filters);
            Optional<Location<World>> optional = result.map(vector3i -> new Location<World>(world, vector3i.toDouble().add(0.5, 0.0, 0.5)));
            return optional;
        }
        finally {
            chunkProviderServer.setForceChunkRequests(false);
        }
    }

    private Stream<Vector3i> getBlockLocations(Location<World> worldLocation, int height, int width) {
        WorldBorder worldBorder = (WorldBorder)worldLocation.getExtent().getWorldBorder();
        int worldBorderMinX = GenericMath.floor(worldBorder.func_177726_b());
        int worldBorderMinZ = GenericMath.floor(worldBorder.func_177736_c());
        int worldBorderMaxX = GenericMath.floor(worldBorder.func_177728_d());
        int worldBorderMaxZ = GenericMath.floor(worldBorder.func_177733_e());
        int worldMaxY = worldLocation.getExtent().getBlockMax().getY();
        Vector3i vectorLocation = worldLocation.getBlockPosition();
        int minY = GenericMath.clamp(vectorLocation.getY() - height, 0, worldMaxY);
        int maxY = GenericMath.clamp(vectorLocation.getY() + height, 0, worldMaxY);
        int minX = GenericMath.clamp(vectorLocation.getX() - width, worldBorderMinX, worldBorderMaxX);
        int maxX = GenericMath.clamp(vectorLocation.getX() + width, worldBorderMinX, worldBorderMaxX);
        int minZ = GenericMath.clamp(vectorLocation.getZ() - width, worldBorderMinZ, worldBorderMaxZ);
        int maxZ = GenericMath.clamp(vectorLocation.getZ() + width, worldBorderMinZ, worldBorderMaxZ);
        ArrayList<Vector3i> vectors = new ArrayList<Vector3i>();
        for (int y = minY; y <= maxY; ++y) {
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int z = minZ; z <= maxZ; ++z) {
                    vectors.add(new Vector3i(x2, y, z));
                }
            }
        }
        Comparator<Vector3i> c = Comparator.comparingInt(vectorLocation::distanceSquared);
        c = c.thenComparing(x -> -Math.abs(vectorLocation.getY() - x.getY())).thenComparing(x -> -x.getY());
        return vectors.stream().sorted(c);
    }

    private Optional<Vector3i> getSafeLocation(World world, Stream<Vector3i> positionsToCheck, int floorDistanceCheck, Collection<TeleportHelperFilter> filters) {
        HashMap blockCache = new HashMap();
        return positionsToCheck.filter(currentTarget -> {
            ArrayList<TeleportHelperFilter> undefinedResults = new ArrayList<TeleportHelperFilter>();
            for (TeleportHelperFilter filter : filters) {
                Tristate isValid = filter.isValidLocation(world, (Vector3i)currentTarget);
                if (isValid == Tristate.FALSE) {
                    return false;
                }
                if (isValid != Tristate.UNDEFINED) continue;
                undefinedResults.add(filter);
            }
            if (undefinedResults.isEmpty()) {
                return true;
            }
            BlockData block = this.getBlockData((Vector3i)currentTarget, world, blockCache, (Collection<TeleportHelperFilter>)undefinedResults);
            return block.isSafeBody && this.getBlockData(currentTarget.add(0, 1, 0), world, blockCache, undefinedResults).isSafeBody && (floorDistanceCheck <= 0 || this.isFloorSafe((Vector3i)currentTarget, world, blockCache, (Collection<TeleportHelperFilter>)undefinedResults, floorDistanceCheck));
        }).findFirst();
    }

    private boolean isFloorSafe(Vector3i currentTarget, World world, Map<Vector3i, BlockData> blockCache, Collection<TeleportHelperFilter> filters, int floorDistanceCheck) {
        for (int i = 1; i < floorDistanceCheck; ++i) {
            BlockData data = this.getBlockData(currentTarget.sub(0, i, 0), world, blockCache, filters);
            if (data.isSafeFloor) {
                return true;
            }
            if (data.isSafeBody) continue;
            return false;
        }
        return this.getBlockData(currentTarget.sub(0, floorDistanceCheck, 0), world, blockCache, filters).isSafeFloor;
    }

    private BlockData getBlockData(Vector3i vector3i, World world, Map<Vector3i, BlockData> cache, Collection<TeleportHelperFilter> filters) {
        if (vector3i.getY() < 0) {
            return new BlockData();
        }
        if (cache.containsKey(vector3i)) {
            return cache.get(vector3i);
        }
        BlockData data = new BlockData(world.getBlock(vector3i), filters);
        cache.put(vector3i, data);
        return data;
    }

    private class BlockData {
        private final boolean isSafeFloor;
        private final boolean isSafeBody;

        private BlockData() {
            this.isSafeFloor = false;
            this.isSafeBody = false;
        }

        private BlockData(BlockState blockState, Collection<TeleportHelperFilter> filters) {
            this.isSafeFloor = filters.stream().allMatch(x -> x.isSafeFloorMaterial(blockState));
            this.isSafeBody = filters.stream().allMatch(x -> x.isSafeBodyMaterial(blockState));
        }
    }
}

