/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Stage;
import java.io.File;
import java.io.IOException;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.item.Enchantment;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.entity.ai.SpongeEntityAICommonSuperclass;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.interfaces.IMixinServerCommandManager;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.item.recipe.crafting.SpongeCraftingRecipeRegistry;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.registry.type.effect.PotionEffectTypeRegistryModule;
import org.spongepowered.common.registry.type.effect.SoundRegistryModule;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.registry.type.item.EnchantmentRegistryModule;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.service.permission.SpongeContextCalculator;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.sql.SqlServiceImpl;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;
import org.spongepowered.mod.SpongeCoremod;
import org.spongepowered.mod.SpongeModMetadata;
import org.spongepowered.mod.event.SpongeEventHooks;
import org.spongepowered.mod.event.SpongeModEventManager;
import org.spongepowered.mod.inject.SpongeForgeModule;
import org.spongepowered.mod.interfaces.IMixinVillagerProfession;
import org.spongepowered.mod.network.SpongeModMessageHandler;
import org.spongepowered.mod.plugin.MetaModContainer;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;
import org.spongepowered.mod.registry.SpongeForgeModuleRegistry;
import org.spongepowered.mod.registry.SpongeForgeVillagerRegistry;
import org.spongepowered.mod.registry.SpongeGameData;
import org.spongepowered.mod.service.world.SpongeChunkTicketManager;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

public class SpongeMod
extends MetaModContainer {
    public static SpongeMod instance;
    @Inject
    private SpongeGame game;
    @Inject
    private SpongeScheduler scheduler;
    @Inject
    private Logger logger;
    private LoadController controller;
    private File modFile;

    public SpongeMod() throws Exception {
        super(SpongeModMetadata.getSpongeForgeMetadata());
        ModContainerFactory.instance().registerContainerType(Type.getType(Plugin.class), SpongeModPluginContainer.class);
        instance = this;
        this.modFile = SpongeCoremod.modFile;
        Stage stage = SpongeGuice.getInjectorStage((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? Stage.DEVELOPMENT : Stage.PRODUCTION);
        SpongeImpl.getLogger().info("Creating injector in stage '{}'", (Object)stage);
        Guice.createInjector(stage, new SpongeModule(), new SpongeForgeModule());
        SpongeImpl.getRegistry().preRegistryInit();
        SpongeGameData.addRegistryCallback(ForgeRegistries.BLOCKS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey(obj);
            if (key == null || ((IMixinBlock)obj).isDummy()) {
                return;
            }
            BlockTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (BlockType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.ITEMS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey(obj);
            if (key == null) {
                return;
            }
            ItemTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (ItemType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.ENCHANTMENTS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.ENCHANTMENTS.getKey(obj);
            if (key == null) {
                return;
            }
            EnchantmentRegistryModule.getInstance().registerFromGameData(key.toString(), (Enchantment)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.POTIONS, (owner, manager, id, obj, oldObj) -> {
            ResourceLocation key = ForgeRegistries.POTIONS.getKey(obj);
            if (key == null) {
                return;
            }
            PotionEffectTypeRegistryModule.getInstance().registerFromGameData(key.toString(), (PotionEffectType)obj);
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.VILLAGER_PROFESSIONS, (owner, manager, id, obj, oldObj) -> {
            IMixinVillagerProfession mixinProfession = (IMixinVillagerProfession)obj;
            SpongeProfession spongeProfession = new SpongeProfession(id, mixinProfession.getId(), mixinProfession.getProfessionName());
            SpongeProfession registeredProfession = SpongeForgeVillagerRegistry.validateProfession(obj, spongeProfession);
            ProfessionRegistryModule.getInstance().registerAdditionalCatalog(registeredProfession);
            for (VillagerRegistry.VillagerCareer career : mixinProfession.getCareers()) {
                SpongeForgeVillagerRegistry.registerForgeCareer(career);
            }
        });
        SpongeGameData.addRegistryCallback(ForgeRegistries.SOUND_EVENTS, (owner, manager, id, obj, oldObj) -> SoundRegistryModule.inst().registerAdditionalCatalog((SoundType)obj));
        SpongeForgeModuleRegistry.registerForgeData();
        this.game.getEventManager().registerListeners((Object)this, (Object)this);
        SpongeImpl.getInternalPlugins().add((PluginContainer)ForgeModContainer.getInstance());
    }

    public Object getMod() {
        return this;
    }

    public File getSource() {
        return this.modFile;
    }

    public LoadController getController() {
        return this.controller;
    }

    private <T> void registerService(Class<T> serviceClass, T serviceImpl) {
        SpongeImpl.getGame().getServiceManager().setProvider(SpongeImpl.getPlugin(), serviceClass, serviceImpl);
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        this.controller = controller;
        return true;
    }

    public Class<?> getCustomResourcePackClass() {
        if (this.getSource().isDirectory()) {
            return FMLFolderResourcePack.class;
        }
        return FMLFileResourcePack.class;
    }

    @Subscribe
    public void onStateEvent(FMLStateEvent event) {
        if (!event.getClass().equals(FMLConstructionEvent.class)) {
            ((SpongeModEventManager)SpongeImpl.getGame().getEventManager()).post((Event)event, true);
        }
    }

    @Subscribe
    public void onPreInit(FMLPreInitializationEvent event) {
        try {
            SpongeImpl.getGame().getEventManager().registerListeners(SpongeImpl.getPlugin().getInstance().get(), SpongeInternalListeners.getInstance());
            this.registerService(ChunkTicketManager.class, new SpongeChunkTicketManager());
            SpongeBootstrap.initializeServices();
            SpongeBootstrap.initializeCommands();
            SpongeImpl.getRegistry().preInit();
            SpongeModMessageHandler.init();
            Preconditions.checkArgument((boolean)Class.forName("org.spongepowered.api.entity.ai.task.AbstractAITask").getSuperclass().equals(SpongeEntityAICommonSuperclass.class));
            MinecraftForge.EVENT_BUS.register((Object)new SpongeEventHooks());
            SpongeInternalListeners.getInstance().registerServiceCallback(PermissionService.class, input -> input.registerContextCalculator(new SpongeContextCalculator()));
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.register((Object)this.game.getChannelRegistrar());
            if (event.getSide().isServer()) {
                SpongeHooks.enableThreadContentionMonitoring();
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.scheduler.tickSyncScheduler();
        }
    }

    @SubscribeEvent
    public void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        for (CraftingRecipe craftingRecipe : SpongeCraftingRecipeRegistry.getInstance().getCustomRecipes()) {
            event.getRegistry().register((IForgeRegistryEntry)((IRecipe)craftingRecipe));
        }
        SpongeCraftingRecipeRegistry.getInstance().disableRegistrations();
    }

    @SubscribeEvent
    public void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        for (EntityTypeRegistryModule.FutureRegistration registration : EntityTypeRegistryModule.getInstance().getCustomEntities()) {
            EntityRegistry.registerModEntity((ResourceLocation)registration.name, registration.type, (String)registration.name.func_110623_a(), (int)registration.id, (Object)registration.name.func_110624_b(), (int)0, (int)0, (boolean)false);
        }
    }

    @Subscribe
    public void onInitialization(FMLInitializationEvent event) {
        try {
            SpongeImpl.getRegistry().init();
            if (!this.game.getServiceManager().provide(PermissionService.class).isPresent()) {
                SpongePermissionService service = new SpongePermissionService(this.game);
                service.getGroupForOpLevel(1).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.selector", Tristate.TRUE);
                service.getGroupForOpLevel(2).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.commandblock", Tristate.TRUE);
                this.game.getServiceManager().setProvider((Object)this, PermissionService.class, service);
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @Subscribe
    public void onPostInitialization(FMLPostInitializationEvent event) {
        try {
            SpongeImpl.getRegistry().postInit();
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @Subscribe
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        SpongeImpl.getRegistry().registerAdditionals();
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            StaticMixinForgeHelper.registerCustomEntity(entry);
        }
    }

    @Subscribe
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        try {
            ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerEarlyCommands(this.game);
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
        WorldManager.registerVanillaTypesAndDimensions();
    }

    @Subscribe
    public void onServerStarted(FMLServerStartedEvent event) {
        SpongePlayerDataHandler.init();
        try {
            ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerLowPriorityCommands(this.game);
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
    }

    @Subscribe
    public void onServerStopped(FMLServerStoppedEvent event) throws IOException {
        try {
            CommandManager service = this.game.getCommandManager();
            service.getCommands().stream().filter(mapping -> mapping.getCallable() instanceof MinecraftCommandWrapper).forEach(service::removeMapping);
            ((SqlServiceImpl)this.game.getServiceManager().provideUnchecked(SqlService.class)).close();
        }
        catch (Throwable t) {
            this.controller.errorOccurred((ModContainer)this, t);
        }
        WorldManager.unregisterAllWorldSettings();
    }

    public Logger getLogger() {
        return this.logger;
    }
}

