/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.data;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.extra.fluid.FluidStack;
import org.spongepowered.api.extra.fluid.FluidStackSnapshot;
import org.spongepowered.api.extra.fluid.data.manipulator.immutable.ImmutableFluidTankData;
import org.spongepowered.api.extra.fluid.data.manipulator.mutable.FluidTankData;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.mutable.extra.SpongeFluidTankData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;

public class ForgeFluidTankDataProcessor
extends AbstractSingleDataSingleTargetProcessor<TileEntity, Map<Direction, List<FluidStackSnapshot>>, MapValue<Direction, List<FluidStackSnapshot>>, FluidTankData, ImmutableFluidTankData> {
    public ForgeFluidTankDataProcessor() {
        super(Keys.FLUID_TANK_CONTENTS, TileEntity.class);
    }

    @Override
    protected boolean supports(TileEntity dataHolder) {
        for (EnumFacing enumFacing : EnumFacing.values()) {
            if (!dataHolder.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean set(TileEntity dataHolder, Map<Direction, List<FluidStackSnapshot>> value) {
        for (EnumFacing enumFacing : EnumFacing.values()) {
            Direction direction = DirectionFacingProvider.getInstance().getKey(enumFacing).orElseThrow(() -> new IllegalArgumentException("Invalid EnumFacing: " + enumFacing));
            if (!dataHolder.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing)) continue;
            IFluidHandler handler = (IFluidHandler)dataHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, enumFacing);
            IFluidTankProperties[] oldInfo = handler.getTankProperties();
            if (oldInfo != null) {
                for (IFluidTankProperties old : oldInfo) {
                    if (old == null || old.getContents() == null) continue;
                    handler.drain(old.getContents(), true);
                }
            }
            for (FluidStackSnapshot snapshot : value.get((Object)direction)) {
                handler.fill((net.minecraftforge.fluids.FluidStack)snapshot.createStack(), true);
            }
        }
        return true;
    }

    @Override
    protected Optional<Map<Direction, List<FluidStackSnapshot>>> getVal(TileEntity dataHolder) {
        HashMap<Direction, ImmutableList> map = new HashMap<Direction, ImmutableList>();
        for (EnumFacing facing : EnumFacing.values()) {
            IFluidHandler handler;
            IFluidTankProperties[] tankProperties;
            Direction direction = DirectionFacingProvider.getInstance().getKey(facing).get();
            if (!dataHolder.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) || (tankProperties = (handler = (IFluidHandler)dataHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)).getTankProperties()) == null) continue;
            ImmutableList.Builder snapshotBuilder = ImmutableList.builder();
            for (IFluidTankProperties info : tankProperties) {
                FluidStack drained;
                if (info == null || info.getContents() == null || (drained = (FluidStack)handler.drain(info.getContents(), false)) == null) continue;
                snapshotBuilder.add((Object)drained.createSnapshot());
            }
            map.put(direction, snapshotBuilder.build());
        }
        return Optional.of(map);
    }

    @Override
    protected ImmutableValue<Map<Direction, List<FluidStackSnapshot>>> constructImmutableValue(Map<Direction, List<FluidStackSnapshot>> value) {
        return new ImmutableSpongeMapValue<Direction, List<FluidStackSnapshot>>(Keys.FLUID_TANK_CONTENTS, value);
    }

    @Override
    protected MapValue<Direction, List<FluidStackSnapshot>> constructValue(Map<Direction, List<FluidStackSnapshot>> actualValue) {
        return new SpongeMapValue<Direction, List<FluidStackSnapshot>>(Keys.FLUID_TANK_CONTENTS, actualValue);
    }

    @Override
    protected FluidTankData createManipulator() {
        return new SpongeFluidTankData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

