/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.TargetEntityEvent;
import org.spongepowered.api.event.entity.item.TargetItemEvent;
import org.spongepowered.api.event.entity.living.TargetLivingEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.SaveWorldEvent;
import org.spongepowered.api.event.world.TargetWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.event.world.chunk.LoadChunkEvent;
import org.spongepowered.api.event.world.chunk.TargetChunkEvent;
import org.spongepowered.api.event.world.chunk.UnloadChunkEvent;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.IMixinInitCause;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.mod.interfaces.IMixinBlockSnapshot;
import org.spongepowered.mod.interfaces.IMixinEventBus;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

public class SpongeForgeEventFactory {
    public static Class<? extends net.minecraftforge.fml.common.eventhandler.Event> getForgeEventClass(Event spongeEvent) {
        Class<?> clazz = spongeEvent.getClass();
        if (ChangeInventoryEvent.Pickup.class.isAssignableFrom(clazz)) {
            return EntityItemPickupEvent.class;
        }
        if (DestructEntityEvent.Death.class.isAssignableFrom(clazz)) {
            return LivingDeathEvent.class;
        }
        if (InteractBlockEvent.Primary.class.isAssignableFrom(clazz)) {
            return PlayerInteractEvent.class;
        }
        if (InteractBlockEvent.Secondary.class.isAssignableFrom(clazz)) {
            return PlayerInteractEvent.class;
        }
        if (InteractBlockEvent.class.isAssignableFrom(clazz)) {
            return PlayerInteractEvent.class;
        }
        if (InteractEntityEvent.Secondary.class.isAssignableFrom(clazz)) {
            InteractEntityEvent event = (InteractEntityEvent)spongeEvent;
            if (event.getInteractionPoint().isPresent()) {
                return PlayerInteractEvent.EntityInteractSpecific.class;
            }
            return PlayerInteractEvent.EntityInteract.class;
        }
        if (NotifyNeighborBlockEvent.class.isAssignableFrom(clazz)) {
            return BlockEvent.NeighborNotifyEvent.class;
        }
        if (ChangeBlockEvent.Place.class.isAssignableFrom(clazz)) {
            return BlockEvent.PlaceEvent.class;
        }
        if (DropItemEvent.Destruct.class.isAssignableFrom(clazz)) {
            return LivingDropsEvent.class;
        }
        if (DropItemEvent.Dispense.class.isAssignableFrom(clazz)) {
            return ItemTossEvent.class;
        }
        if (ClientConnectionEvent.Join.class.isAssignableFrom(clazz)) {
            return PlayerEvent.PlayerLoggedInEvent.class;
        }
        if (ClientConnectionEvent.Disconnect.class.isAssignableFrom(clazz)) {
            return PlayerEvent.PlayerLoggedOutEvent.class;
        }
        if (RespawnPlayerEvent.class.isAssignableFrom(clazz)) {
            return PlayerEvent.PlayerRespawnEvent.class;
        }
        if (MoveEntityEvent.Teleport.class.isAssignableFrom(clazz)) {
            return EntityTravelToDimensionEvent.class;
        }
        if (SpawnEntityEvent.class.isAssignableFrom(clazz)) {
            return EntityJoinWorldEvent.class;
        }
        if (LoadWorldEvent.class.isAssignableFrom(clazz)) {
            return WorldEvent.Load.class;
        }
        if (UnloadWorldEvent.class.isAssignableFrom(clazz)) {
            return WorldEvent.Unload.class;
        }
        if (SaveWorldEvent.Post.class.isAssignableFrom(clazz)) {
            return WorldEvent.Save.class;
        }
        if (LoadChunkEvent.class.isAssignableFrom(clazz)) {
            return ChunkEvent.Load.class;
        }
        if (UnloadChunkEvent.class.isAssignableFrom(clazz)) {
            return ChunkEvent.Unload.class;
        }
        return null;
    }

    public static EventBus getForgeEventBus(Class<?> clazz) {
        if (OreGenEvent.class.isAssignableFrom(clazz)) {
            return MinecraftForge.ORE_GEN_BUS;
        }
        if (WorldTypeEvent.class.isAssignableFrom(clazz) || BiomeEvent.class.isAssignableFrom(clazz) || DecorateBiomeEvent.class.isAssignableFrom(clazz) || InitMapGenEvent.class.isAssignableFrom(clazz) || InitNoiseGensEvent.class.isAssignableFrom(clazz) || PopulateChunkEvent.class.isAssignableFrom(clazz) || SaplingGrowTreeEvent.class.isAssignableFrom(clazz)) {
            return MinecraftForge.TERRAIN_GEN_BUS;
        }
        return MinecraftForge.EVENT_BUS;
    }

    public static Event createSpongeEvent(net.minecraftforge.fml.common.eventhandler.Event forgeEvent) {
        if (forgeEvent instanceof BlockEvent.PlaceEvent) {
            return SpongeForgeEventFactory.createChangeBlockEventPlace((BlockEvent.PlaceEvent)forgeEvent);
        }
        if (forgeEvent instanceof BlockEvent.MultiPlaceEvent) {
            return SpongeForgeEventFactory.createChangeBlockEventPlace((BlockEvent.MultiPlaceEvent)forgeEvent);
        }
        if (forgeEvent instanceof BlockEvent.BreakEvent) {
            return SpongeForgeEventFactory.createChangeBlockEventPre((BlockEvent.BreakEvent)forgeEvent);
        }
        if (forgeEvent instanceof ServerChatEvent) {
            return SpongeForgeEventFactory.createMessageChannelEventChat((ServerChatEvent)forgeEvent);
        }
        if (forgeEvent instanceof PlayerSleepInBedEvent) {
            return SpongeForgeEventFactory.createSleepingEventPre((PlayerSleepInBedEvent)forgeEvent);
        }
        if (forgeEvent instanceof ChunkEvent.Load) {
            return SpongeForgeEventFactory.createLoadChunkEvent((ChunkEvent.Load)forgeEvent);
        }
        if (forgeEvent instanceof ChunkEvent.Unload) {
            return SpongeForgeEventFactory.createUnloadChunkEvent((ChunkEvent.Unload)forgeEvent);
        }
        return null;
    }

    public static ChangeBlockEvent.Pre createChangeBlockEventPre(BlockEvent.BreakEvent forgeEvent) {
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        BlockPos pos = forgeEvent.getPos();
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        EntityPlayer player = forgeEvent.getPlayer();
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        }
        Sponge.getCauseStackManager().pushCause(player);
        if (owner != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, owner);
        }
        if (notifier != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier);
        }
        Sponge.getCauseStackManager().addContext(EventContextKeys.PLAYER_BREAK, (World)world);
        return SpongeEventFactory.createChangeBlockEventPre(Sponge.getCauseStackManager().getCurrentCause(), (List)ImmutableList.of(new Location<World>((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())));
    }

    public static ChangeBlockEvent.Break createChangeBlockEventBreak(BlockEvent.BreakEvent forgeEvent) {
        BlockPos pos = forgeEvent.getPos();
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        org.spongepowered.api.block.BlockSnapshot originalSnapshot = ((World)forgeEvent.getWorld()).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        org.spongepowered.api.block.BlockSnapshot finalSnapshot = BlockTypes.AIR.getDefaultState().snapshotFor(new Location<World>((World)world, VecHelper.toVector3d(pos)));
        ImmutableList blockSnapshots = new ImmutableList.Builder().add(new Transaction<org.spongepowered.api.block.BlockSnapshot>(originalSnapshot, finalSnapshot)).build();
        Object builder = null;
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        EntityPlayer player = forgeEvent.getPlayer();
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        }
        Sponge.getCauseStackManager().pushCause(player);
        if (owner != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, owner);
        }
        if (notifier != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier);
        }
        Sponge.getCauseStackManager().addContext(EventContextKeys.PLAYER_BREAK, (World)world);
        return SpongeEventFactory.createChangeBlockEventBreak(Sponge.getCauseStackManager().getCurrentCause(), (List)blockSnapshots);
    }

    public static ChangeBlockEvent.Place createChangeBlockEventPlace(BlockEvent.PlaceEvent forgeEvent) {
        BlockPos pos = forgeEvent.getPos();
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        org.spongepowered.api.block.BlockSnapshot originalSnapshot = ((IMixinBlockSnapshot)forgeEvent.getBlockSnapshot()).createSpongeBlockSnapshot();
        org.spongepowered.api.block.BlockSnapshot finalSnapshot = ((BlockState)forgeEvent.getPlacedBlock()).snapshotFor(new Location<World>((World)world, VecHelper.toVector3d(pos)));
        ImmutableList blockSnapshots = new ImmutableList.Builder().add(new Transaction<org.spongepowered.api.block.BlockSnapshot>(originalSnapshot, finalSnapshot)).build();
        Object builder = null;
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        EntityPlayer player = forgeEvent.getPlayer();
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.FAKE_PLAYER, EntityUtil.toPlayer(player));
        }
        Sponge.getCauseStackManager().pushCause(player);
        if (owner != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, owner);
        }
        if (notifier != null) {
            Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier);
        }
        Sponge.getCauseStackManager().addContext(EventContextKeys.PLAYER_PLACE, (World)world);
        return SpongeEventFactory.createChangeBlockEventPlace(Sponge.getCauseStackManager().getCurrentCause(), (List)blockSnapshots);
    }

    public static ChangeBlockEvent.Place createChangeBlockEventPlace(BlockEvent.MultiPlaceEvent forgeEvent) {
        net.minecraft.world.World world = forgeEvent.getWorld();
        if (world.field_72995_K) {
            return null;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BlockSnapshot blockSnapshot : forgeEvent.getReplacedBlockSnapshots()) {
            BlockPos snapshotPos = blockSnapshot.getPos();
            org.spongepowered.api.block.BlockSnapshot originalSnapshot = ((IMixinBlockSnapshot)blockSnapshot).createSpongeBlockSnapshot();
            org.spongepowered.api.block.BlockSnapshot finalSnapshot = ((World)world).createSnapshot(snapshotPos.func_177958_n(), snapshotPos.func_177956_o(), snapshotPos.func_177952_p());
            builder.add(new Transaction<org.spongepowered.api.block.BlockSnapshot>(originalSnapshot, finalSnapshot));
        }
        Sponge.getCauseStackManager().pushCause(forgeEvent.getPlayer());
        return SpongeEventFactory.createChangeBlockEventPlace(Sponge.getCauseStackManager().getCurrentCause(), (List)builder.build());
    }

    public static MessageChannelEvent.Chat createMessageChannelEventChat(ServerChatEvent forgeEvent) {
        MessageChannel channel;
        ITextComponent forgeComponent = forgeEvent.getComponent();
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter();
        Text[] chat = SpongeTexts.splitChatMessage((TextComponentTranslation)forgeComponent);
        if (chat[1] == null) {
            chat[1] = chat[0] != null ? chat[0] : SpongeTexts.toText(forgeComponent);
            chat[0] = null;
        }
        if (chat[0] != null) {
            formatter.getHeader().add(new MessageEvent.DefaultHeaderApplier(chat[0]));
        }
        formatter.getBody().add(new MessageEvent.DefaultBodyApplier(chat[1]));
        LiteralText rawSpongeMessage = Text.of(forgeEvent.getMessage());
        MessageChannel originalChannel = channel = ((Player)forgeEvent.getPlayer()).getMessageChannel();
        Sponge.getCauseStackManager().pushCause(forgeEvent.getPlayer());
        return SpongeEventFactory.createMessageChannelEventChat(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.ofNullable(channel), formatter, rawSpongeMessage, false);
    }

    public static SleepingEvent.Pre createSleepingEventPre(PlayerSleepInBedEvent forgeEvent) {
        net.minecraft.world.World world = forgeEvent.getEntity().func_130014_f_();
        if (world.field_72995_K) {
            return null;
        }
        BlockPos pos = forgeEvent.getPos();
        org.spongepowered.api.block.BlockSnapshot bedSnapshot = ((World)world).createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Sponge.getCauseStackManager().pushCause(forgeEvent.getEntity());
        return SpongeEventFactory.createSleepingEventPre(Sponge.getCauseStackManager().getCurrentCause(), bedSnapshot, (Entity)forgeEvent.getEntity());
    }

    public static LoadChunkEvent createLoadChunkEvent(ChunkEvent.Load forgeEvent) {
        boolean isMainThread;
        boolean bl = isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (isMainThread) {
            Sponge.getCauseStackManager().pushCause(forgeEvent.getWorld());
        }
        Cause cause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), forgeEvent.getWorld());
        return SpongeEventFactory.createLoadChunkEvent(cause, (Chunk)forgeEvent.getChunk());
    }

    public static UnloadChunkEvent createUnloadChunkEvent(ChunkEvent.Unload forgeEvent) {
        boolean isMainThread;
        boolean bl = isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        if (isMainThread) {
            Sponge.getCauseStackManager().pushCause(forgeEvent.getWorld());
        }
        Cause cause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), forgeEvent.getWorld());
        return SpongeEventFactory.createUnloadChunkEvent(cause, (Chunk)forgeEvent.getChunk());
    }

    public static Event callForgeEvent(Event spongeEvent, Class<? extends net.minecraftforge.fml.common.eventhandler.Event> clazz) {
        if (EntityItemPickupEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callEntityItemPickupEvent(spongeEvent);
        }
        if (PlayerInteractEvent.EntityInteractSpecific.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callEntityInteractEvent(spongeEvent);
        }
        if (PlayerInteractEvent.EntityInteract.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callEntityInteractEvent(spongeEvent);
        }
        if (BlockEvent.NeighborNotifyEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callNeighborNotifyEvent(spongeEvent);
        }
        if (BlockEvent.PlaceEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callBlockPlaceEvent(spongeEvent);
        }
        if (PlayerInteractEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.createPlayerInteractEvent(spongeEvent);
        }
        if (LivingDropsEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callLivingDropsEvent(spongeEvent);
        }
        if (ItemTossEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callItemTossEvent(spongeEvent);
        }
        if (PlayerEvent.PlayerLoggedInEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callPlayerLoggedInEvent(spongeEvent);
        }
        if (PlayerEvent.PlayerLoggedOutEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callPlayerLoggedOutEvent(spongeEvent);
        }
        if (PlayerEvent.PlayerRespawnEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callPlayerRespawnEvent(spongeEvent);
        }
        if (EntityTravelToDimensionEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callEntityTravelToDimensionEvent(spongeEvent);
        }
        if (EntityJoinWorldEvent.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callEntityJoinWorldEvent(spongeEvent);
        }
        if (WorldEvent.Unload.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callWorldUnloadEvent(spongeEvent);
        }
        if (WorldEvent.Load.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callWorldLoadEvent(spongeEvent);
        }
        if (WorldEvent.Save.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callWorldSaveEvent(spongeEvent);
        }
        if (ChunkEvent.Load.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callChunkLoadEvent(spongeEvent);
        }
        if (ChunkEvent.Unload.class.isAssignableFrom(clazz)) {
            return SpongeForgeEventFactory.callChunkUnloadEvent(spongeEvent);
        }
        return spongeEvent;
    }

    private static LivingDropsEvent createLivingDropItemEvent(Event event) {
        DropItemEvent.Destruct spongeEvent = (DropItemEvent.Destruct)event;
        Optional<EntityLivingBase> spawnCause = spongeEvent.getCause().first(EntityLivingBase.class);
        if (!spawnCause.isPresent()) {
            return null;
        }
        Optional<org.spongepowered.api.event.cause.entity.damage.source.DamageSource> source = spongeEvent.getCause().first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class);
        if (!source.isPresent()) {
            return null;
        }
        ArrayList<EntityItem> items = new ArrayList<EntityItem>();
        for (Entity entity : spongeEvent.getEntities()) {
            if (!(entity instanceof EntityItem)) continue;
            items.add((EntityItem)entity);
        }
        LivingDropsEvent forgeEvent = new LivingDropsEvent(spawnCause.get(), (DamageSource)source.get(), items, 0, false);
        return forgeEvent;
    }

    public static BlockEvent createBlockEvent(Event event) {
        ChangeBlockEvent spongeEvent = (ChangeBlockEvent)event;
        Location<World> location = spongeEvent.getTransactions().get(0).getOriginal().getLocation().get();
        net.minecraft.world.World world = (net.minecraft.world.World)location.getExtent();
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockEvent forgeEvent = new BlockEvent(world, pos, world.func_180495_p(pos));
        return forgeEvent;
    }

    public static BlockEvent.BreakEvent createBlockBreakEvent(Event event) {
        ChangeBlockEvent.Break spongeEvent = (ChangeBlockEvent.Break)event;
        Location<World> location = spongeEvent.getTransactions().get(0).getOriginal().getLocation().get();
        net.minecraft.world.World world = (net.minecraft.world.World)location.getExtent();
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        IBlockState state = (IBlockState)location.getBlock();
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        BlockEvent.BreakEvent forgeEvent = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)player.get());
        return forgeEvent;
    }

    public static BlockEvent.PlaceEvent createBlockPlaceEvent(Event event) {
        ChangeBlockEvent.Place spongeEvent = (ChangeBlockEvent.Place)event;
        Location<World> location = spongeEvent.getTransactions().get(0).getOriginal().getLocation().get();
        net.minecraft.world.World world = (net.minecraft.world.World)location.getExtent();
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        org.spongepowered.api.block.BlockSnapshot replacementBlock = spongeEvent.getTransactions().get(0).getFinal();
        IBlockState state = (IBlockState)replacementBlock.getState();
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        BlockSnapshot forgeSnapshot = new BlockSnapshot(world, pos, state);
        BlockEvent.PlaceEvent forgeEvent = new BlockEvent.PlaceEvent(forgeSnapshot, world.func_180495_p(pos), (EntityPlayer)player.get(), ((EntityPlayer)player.get()).func_184600_cs());
        return forgeEvent;
    }

    public static EntityEvent createEntityEvent(Event event) {
        TargetEntityEvent spongeEvent = (TargetEntityEvent)event;
        EntityEvent forgeEvent = new EntityEvent((net.minecraft.entity.Entity)spongeEvent.getTargetEntity());
        return forgeEvent;
    }

    public static EntityEvent.EntityConstructing createEntityConstructingEvent(Event event) {
        ConstructEntityEvent.Post spongeEvent = (ConstructEntityEvent.Post)event;
        EntityEvent.EntityConstructing forgeEvent = new EntityEvent.EntityConstructing((net.minecraft.entity.Entity)spongeEvent.getTargetEntity());
        return forgeEvent;
    }

    public static AttackEntityEvent createAttackEntityEvent(Event event) {
        InteractEntityEvent.Primary spongeEvent = (InteractEntityEvent.Primary)event;
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        AttackEntityEvent forgeEvent = new AttackEntityEvent((EntityPlayer)player.get(), (net.minecraft.entity.Entity)spongeEvent.getTargetEntity());
        return forgeEvent;
    }

    public static LivingEvent createLivingEvent(Event event) {
        TargetLivingEvent spongeEvent = (TargetLivingEvent)event;
        LivingEvent forgeEvent = new LivingEvent((EntityLivingBase)spongeEvent.getTargetEntity());
        return forgeEvent;
    }

    public static LivingDeathEvent createLivingDeathEvent(Event event) {
        DestructEntityEvent.Death spongeEvent = (DestructEntityEvent.Death)event;
        Optional<org.spongepowered.api.event.cause.entity.damage.source.DamageSource> source = spongeEvent.getCause().first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class);
        if (!source.isPresent()) {
            return null;
        }
        LivingDeathEvent forgeEvent = new LivingDeathEvent((EntityLivingBase)spongeEvent.getTargetEntity(), (DamageSource)source.get());
        return forgeEvent;
    }

    public static PlayerSleepInBedEvent createPlayerSleepInBedEvent(Event event) {
        SleepingEvent.Pre spongeEvent = (SleepingEvent.Pre)event;
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        Location<World> location = spongeEvent.getBed().getLocation().get();
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return new PlayerSleepInBedEvent((EntityPlayer)player.get(), pos);
    }

    public static LivingEntityUseItemEvent.Start createPlayerUseItemStartEvent(Event event) {
        UseItemStackEvent.Start spongeEvent = (UseItemStackEvent.Start)event;
        Optional<Living> living = spongeEvent.getCause().first(Living.class);
        if (!living.isPresent()) {
            return null;
        }
        ItemStack itemstack = (ItemStack)spongeEvent.getItemStackInUse().createStack();
        LivingEntityUseItemEvent.Start forgeEvent = new LivingEntityUseItemEvent.Start((EntityLivingBase)living.get(), itemstack, spongeEvent.getRemainingDuration());
        return forgeEvent;
    }

    public static LivingEntityUseItemEvent.Tick createPlayerUseItemTickEvent(Event event) {
        UseItemStackEvent.Tick spongeEvent = (UseItemStackEvent.Tick)event;
        Optional<Living> living = spongeEvent.getCause().first(Living.class);
        if (!living.isPresent()) {
            return null;
        }
        ItemStack itemstack = (ItemStack)spongeEvent.getItemStackInUse().createStack();
        LivingEntityUseItemEvent.Tick forgeEvent = new LivingEntityUseItemEvent.Tick((EntityLivingBase)living.get(), itemstack, spongeEvent.getRemainingDuration());
        return forgeEvent;
    }

    public static LivingEntityUseItemEvent.Stop createPlayerUseItemStopEvent(Event event) {
        UseItemStackEvent.Stop spongeEvent = (UseItemStackEvent.Stop)event;
        Optional<Living> living = spongeEvent.getCause().first(Living.class);
        if (!living.isPresent()) {
            return null;
        }
        ItemStack itemstack = (ItemStack)spongeEvent.getItemStackInUse().createStack();
        LivingEntityUseItemEvent.Stop forgeEvent = new LivingEntityUseItemEvent.Stop((EntityLivingBase)living.get(), itemstack, spongeEvent.getRemainingDuration());
        return forgeEvent;
    }

    public static LivingEntityUseItemEvent.Finish createPlayerUseItemFinishEvent(Event event) {
        UseItemStackEvent.Finish spongeEvent = (UseItemStackEvent.Finish)event;
        Optional<Living> living = spongeEvent.getCause().first(Living.class);
        if (!living.isPresent()) {
            return null;
        }
        ItemStack itemstack = (ItemStack)spongeEvent.getItemStackInUse().createStack();
        LivingEntityUseItemEvent.Finish forgeEvent = new LivingEntityUseItemEvent.Finish((EntityLivingBase)living.get(), itemstack, spongeEvent.getRemainingDuration(), itemstack);
        return forgeEvent;
    }

    public static ItemEvent createItemEvent(Event event) {
        TargetItemEvent spongeEvent = (TargetItemEvent)event;
        ItemEvent forgeEvent = new ItemEvent((EntityItem)spongeEvent.getTargetEntity());
        return forgeEvent;
    }

    public static ItemTossEvent createItemTossEvent(Event event) {
        DropItemEvent.Dispense spongeEvent;
        List<Entity> entities;
        Optional<Player> player = event.getCause().first(Player.class);
        if (player.isPresent() && !(entities = (spongeEvent = (DropItemEvent.Dispense)event).getEntities()).isEmpty()) {
            ItemTossEvent forgeEvent = new ItemTossEvent((EntityItem)entities.get(0), (EntityPlayer)player.get());
            return forgeEvent;
        }
        return null;
    }

    public static WorldEvent createWorldEvent(Event event) {
        TargetWorldEvent spongeEvent = (TargetWorldEvent)event;
        WorldEvent forgeEvent = new WorldEvent((net.minecraft.world.World)spongeEvent.getTargetWorld());
        return forgeEvent;
    }

    public static ChunkEvent createChunkEvent(Event event) {
        TargetChunkEvent spongeEvent = (TargetChunkEvent)event;
        ChunkEvent forgeEvent = new ChunkEvent((net.minecraft.world.chunk.Chunk)spongeEvent.getTargetChunk());
        return forgeEvent;
    }

    public static ChunkEvent.Load createChunkLoadEvent(Event event) {
        LoadChunkEvent spongeEvent = (LoadChunkEvent)event;
        ChunkEvent.Load forgeEvent = new ChunkEvent.Load((net.minecraft.world.chunk.Chunk)spongeEvent.getTargetChunk());
        return forgeEvent;
    }

    public static ChunkEvent.Unload createChunkUnloadEvent(Event event) {
        UnloadChunkEvent spongeEvent = (UnloadChunkEvent)event;
        ChunkEvent.Unload forgeEvent = new ChunkEvent.Unload((net.minecraft.world.chunk.Chunk)spongeEvent.getTargetChunk());
        return forgeEvent;
    }

    public static net.minecraftforge.event.world.ExplosionEvent createExplosionEvent(Event event) {
        ExplosionEvent spongeEvent = (ExplosionEvent)event;
        Optional<World> world = spongeEvent.getCause().first(World.class);
        if (!world.isPresent()) {
            return null;
        }
        net.minecraft.world.World forgeWorld = (net.minecraft.world.World)world.get();
        Explosion explosion = (Explosion)spongeEvent.getExplosion();
        net.minecraftforge.event.world.ExplosionEvent forgeEvent = new net.minecraftforge.event.world.ExplosionEvent(forgeWorld, explosion);
        return forgeEvent;
    }

    public static ExplosionEvent.Start createExplosionStartEvent(Event event) {
        ExplosionEvent.Pre spongeEvent = (ExplosionEvent.Pre)event;
        Optional<World> world = spongeEvent.getCause().first(World.class);
        if (!world.isPresent()) {
            return null;
        }
        net.minecraft.world.World forgeWorld = (net.minecraft.world.World)world.get();
        Explosion explosion = (Explosion)spongeEvent.getExplosion();
        ExplosionEvent.Start forgeEvent = new ExplosionEvent.Start(forgeWorld, explosion);
        return forgeEvent;
    }

    public static ExplosionEvent.Detonate createExplosionDetonateEvent(Event event) {
        ExplosionEvent.Detonate spongeEvent = (ExplosionEvent.Detonate)event;
        net.minecraft.world.World forgeWorld = (net.minecraft.world.World)spongeEvent.getTargetWorld();
        Explosion explosion = (Explosion)spongeEvent.getExplosion();
        ExplosionEvent.Detonate forgeEvent = new ExplosionEvent.Detonate(forgeWorld, explosion, spongeEvent.getEntities());
        return forgeEvent;
    }

    private static ServerChatEvent createServerChatEvent(Event event) {
        MessageChannelEvent.Chat spongeEvent = (MessageChannelEvent.Chat)event;
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        Text spongeText = spongeEvent.getOriginalMessage();
        ITextComponent component = SpongeTexts.toComponent(spongeText);
        if (!(component instanceof TextComponentTranslation)) {
            component = new TextComponentTranslation("%s", new Object[]{component});
        }
        ServerChatEvent forgeEvent = new ServerChatEvent((EntityPlayerMP)player.get(), spongeEvent.getOriginalMessage().toPlain(), (ITextComponent)((TextComponentTranslation)component));
        ((IMixinInitCause)forgeEvent).initCause(spongeEvent.getCause());
        return forgeEvent;
    }

    public static void onForgePost(net.minecraftforge.fml.common.eventhandler.Event forgeEvent) {
        if (forgeEvent instanceof ExplosionEvent.Detonate) {
            ExplosionEvent.Detonate explosionEvent = (ExplosionEvent.Detonate)forgeEvent;
            if (!explosionEvent.getExplosion().field_82755_b) {
                List affectedBlocks = explosionEvent.getExplosion().func_180343_e();
                affectedBlocks.clear();
            }
        }
    }

    private static InteractBlockEvent createPlayerInteractEvent(Event event) {
        InteractBlockEvent spongeEvent = (InteractBlockEvent)event;
        Player player = spongeEvent.getCause().first(Player.class).orElse(null);
        if (player == null || spongeEvent instanceof InteractBlockEvent.Primary && spongeEvent.getTargetBlock() == org.spongepowered.api.block.BlockSnapshot.NONE) {
            return spongeEvent;
        }
        BlockPos pos = VecHelper.toBlockPos(spongeEvent.getTargetBlock().getPosition());
        EnumFacing face = DirectionFacingProvider.getInstance().get(spongeEvent.getTargetSide()).orElse(null);
        Vec3d hitVec = null;
        EntityPlayerMP entityPlayerMP = EntityUtil.toNative(player);
        if (spongeEvent.getInteractionPoint().isPresent()) {
            hitVec = VecHelper.toVec3d(spongeEvent.getInteractionPoint().get());
        }
        if (spongeEvent instanceof InteractBlockEvent.Primary) {
            PlayerInteractEvent.LeftClickBlock forgeEvent = new PlayerInteractEvent.LeftClickBlock((EntityPlayer)entityPlayerMP, pos, face, hitVec);
            ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
            if (forgeEvent.isCanceled()) {
                spongeEvent.setCancelled(true);
            }
        } else if (face != null && spongeEvent instanceof InteractBlockEvent.Secondary) {
            EnumHand hand = spongeEvent instanceof InteractBlockEvent.Secondary.MainHand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            PlayerInteractEvent.RightClickBlock forgeEvent = new PlayerInteractEvent.RightClickBlock((EntityPlayer)entityPlayerMP, hand, pos, face, hitVec);
            ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
            if (forgeEvent.isCanceled()) {
                spongeEvent.setCancelled(true);
            }
            if (forgeEvent.getUseItem() != Event.Result.DEFAULT) {
                ((InteractBlockEvent.Secondary)spongeEvent).setUseItemResult(SpongeForgeEventFactory.getTristateFromResult(forgeEvent.getUseItem()));
            }
            if (forgeEvent.getUseBlock() != Event.Result.DEFAULT) {
                ((InteractBlockEvent.Secondary)spongeEvent).setUseBlockResult(SpongeForgeEventFactory.getTristateFromResult(forgeEvent.getUseBlock()));
            }
        }
        return spongeEvent;
    }

    private static Tristate getTristateFromResult(Event.Result result) {
        if (result == Event.Result.ALLOW) {
            return Tristate.TRUE;
        }
        if (result == Event.Result.DENY) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }

    public static ChangeInventoryEvent.Pickup callEntityItemPickupEvent(Event event) {
        ChangeInventoryEvent.Pickup spongeEvent = (ChangeInventoryEvent.Pickup)event;
        EntityItem entityItem = (EntityItem)spongeEvent.getTargetEntity();
        EntityItemPickupEvent forgeEvent = new EntityItemPickupEvent((EntityPlayer)spongeEvent.getCause().first(Player.class).get(), entityItem);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        if (forgeEvent.isCanceled()) {
            spongeEvent.setCancelled(true);
        }
        return spongeEvent;
    }

    public static DestructEntityEvent.Death callLivingDeathEvent(Event event) {
        DestructEntityEvent.Death spongeEvent = (DestructEntityEvent.Death)event;
        if (!spongeEvent.getCause().first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class).isPresent()) {
            return spongeEvent;
        }
        EntityLivingBase entity = (EntityLivingBase)spongeEvent.getTargetEntity();
        DamageSource damageSource = (DamageSource)spongeEvent.getCause().first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class).get();
        LivingDeathEvent forgeEvent = new LivingDeathEvent(entity, damageSource);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        return spongeEvent;
    }

    public static DropItemEvent.Destruct callLivingDropsEvent(Event event) {
        DropItemEvent.Destruct spongeEvent = (DropItemEvent.Destruct)event;
        Cause cause = spongeEvent.getCause();
        Object source = cause.root();
        Optional<org.spongepowered.api.event.cause.entity.damage.source.DamageSource> damageSource = cause.first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class);
        Optional<net.minecraft.entity.Entity> spawnEntity = cause.first(net.minecraft.entity.Entity.class);
        Optional<SpawnType> spawnType = cause.getContext().get(EventContextKeys.SPAWN_TYPE);
        if (!(spawnType.isPresent() && damageSource.isPresent() && spawnEntity.isPresent())) {
            SpongeForgeEventFactory.callEntityJoinWorldEvent(spongeEvent);
            return spongeEvent;
        }
        net.minecraft.entity.Entity entity = spawnEntity.get();
        if (entity == null || !(entity instanceof EntityLivingBase)) {
            return spongeEvent;
        }
        LivingDropsEvent forgeEvent = null;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            forgeEvent = new PlayerDropsEvent(player, (DamageSource)damageSource.get(), spongeEvent.getEntities(), ((IMixinEntityLivingBase)entity).getRecentlyHit() > 0);
        } else {
            forgeEvent = new LivingDropsEvent((EntityLivingBase)entity, (DamageSource)damageSource.get(), spongeEvent.getEntities(), 0, ((IMixinEntityLivingBase)entity).getRecentlyHit() > 0);
        }
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        if (forgeEvent.isCanceled()) {
            spongeEvent.setCancelled(true);
        } else {
            SpongeForgeEventFactory.callEntityJoinWorldEvent(spongeEvent);
        }
        return spongeEvent;
    }

    public static DropItemEvent.Dispense callItemTossEvent(Event event) {
        DropItemEvent.Dispense spongeEvent = (DropItemEvent.Dispense)event;
        if (spongeEvent.getEntities().size() <= 0) {
            return spongeEvent;
        }
        Cause cause = spongeEvent.getCause();
        Object source = cause.root();
        Optional<org.spongepowered.api.event.cause.entity.damage.source.DamageSource> damageSource = cause.first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class);
        Optional<net.minecraft.entity.Entity> spawnEntity = cause.first(net.minecraft.entity.Entity.class);
        Optional<SpawnType> spawnType = cause.getContext().get(EventContextKeys.SPAWN_TYPE);
        if (!(spawnType.isPresent() && damageSource.isPresent() && spawnEntity.isPresent())) {
            SpongeForgeEventFactory.callEntityJoinWorldEvent(spongeEvent);
            return spongeEvent;
        }
        net.minecraft.entity.Entity entity = spawnEntity.get();
        EntityItem item = (EntityItem)spongeEvent.getEntities().get(0);
        if (entity == null || item == null || item.func_92059_d() == null || !(entity instanceof Player)) {
            return spongeEvent;
        }
        ItemTossEvent forgeEvent = new ItemTossEvent(item, (EntityPlayer)((EntityPlayerMP)entity));
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        if (forgeEvent.isCanceled()) {
            if (item.field_70128_L) {
                return spongeEvent;
            }
            spongeEvent.setCancelled(true);
        } else {
            SpongeForgeEventFactory.callEntityJoinWorldEvent(spongeEvent);
        }
        return spongeEvent;
    }

    public static SpawnEntityEvent callEntityJoinWorldEvent(Event event) {
        SpawnEntityEvent spongeEvent = (SpawnEntityEvent)event;
        ListIterator<Entity> iterator = spongeEvent.getEntities().listIterator();
        if (spongeEvent.getEntities().size() == 0) {
            return spongeEvent;
        }
        boolean canCancelEvent = true;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            EntityJoinWorldEvent forgeEvent = new EntityJoinWorldEvent((net.minecraft.entity.Entity)entity, (net.minecraft.world.World)entity.getLocation().getExtent());
            boolean prev = StaticMixinForgeHelper.preventInternalForgeEntityListener;
            StaticMixinForgeHelper.preventInternalForgeEntityListener = true;
            ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
            StaticMixinForgeHelper.preventInternalForgeEntityListener = prev;
            net.minecraft.entity.Entity mcEntity = (net.minecraft.entity.Entity)entity;
            if (mcEntity.field_70128_L) {
                canCancelEvent = false;
            }
            if (!forgeEvent.isCanceled()) continue;
            iterator.remove();
        }
        if (spongeEvent.getEntities().size() == 0 && canCancelEvent) {
            spongeEvent.setCancelled(true);
        }
        return spongeEvent;
    }

    public static void handlePrefireLogic(Event event) {
        if (event instanceof SpawnEntityEvent) {
            SpongeForgeEventFactory.handleCustomStack((SpawnEntityEvent)event);
        }
    }

    private static void handleCustomStack(SpawnEntityEvent event) {
        ListIterator<Entity> it = event.getEntities().listIterator();
        while (it.hasNext()) {
            net.minecraft.entity.Entity newEntity;
            ItemStack stack;
            net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)it.next();
            if (!entity.getClass().equals(EntityItem.class) || (stack = ((EntityItem)entity).func_92059_d()).func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item == null) {
                FMLLog.warning((String)"Attempted to add a EntityItem to the world with a invalid item at (%2.2f,  %2.2f, %2.2f), this is most likely a config issue between you and the server. Please double check your configs", (Object[])new Object[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v});
                entity.func_70106_y();
                event.setCancelled(true);
                continue;
            }
            if (!item.hasCustomEntity(stack) || (newEntity = item.createEntity(entity.func_130014_f_(), entity, stack)) == null) continue;
            entity.func_70106_y();
            EntityJoinWorldEvent cancelledEvent = new EntityJoinWorldEvent(entity, entity.func_130014_f_());
            cancelledEvent.setCanceled(true);
            ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)cancelledEvent, true);
            if (!cancelledEvent.isCanceled()) {
                SpongeImpl.getLogger().error("A mod has un-cancelled the EntityJoinWorld event for the original EntityItem (from before Item#createEntity is called). This is almost certainly a terrible idea!");
            }
            it.set((Entity)newEntity);
        }
    }

    public static NotifyNeighborBlockEvent callNeighborNotifyEvent(Event event) {
        NotifyNeighborBlockEvent spongeEvent = (NotifyNeighborBlockEvent)event;
        LocatableBlock locatableBlock = spongeEvent.getCause().first(LocatableBlock.class).orElse(null);
        TileEntity tileEntitySource = spongeEvent.getCause().first(TileEntity.class).orElse(null);
        Location<World> sourceLocation = null;
        IBlockState state = null;
        if (locatableBlock != null) {
            Location<World> location;
            sourceLocation = location = locatableBlock.getLocation();
            state = (IBlockState)locatableBlock.getBlockState();
        } else if (tileEntitySource != null) {
            sourceLocation = tileEntitySource.getLocation();
            state = (IBlockState)sourceLocation.getBlock();
        } else {
            return spongeEvent;
        }
        EnumSet<EnumFacing> facings = EnumSet.noneOf(EnumFacing.class);
        for (Map.Entry<Direction, BlockState> mapEntry : spongeEvent.getNeighbors().entrySet()) {
            if (mapEntry.getKey() == Direction.NONE) continue;
            facings.add(DirectionFacingProvider.getInstance().get(mapEntry.getKey()).get());
        }
        if (facings.isEmpty()) {
            return spongeEvent;
        }
        BlockPos pos = ((IMixinLocation)((Object)sourceLocation)).getBlockPos();
        net.minecraft.world.World world = (net.minecraft.world.World)sourceLocation.getExtent();
        BlockEvent.NeighborNotifyEvent forgeEvent = new BlockEvent.NeighborNotifyEvent(world, pos, state, facings, false);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        if (forgeEvent.isCanceled()) {
            spongeEvent.setCancelled(true);
        }
        return spongeEvent;
    }

    public static ChangeBlockEvent.Place callBlockPlaceEvent(Event event) {
        ChangeBlockEvent.Place spongeEvent = (ChangeBlockEvent.Place)event;
        if (spongeEvent.getCause().root() instanceof Player) {
            EntityPlayer player = (EntityPlayer)spongeEvent.getCause().first(Player.class).get();
            net.minecraft.world.World world = player.field_70170_p;
            CauseTracker causeTracker = CauseTracker.getInstance();
            PhaseContext context = causeTracker.getCurrentContext();
            Packet contextPacket = context.getExtra("Packet", Packet.class);
            if (contextPacket == null) {
                return spongeEvent;
            }
            if (spongeEvent.getTransactions().size() == 1) {
                BlockPos pos = VecHelper.toBlockPos(spongeEvent.getTransactions().get(0).getOriginal().getPosition());
                IBlockState state = (IBlockState)spongeEvent.getTransactions().get(0).getOriginal().getState();
                BlockSnapshot blockSnapshot = new BlockSnapshot(world, pos, state);
                IBlockState placedAgainst = Blocks.field_150350_a.func_176223_P();
                EnumHand hand = EnumHand.MAIN_HAND;
                if (contextPacket instanceof CPacketPlayerTryUseItemOnBlock) {
                    CPacketPlayerTryUseItemOnBlock packet = (CPacketPlayerTryUseItemOnBlock)contextPacket;
                    EnumFacing facing = packet.func_187024_b();
                    placedAgainst = blockSnapshot.getWorld().func_180495_p(blockSnapshot.getPos().func_177972_a(facing.func_176734_d()));
                    hand = packet.func_187022_c();
                }
                BlockEvent.PlaceEvent forgeEvent = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player, hand);
                ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
                if (forgeEvent.isCanceled()) {
                    spongeEvent.setCancelled(true);
                }
            } else {
                Iterator<Transaction<org.spongepowered.api.block.BlockSnapshot>> iterator = spongeEvent.getTransactions().iterator();
                ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>();
                while (iterator.hasNext()) {
                    Transaction<org.spongepowered.api.block.BlockSnapshot> transaction = iterator.next();
                    Location<World> location = transaction.getOriginal().getLocation().get();
                    IBlockState state = (IBlockState)transaction.getOriginal().getState();
                    BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                    BlockSnapshot blockSnapshot = new BlockSnapshot(world, pos, state);
                    blockSnapshots.add(blockSnapshot);
                }
                IBlockState placedAgainst = Blocks.field_150350_a.func_176223_P();
                EnumHand hand = EnumHand.MAIN_HAND;
                if (contextPacket instanceof CPacketPlayerTryUseItemOnBlock) {
                    CPacketPlayerTryUseItemOnBlock packet = (CPacketPlayerTryUseItemOnBlock)contextPacket;
                    EnumFacing facing = packet.func_187024_b();
                    placedAgainst = ((BlockSnapshot)blockSnapshots.get(0)).getWorld().func_180495_p(((BlockSnapshot)blockSnapshots.get(0)).getPos().func_177972_a(facing.func_176734_d()));
                    hand = packet.func_187022_c();
                }
                BlockEvent.MultiPlaceEvent forgeEvent = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player, hand);
                ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
                if (forgeEvent.isCanceled()) {
                    spongeEvent.setCancelled(true);
                }
            }
        }
        return spongeEvent;
    }

    private static InteractEntityEvent.Secondary callEntityInteractEvent(Event event) {
        InteractEntityEvent.Secondary spongeEvent = (InteractEntityEvent.Secondary)event;
        Optional<Player> player = spongeEvent.getCause().first(Player.class);
        if (!player.isPresent()) {
            return null;
        }
        EntityPlayerMP entityPlayerMP = EntityUtil.toNative(player.get());
        EnumHand hand = entityPlayerMP.func_184600_cs();
        EntityPlayer entityPlayer = (EntityPlayer)player.get();
        net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)spongeEvent.getTargetEntity();
        Vector3d hitVec = spongeEvent.getInteractionPoint().orElse(null);
        Object forgeEvent = null;
        forgeEvent = hitVec != null ? new PlayerInteractEvent.EntityInteractSpecific(entityPlayer, hand, entity, VecHelper.toVec3d(hitVec)) : new PlayerInteractEvent.EntityInteract(entityPlayer, hand, entity);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        if (forgeEvent.isCanceled()) {
            spongeEvent.setCancelled(true);
        }
        return spongeEvent;
    }

    private static ClientConnectionEvent.Join callPlayerLoggedInEvent(Event event) {
        ClientConnectionEvent.Join spongeEvent = (ClientConnectionEvent.Join)event;
        PlayerEvent.PlayerLoggedInEvent fmlEvent = new PlayerEvent.PlayerLoggedInEvent((EntityPlayer)spongeEvent.getTargetEntity());
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)fmlEvent, true);
        return spongeEvent;
    }

    private static ClientConnectionEvent.Disconnect callPlayerLoggedOutEvent(Event event) {
        ClientConnectionEvent.Disconnect spongeEvent = (ClientConnectionEvent.Disconnect)event;
        PlayerEvent.PlayerLoggedOutEvent fmlEvent = new PlayerEvent.PlayerLoggedOutEvent((EntityPlayer)spongeEvent.getTargetEntity());
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)fmlEvent, true);
        return spongeEvent;
    }

    private static RespawnPlayerEvent callPlayerRespawnEvent(Event event) {
        RespawnPlayerEvent spongeEvent = (RespawnPlayerEvent)event;
        PlayerEvent.PlayerRespawnEvent fmlEvent = new PlayerEvent.PlayerRespawnEvent((EntityPlayer)spongeEvent.getTargetEntity(), !spongeEvent.isDeath());
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)fmlEvent, true);
        return spongeEvent;
    }

    private static MoveEntityEvent.Teleport callEntityTravelToDimensionEvent(Event event) {
        int toDimensionId;
        MoveEntityEvent.Teleport spongeEvent = (MoveEntityEvent.Teleport)event;
        Entity entity = spongeEvent.getTargetEntity();
        if (!(entity instanceof EntityPlayerMP)) {
            return spongeEvent;
        }
        int fromDimensionId = ((net.minecraft.world.World)spongeEvent.getFromTransform().getExtent()).field_73011_w.getDimension();
        if (fromDimensionId != (toDimensionId = ((net.minecraft.world.World)spongeEvent.getToTransform().getExtent()).field_73011_w.getDimension()) && !ForgeHooks.onTravelToDimension((net.minecraft.entity.Entity)((EntityPlayerMP)entity), (int)toDimensionId)) {
            spongeEvent.setCancelled(true);
        }
        return spongeEvent;
    }

    private static SaveWorldEvent callWorldSaveEvent(Event event) {
        SaveWorldEvent spongeEvent = (SaveWorldEvent)event;
        ((IMixinWorld)((Object)spongeEvent.getTargetWorld())).setCallingWorldEvent(true);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)new WorldEvent.Save((net.minecraft.world.World)spongeEvent.getTargetWorld()), true);
        ((IMixinWorld)((Object)spongeEvent.getTargetWorld())).setCallingWorldEvent(false);
        return spongeEvent;
    }

    private static LoadWorldEvent callWorldLoadEvent(Event event) {
        LoadWorldEvent spongeEvent = (LoadWorldEvent)event;
        net.minecraft.world.World minecraftWorld = (net.minecraft.world.World)spongeEvent.getTargetWorld();
        ((IMixinWorld)((Object)spongeEvent.getTargetWorld())).setCallingWorldEvent(true);
        ((IMixinChunkProviderServer)minecraftWorld.func_72863_F()).setForceChunkRequests(true);
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)new WorldEvent.Load(minecraftWorld), true);
        ((IMixinChunkProviderServer)minecraftWorld.func_72863_F()).setForceChunkRequests(false);
        ((IMixinWorld)minecraftWorld).setCallingWorldEvent(false);
        return spongeEvent;
    }

    private static UnloadWorldEvent callWorldUnloadEvent(Event event) {
        UnloadWorldEvent spongeEvent = (UnloadWorldEvent)event;
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)new WorldEvent.Unload((net.minecraft.world.World)spongeEvent.getTargetWorld()), true);
        return spongeEvent;
    }

    private static LoadChunkEvent callChunkLoadEvent(Event event) {
        LoadChunkEvent spongeEvent = (LoadChunkEvent)event;
        net.minecraft.world.chunk.Chunk chunk = (net.minecraft.world.chunk.Chunk)spongeEvent.getTargetChunk();
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)new ChunkEvent.Load(chunk), true);
        return spongeEvent;
    }

    private static UnloadChunkEvent callChunkUnloadEvent(Event event) {
        UnloadChunkEvent spongeEvent = (UnloadChunkEvent)event;
        net.minecraft.world.chunk.Chunk chunk = (net.minecraft.world.chunk.Chunk)spongeEvent.getTargetChunk();
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((net.minecraftforge.fml.common.eventhandler.Event)new ChunkEvent.Unload(chunk), true);
        return spongeEvent;
    }
}

