/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class SpongeForgeEventHooks {
    public static void preEventPhaseCheck(IEventListener listener, Event event) {
        if (!CauseTracker.ENABLED) {
            return;
        }
        if (event instanceof TickEvent.WorldTickEvent) {
            TickEvent.WorldTickEvent worldTickEvent = (TickEvent.WorldTickEvent)event;
            if (!(worldTickEvent.world instanceof IMixinWorldServer)) {
                return;
            }
            if (worldTickEvent.phase == TickEvent.Phase.START) {
                CauseTracker.getInstance().switchToPhase(PluginPhase.Listener.PRE_WORLD_TICK_LISTENER, PhaseContext.start().source(listener).addExtra("CapturedWorldTickEvent", event).addCaptures().player().complete());
            } else if (worldTickEvent.phase == TickEvent.Phase.END) {
                CauseTracker.getInstance().switchToPhase(PluginPhase.Listener.POST_WORLD_TICK_LISTENER, PhaseContext.start().source(listener).addExtra("CapturedWorldTickEvent", event).addCaptures().player().complete());
            }
        }
        if (event instanceof TickEvent.ServerTickEvent) {
            TickEvent.ServerTickEvent serverTickEvent = (TickEvent.ServerTickEvent)event;
            if (serverTickEvent.phase == TickEvent.Phase.START) {
                CauseTracker.getInstance().switchToPhase(PluginPhase.Listener.PRE_SERVER_TICK_LISTENER, PhaseContext.start().source(listener).addExtra("CapturedWorldTickEvent", event).addCaptures().player().complete());
            } else if (serverTickEvent.phase == TickEvent.Phase.END) {
                CauseTracker.getInstance().switchToPhase(PluginPhase.Listener.POST_SERVER_TICK_LISTENER, PhaseContext.start().source(listener).addExtra("CapturedWorldTickEvent", event).addCaptures().player().complete());
            }
        }
    }

    public static void postEventPhaseCheck(IEventListener listener, Event event) {
        if (!CauseTracker.ENABLED) {
            return;
        }
        if (event instanceof TickEvent.WorldTickEvent) {
            TickEvent.WorldTickEvent worldTickEvent = (TickEvent.WorldTickEvent)event;
            if (!(worldTickEvent.world instanceof IMixinWorldServer)) {
                return;
            }
            if (worldTickEvent.phase == TickEvent.Phase.START) {
                CauseTracker.getInstance().completePhase(PluginPhase.Listener.PRE_WORLD_TICK_LISTENER);
            } else if (worldTickEvent.phase == TickEvent.Phase.END) {
                CauseTracker.getInstance().completePhase(PluginPhase.Listener.POST_WORLD_TICK_LISTENER);
            }
        }
        if (event instanceof TickEvent.ServerTickEvent) {
            TickEvent.ServerTickEvent serverTickEvent = (TickEvent.ServerTickEvent)event;
            if (serverTickEvent.phase == TickEvent.Phase.START) {
                CauseTracker.getInstance().completePhase(PluginPhase.Listener.PRE_SERVER_TICK_LISTENER);
            } else if (serverTickEvent.phase == TickEvent.Phase.END) {
                CauseTracker.getInstance().completePhase(PluginPhase.Listener.POST_SERVER_TICK_LISTENER);
            }
        }
    }
}

