/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.command.SpongeCommands;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.mod.command.SpongeForgeCommand;
import org.spongepowered.mod.interfaces.IMixinBlock;
import org.spongepowered.mod.interfaces.IMixinEventBus;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;
import org.spongepowered.mod.util.StaticMixinForgeHelper;

@Mixin(value={SpongeImplHooks.class}, remap=false)
public abstract class MixinSpongeImplHooks {
    private static Boolean deobfuscatedEnvironment;

    @Overwrite
    public static boolean isVanilla() {
        return false;
    }

    @Overwrite
    public static boolean isDeobfuscatedEnvironment() {
        if (deobfuscatedEnvironment != null) {
            return deobfuscatedEnvironment;
        }
        deobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return deobfuscatedEnvironment;
    }

    @Overwrite
    public static String getModIdFromClass(Class<?> clazz) {
        return StaticMixinForgeHelper.getModIdFromClass(clazz);
    }

    @Overwrite
    public static boolean isCreatureOfType(Entity entity, EnumCreatureType type) {
        return entity.isCreatureType(type, false);
    }

    @Overwrite
    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    @Overwrite
    public static void firePlayerJoinSpawnEvent(EntityPlayerMP playerMP) {
        ((IMixinEventBus)MinecraftForge.EVENT_BUS).post((Event)new EntityJoinWorldEvent((Entity)playerMP, playerMP.func_130014_f_()), true);
    }

    @Overwrite
    public static void handlePostChangeDimensionEvent(EntityPlayerMP playerIn, WorldServer fromWorld, WorldServer toWorld) {
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)playerIn, fromWorld.field_73011_w.getDimension(), toWorld.field_73011_w.getDimension());
    }

    @Overwrite
    public static boolean checkAttackEntity(EntityPlayer entityPlayer, Entity targetEntity) {
        return ForgeHooks.onPlayerAttackTarget((EntityPlayer)entityPlayer, (Entity)targetEntity);
    }

    @Overwrite
    public static double getBlockReachDistance(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @Nullable
    @Overwrite
    public static Class<? extends Entity> getEntityClass(ResourceLocation name) {
        return EntityList.getClass((ResourceLocation)name);
    }

    @Overwrite
    public static int getEntityId(Class<? extends Entity> entityClass) {
        return EntityList.getID(entityClass);
    }

    @Overwrite
    public static boolean isBlockFlammable(Block block, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return block.isFlammable(world, pos, face);
    }

    @Overwrite
    public static int getBlockLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getLightOpacity(world, pos);
    }

    @Overwrite
    public static int getChunkPosLight(IBlockState blockState, net.minecraft.world.World worldObj, BlockPos pos) {
        if (((IMixinBlock)blockState.func_177230_c()).requiresLocationCheckForLightValue()) {
            return blockState.getLightValue((IBlockAccess)worldObj, pos);
        }
        return blockState.func_185906_d();
    }

    @Nullable
    @Overwrite
    public static TileEntity createTileEntity(Block block, net.minecraft.world.World world, IBlockState state) {
        return block.createTileEntity(world, state);
    }

    @Overwrite
    public static boolean hasBlockTileEntity(Block block, IBlockState state) {
        return block.hasTileEntity(state);
    }

    @Overwrite
    public static boolean shouldRefresh(TileEntity tile, net.minecraft.world.World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return tile.shouldRefresh(world, pos, oldState, newState);
    }

    @Overwrite
    public static void onTileChunkUnload(TileEntity te) {
        te.onChunkUnload();
    }

    @Overwrite
    public static Iterator<Chunk> getChunkIterator(WorldServer world) {
        return world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
    }

    @Overwrite
    public static void registerPortalAgentType(@Nullable Teleporter teleporter) {
        if (teleporter == null) {
            return;
        }
        if (PortalAgentTypes.DEFAULT.equals(((PortalAgent)teleporter).getType())) {
            return;
        }
        PortalAgentRegistryModule.getInstance().validatePortalAgent(teleporter);
    }

    @Overwrite
    public static boolean canDoLightning(WorldProvider provider, Chunk chunk) {
        return provider.canDoLightning(chunk);
    }

    @Overwrite
    public static boolean canDoRainSnowIce(WorldProvider provider, Chunk chunk) {
        return provider.canDoRainSnowIce(chunk);
    }

    @Overwrite
    public static int getRespawnDimension(WorldProvider targetDimension, EntityPlayerMP player) {
        return targetDimension.getRespawnDimension(player);
    }

    @Overwrite
    public static BlockPos getRandomizedSpawnPoint(WorldServer world) {
        return world.field_73011_w.getRandomizedSpawnPoint();
    }

    @Overwrite
    public static MapStorage getWorldMapStorage(net.minecraft.world.World world) {
        return world.getPerWorldStorage();
    }

    @Overwrite
    public static int countEntities(WorldServer worldServer, EnumCreatureType type, boolean forSpawnCount) {
        return worldServer.countEntities(type, forSpawnCount);
    }

    @Overwrite
    public static int getMaxSpawnPackSize(EntityLiving entityLiving) {
        return ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityLiving);
    }

    @Overwrite
    public static boolean canEntitySpawnHere(EntityLiving entityLiving, IEntityLivingData entityLivingData, boolean entityNotColliding) {
        net.minecraft.world.World world = entityLiving.field_70170_p;
        float x = (float)entityLiving.field_70165_t;
        float y = (float)entityLiving.field_70163_u;
        float z = (float)entityLiving.field_70161_v;
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z);
        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityLiving.func_70601_bi() && entityNotColliding) {
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (net.minecraft.world.World)world, (float)x, (float)y, (float)z)) {
                entityLivingData = entityLiving.func_180482_a(entityLiving.field_70170_p.func_175649_E(new BlockPos((Entity)entityLiving)), entityLivingData);
            }
            return true;
        }
        return false;
    }

    @Overwrite
    public static void onEntityError(Entity entity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        entity.func_130014_f_().func_72900_e(entity);
    }

    @Overwrite
    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        if (!ForgeModContainer.removeErroringTileEntities) {
            throw new ReportedException(crashReport);
        }
        FMLRelaunchLog.log.getLogger().log(Level.ERROR, crashReport.func_71502_e());
        tileEntity.func_145843_s();
        tileEntity.func_145831_w().func_175713_t(tileEntity.func_174877_v());
    }

    @Overwrite
    public static void blockExploded(Block block, net.minecraft.world.World world, BlockPos blockpos, Explosion explosion) {
        block.onBlockExploded(world, blockpos, explosion);
    }

    @Overwrite
    public static boolean isRestoringBlocks(net.minecraft.world.World world) {
        return world.restoringBlockSnapshots || CauseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS;
    }

    @Overwrite
    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
        tileEntity.onChunkUnload();
    }

    @Overwrite
    public static boolean canConnectRedstone(Block block, IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return block.canConnectRedstone(state, world, pos, side);
    }

    @Overwrite
    public static Optional<ItemStack> getContainerItem(ItemStack itemStack) {
        net.minecraft.item.ItemStack nmsStack = ItemStackUtil.toNative(itemStack);
        net.minecraft.item.ItemStack nmsContainerStack = ForgeHooks.getContainerItem((net.minecraft.item.ItemStack)nmsStack);
        if (nmsContainerStack.func_190926_b()) {
            return Optional.empty();
        }
        return Optional.of(ItemStackUtil.fromNative(nmsContainerStack));
    }

    @Overwrite
    public static void onCraftingRecipeRegister(CraftingRecipe recipe) {
    }

    @Overwrite
    public static Optional<CraftingRecipe> findMatchingRecipe(CraftingGridInventory inventory, World world) {
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)InventoryUtil.toNativeInventory(inventory), (net.minecraft.world.World)((net.minecraft.world.World)world));
        return Optional.ofNullable((CraftingRecipe)recipe);
    }

    @Overwrite
    public static Collection<CraftingRecipe> getCraftingRecipes() {
        return (Collection)Streams.stream((Collection)ForgeRegistries.RECIPES.getValues()).map(CraftingRecipe.class::cast).collect(ImmutableList.toImmutableList());
    }

    @Overwrite
    public static Optional<CraftingRecipe> getRecipeById(String id) {
        IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(id));
        if (recipe == null) {
            return Optional.empty();
        }
        return Optional.of((CraftingRecipe)recipe);
    }

    @Overwrite
    public static Text getAdditionalCommandDescriptions() {
        return Text.of("    ", SpongeCommands.title("mods"), "        ", "List currently installed mods");
    }

    @Overwrite
    public static void registerAdditionalCommands(ChildCommandElementExecutor flagChildren, ChildCommandElementExecutor nonFlagChildren) {
        nonFlagChildren.register((CommandCallable)SpongeForgeCommand.createSpongeModsCommand(), "mods");
    }

    @Overwrite
    public static Predicate<PluginContainer> getPluginFilterPredicate() {
        return plugin -> !SpongeCommands.CONTAINER_LIST_STATICS.contains(plugin.getId()) && plugin instanceof SpongeModPluginContainer;
    }
}

