/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.item;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={ItemShears.class}, remap=false)
public abstract class MixinItemShears
extends Item {
    @Overwrite
    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
                CauseTracker causeTracker = CauseTracker.getInstance();
                PhaseData currentData = causeTracker.getCurrentPhaseData();
                IPhaseState currentState = currentData.state;
                PhaseContext phaseContext = currentData.context;
                Random random = EntityUtil.fromNative((Entity)entity).getRandom();
                IMixinEntity mixinEntity = EntityUtil.toMixin((Entity)entity);
                double posX = entity.field_70165_t;
                double posY = entity.field_70163_u + 1.0;
                double posZ = entity.field_70161_v;
                Vector3d position = new Vector3d(posX, posY, posZ);
                for (ItemStack drop : drops) {
                    ItemStack item;
                    if (drop.func_190926_b()) continue;
                    CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                    Throwable throwable = null;
                    try {
                        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(drop);
                        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
                        original.add(snapshot);
                        Sponge.getCauseStackManager().pushCause(entity);
                        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(Sponge.getCauseStackManager().getCurrentCause(), (List)ImmutableList.of((Object)snapshot), original);
                        if (dropEvent.isCancelled()) continue;
                        Transform<World> suggested = new Transform<World>(mixinEntity.getWorld(), position);
                        Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), EntityTypes.ITEM, suggested);
                        SpongeImpl.postEvent(event);
                        item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (frame == null) continue;
                        if (throwable != null) {
                            try {
                                frame.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        frame.close();
                        continue;
                    }
                    if (item == null || item.func_190926_b()) continue;
                    if (!currentState.getPhase().ignoresItemPreMerging(currentState) && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().doDropsPreMergeItemDrops()) {
                        if (currentState.tracksEntitySpecificDrops()) {
                            ListMultimap<UUID, ItemDropData> multimap = phaseContext.getCapturedEntityDropSupplier().get();
                            Collection itemStacks = multimap.get((Object)entity.func_110124_au());
                            SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.item(item).motion(new Vector3d((random.nextFloat() - random.nextFloat()) * 0.1f, random.nextFloat() * 0.05f, (random.nextFloat() - random.nextFloat()) * 0.1f)).position(new Vector3d(posX, posY, posZ)).build());
                            continue;
                        }
                        Object itemStacks = phaseContext.getCapturedItemStackSupplier().get();
                        SpongeImplHooks.addItemStackToListForSpawning((Collection<ItemDropData>)itemStacks, ItemDropData.item(item).position(new Vector3d(posX, posY, posZ)).motion(new Vector3d((random.nextFloat() - random.nextFloat()) * 0.1f, random.nextFloat() * 0.05f, (random.nextFloat() - random.nextFloat()) * 0.1f)).build());
                        continue;
                    }
                    EntityItem entityitem = new EntityItem(entity.field_70170_p, posX, posY, posZ, item);
                    entityitem.func_174869_p();
                    entityitem.field_70181_x += (double)(random.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
                    if (currentState.getPhase().doesCaptureEntityDrops(currentState)) {
                        if (currentState.tracksEntitySpecificDrops()) {
                            phaseContext.getCapturedEntityItemDropSupplier().get().put((Object)entity.func_110124_au(), (Object)entityitem);
                            continue;
                        }
                        phaseContext.getCapturedItemsSupplier().get().add(entityitem);
                        continue;
                    }
                    entity.field_70170_p.func_72838_d((Entity)entityitem);
                }
                itemstack.func_77972_a(1, entity);
            }
            return true;
        }
        return false;
    }
}

