/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.network;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelRegistrationException;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.network.SpongeNetworkManager;
import org.spongepowered.mod.interfaces.IMixinNetPlayHandler;
import org.spongepowered.mod.network.SpongeIndexedMessageChannel;
import org.spongepowered.mod.network.SpongeModChannelBinding;
import org.spongepowered.mod.network.SpongeRawChannel;

@Singleton
public class SpongeModNetworkManager
extends SpongeNetworkManager {
    public static final EventContextKey<INetHandler> NET_HANDLER = new EventContextKey<INetHandler>(){

        @Override
        public Class<INetHandler> getAllowedType() {
            return INetHandler.class;
        }

        @Override
        public String getId() {
            return "sponge:nethandler";
        }

        @Override
        public String getName() {
            return "NetHandler";
        }
    };
    private final Map<String, SpongeModChannelBinding> channelMap = Maps.newHashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCustomPacketRegistration(FMLNetworkEvent.CustomPacketRegistrationEvent<?> event) {
        Set<String> channels = ((IMixinNetPlayHandler)event.getHandler()).getRegisteredChannels();
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        try (CauseStackManager.StackFrame frame = isMainThread ? Sponge.getCauseStackManager().pushCauseFrame() : null;){
            if (isMainThread) {
                if (event.getHandler() instanceof NetHandlerPlayServer) {
                    Sponge.getCauseStackManager().pushCause(((NetHandlerPlayServer)event.getHandler()).field_147369_b);
                }
                Sponge.getCauseStackManager().addContext(NET_HANDLER, event.getHandler());
            }
            if (event.getOperation().equals("REGISTER")) {
                channels.addAll((Collection<String>)event.getRegistrations());
                for (String channel : event.getRegistrations()) {
                    Cause currentCause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), Sponge.getGame());
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventRegister(currentCause, channel));
                }
            } else if (event.getOperation().equals("UNREGISTER")) {
                channels.removeAll((Collection<?>)event.getRegistrations());
                for (String channel : event.getRegistrations()) {
                    Cause currentCause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), Sponge.getGame());
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventUnregister(currentCause, channel));
                }
            }
        }
    }

    protected static CPacketCustomPayload getRegPacketClient(String channelName) {
        return new CPacketCustomPayload("REGISTER", new PacketBuffer(Unpooled.wrappedBuffer((byte[])channelName.getBytes(Charsets.UTF_8))));
    }

    protected static CPacketCustomPayload getUnregPacketClient(String channelName) {
        return new CPacketCustomPayload("UNREGISTER", new PacketBuffer(Unpooled.wrappedBuffer((byte[])channelName.getBytes(Charsets.UTF_8))));
    }

    private <T extends SpongeModChannelBinding> T registerChannel(T channel) {
        EntityPlayerSP clientPlayer;
        PlayerList playerList;
        this.channelMap.put(channel.getName(), channel);
        if (SpongeImpl.getGame().isServerAvailable() && (playerList = SpongeImpl.getServer().func_184103_al()) != null) {
            playerList.func_148540_a((Packet)SpongeModNetworkManager.getRegPacket(channel.getName()));
        }
        if (SpongeImpl.getGame().getPlatform().getExecutionType().isClient() && (clientPlayer = Minecraft.func_71410_x().field_71439_g) != null) {
            clientPlayer.field_71174_a.func_147297_a((Packet)SpongeModNetworkManager.getRegPacketClient(channel.getName()));
        }
        return channel;
    }

    @Override
    public ChannelBinding.IndexedMessageChannel createChannel(Object plugin, String channelName) throws ChannelRegistrationException {
        SpongeIndexedMessageChannel channel;
        PluginContainer pluginContainer = this.checkCreateChannelArgs(plugin, channelName);
        try {
            channel = new SpongeIndexedMessageChannel(this, channelName, pluginContainer);
        }
        catch (Exception e) {
            throw new ChannelRegistrationException("Error registering channel \"" + channelName + "\" to " + pluginContainer, e);
        }
        return this.registerChannel(channel);
    }

    @Override
    public ChannelBinding.RawDataChannel createRawChannel(Object plugin, String channelName) throws ChannelRegistrationException {
        SpongeRawChannel channel;
        PluginContainer pluginContainer = this.checkCreateChannelArgs(plugin, channelName);
        try {
            channel = new SpongeRawChannel(this, channelName, pluginContainer);
        }
        catch (Exception e) {
            throw new ChannelRegistrationException("Error registering channel \"" + channelName + "\" to " + pluginContainer, e);
        }
        return this.registerChannel(channel);
    }

    @Override
    public Optional<ChannelBinding> getChannel(String channel) {
        return Optional.ofNullable(this.channelMap.get(channel));
    }

    @Override
    public void unbindChannel(ChannelBinding channel) {
        EntityPlayerSP clientPlayer;
        PlayerList playerList;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)channel, (Object)"channel") instanceof SpongeModChannelBinding), (Object)"Custom channel implementation not supported");
        SpongeModChannelBinding boundChannel = this.channelMap.remove(channel.getName());
        Preconditions.checkState((boundChannel != null ? 1 : 0) != 0, (Object)"Channel is already unbound");
        boundChannel.invalidate();
        if (SpongeImpl.getGame().isServerAvailable() && (playerList = SpongeImpl.getServer().func_184103_al()) != null) {
            playerList.func_148540_a((Packet)SpongeModNetworkManager.getUnregPacket(channel.getName()));
        }
        if (SpongeImpl.getGame().getPlatform().getExecutionType().isClient() && (clientPlayer = Minecraft.func_71410_x().field_71439_g) != null) {
            clientPlayer.field_71174_a.func_147297_a((Packet)SpongeModNetworkManager.getUnregPacketClient(channel.getName()));
        }
    }

    @Override
    public Set<String> getRegisteredChannels(Platform.Type side) {
        Preconditions.checkArgument((boolean)((Platform.Type)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side"))).isKnown(), (Object)"Invalid side given");
        if (side == Platform.Type.SERVER) {
            return ImmutableSet.copyOf((Collection)NetworkRegistry.INSTANCE.channelNamesFor(Side.SERVER));
        }
        return ImmutableSet.copyOf((Collection)NetworkRegistry.INSTANCE.channelNamesFor(Side.CLIENT));
    }

    @Override
    public boolean isChannelAvailable(String channelName) {
        Preconditions.checkNotNull((Object)channelName, (Object)"channelName");
        if (channelName.startsWith("MC|") || channelName.startsWith("\u0001") || channelName.startsWith("FML")) {
            return false;
        }
        return !NetworkRegistry.INSTANCE.channelNamesFor(Side.SERVER).contains(channelName) && !NetworkRegistry.INSTANCE.channelNamesFor(Side.CLIENT).contains(channelName);
    }
}

