/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.mod.SpongeMod;
import org.spongepowered.mod.util.DamageEventObject;

public final class StaticMixinForgeHelper {
    static final Map<String, EventContextKey<ItemStackSnapshot>> ARMOR_KEYS = new ConcurrentHashMap<String, EventContextKey<ItemStackSnapshot>>();
    public static final EventContextKey<ISpecialArmor.ArmorProperties> ARMOR_PROPERTY = new EventContextKey<ISpecialArmor.ArmorProperties>(){

        @Override
        public Class<ISpecialArmor.ArmorProperties> getAllowedType() {
            return ISpecialArmor.ArmorProperties.class;
        }

        @Override
        public String getId() {
            return "forge:ArmorProperty";
        }

        @Override
        public String getName() {
            return "ArmorProperty";
        }
    };
    private static final EventContextKey<DamageEventObject> DAMAGE_MODIFIER_OBJECT = new EventContextKey<DamageEventObject>(){

        @Override
        public Class<DamageEventObject> getAllowedType() {
            return DamageEventObject.class;
        }

        @Override
        public String getId() {
            return "sponge:damage_event_object";
        }

        @Override
        public String getName() {
            return "0xDEADBEEF";
        }
    };
    @Nullable
    public static IBlockState breakEventExtendedState = null;
    public static boolean preventInternalForgeEntityListener = false;
    private static double damageToHandle;

    public static DamageSource exchangeDamageSource(DamageSource damageSource) {
        return damageSource;
    }

    public static Optional<List<DamageFunction>> createArmorModifiers(EntityLivingBase entityLivingBase, DamageSource damageSource, double damage) {
        Iterable inventory = entityLivingBase.func_184193_aE();
        ArrayList itemStacks = Lists.newArrayList((Iterable)inventory);
        damage *= 25.0;
        ArrayList<ISpecialArmor.ArmorProperties> dmgVals = new ArrayList<ISpecialArmor.ArmorProperties>();
        for (int x = 0; x < itemStacks.size(); ++x) {
            ISpecialArmor.ArmorProperties properties = StaticMixinForgeHelper.getProperties(entityLivingBase, (ItemStack)itemStacks.get(x), damageSource, damage, x);
            if (properties == null) continue;
            dmgVals.add(properties);
        }
        return StaticMixinForgeHelper.createArmorModifiers(dmgVals, itemStacks, damage);
    }

    public static void acceptArmorModifier(EntityLivingBase entity, DamageSource damageSource, DamageModifier modifier, double damage) {
        NonNullList inventory;
        Optional<ISpecialArmor.ArmorProperties> property = modifier.getCause().first(ISpecialArmor.ArmorProperties.class);
        NonNullList nonNullList = inventory = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.field_70460_b : entity.field_184631_bt;
        if (property.isPresent()) {
            ItemStack stack = (ItemStack)inventory.get(property.get().Slot);
            int itemDamage = (int)((damage = Math.abs(damage) * 25.0) / 25.0 < 1.0 ? 1.0 : damage / 25.0);
            if (stack.func_77973_b() instanceof ISpecialArmor) {
                ((ISpecialArmor)stack.func_77973_b()).damageArmor(entity, stack, damageSource, itemDamage, property.get().Slot);
            } else {
                stack.func_77972_a(itemDamage, entity);
            }
            if (stack.func_190926_b()) {
                inventory.set(property.get().Slot, (Object)ItemStack.field_190927_a);
            }
        }
    }

    private static Optional<List<DamageFunction>> createArmorModifiers(List<ISpecialArmor.ArmorProperties> dmgVals, List<ItemStack> inventory, double damage) {
        if (dmgVals.size() > 0) {
            ArrayList<DamageFunction> list = new ArrayList<DamageFunction>();
            ISpecialArmor.ArmorProperties[] props = dmgVals.toArray(new ISpecialArmor.ArmorProperties[dmgVals.size()]);
            StaticMixinForgeHelper.sortProperties(props, damage);
            boolean first = true;
            int level = props[0].Priority;
            double ratio = 0.0;
            for (ISpecialArmor.ArmorProperties prop : props) {
                final EquipmentType type = DamageEventHandler.resolveEquipment(prop.Slot);
                DamageEventObject object = new DamageEventObject();
                object.previousLevel = prop.Priority;
                object.previousRatio = ratio;
                if (first) {
                    object.previousDamage = damage;
                    object.augment = true;
                }
                DoubleUnaryOperator function = incomingDamage -> {
                    double functionDamage;
                    incomingDamage *= 25.0;
                    if (object.augment) {
                        damageToHandle = incomingDamage;
                    }
                    object.previousDamage = functionDamage = damageToHandle;
                    object.level = prop.Priority;
                    object.ratio = prop.AbsorbRatio;
                    if (object.previousLevel != prop.Priority) {
                        functionDamage -= functionDamage * object.previousRatio;
                        damageToHandle = functionDamage;
                        object.ratio = 0.0;
                        object.level = prop.Priority;
                    }
                    object.ratio += prop.AbsorbRatio;
                    return -(functionDamage * prop.AbsorbRatio / 25.0);
                };
                if (level != prop.Priority) {
                    damage -= damage * ratio;
                    ratio = 0.0;
                    level = prop.Priority;
                }
                ratio += prop.AbsorbRatio;
                EventContextKey<ItemStackSnapshot> contextKey = ARMOR_KEYS.get("armor:" + type.getId());
                if (contextKey == null) {
                    contextKey = new EventContextKey<ItemStackSnapshot>(){

                        @Override
                        public Class<ItemStackSnapshot> getAllowedType() {
                            return ItemStackSnapshot.class;
                        }

                        @Override
                        public String getId() {
                            return "armor:" + type.getId();
                        }

                        @Override
                        public String getName() {
                            return type.getName();
                        }
                    };
                    ARMOR_KEYS.put("armor: " + type.getId(), contextKey);
                }
                ItemStack itemStack = inventory.get(prop.Slot);
                DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.builder().add(contextKey, ItemStackUtil.snapshotOf(itemStack)).add(ARMOR_PROPERTY, prop).add(DAMAGE_MODIFIER_OBJECT, object).build(), itemStack)).type(DamageModifierTypes.ARMOR).build();
                list.add(DamageFunction.of(modifier, function));
                first = false;
            }
            return Optional.of(list);
        }
        return Optional.empty();
    }

    private static ISpecialArmor.ArmorProperties getProperties(EntityLivingBase base, ItemStack armorStack, DamageSource damageSource, double damage, int index) {
        if (armorStack.func_190926_b()) {
            return null;
        }
        ISpecialArmor.ArmorProperties prop = null;
        if (armorStack.func_77973_b() instanceof ISpecialArmor) {
            ISpecialArmor armor = (ISpecialArmor)armorStack.func_77973_b();
            prop = armor.getProperties(base, armorStack, damageSource, damage / 25.0, index).copy();
        } else if (armorStack.func_77973_b() instanceof ItemArmor && !damageSource.func_76363_c()) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            prop = new ISpecialArmor.ArmorProperties(0, (double)armor.field_77879_b / 25.0, Integer.MAX_VALUE);
        }
        if (prop != null) {
            prop.Slot = index;
            return prop;
        }
        return null;
    }

    private static void sortProperties(ISpecialArmor.ArmorProperties[] armor, double damage) {
        Arrays.sort(armor);
        int start = 0;
        double total = 0.0;
        int priority = armor[0].Priority;
        int pStart = 0;
        boolean pChange = false;
        boolean pFinished = false;
        for (int x = 0; x < armor.length; ++x) {
            int y;
            total += armor[x].AbsorbRatio;
            if (x != armor.length - 1 && armor[x].Priority == priority) continue;
            if (armor[x].Priority != priority) {
                total -= armor[x].AbsorbRatio;
                --x;
                pChange = true;
            }
            if (total > 1.0) {
                for (y = start; y <= x; ++y) {
                    double newRatio = armor[y].AbsorbRatio / total;
                    if (newRatio * damage > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                        total = 0.0;
                        for (int z = pStart; z <= y; ++z) {
                            total += armor[z].AbsorbRatio;
                        }
                        start = y + 1;
                        x = y;
                        break;
                    }
                    armor[y].AbsorbRatio = newRatio;
                    pFinished = true;
                }
                if (!pChange || !pFinished) continue;
                damage -= damage * total;
                total = 0.0;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                pFinished = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            } else {
                for (y = start; y <= x; ++y) {
                    total -= armor[y].AbsorbRatio;
                    if (damage * armor[y].AbsorbRatio > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                    }
                    total += armor[y].AbsorbRatio;
                }
                damage -= damage * total;
                total = 0.0;
                if (x == armor.length - 1) continue;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            }
            break;
        }
    }

    public static String getModIdFromClass(Class clazz) {
        String className = clazz.getName();
        String modId = className.contains("net.minecraft.") ? "minecraft" : (className.contains("org.spongepowered.") ? "sponge" : "unknown");
        String modPackage = className.replace("." + clazz.getSimpleName(), "");
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            if (!mc.getOwnedPackages().contains(modPackage)) continue;
            modId = mc.getModId();
            break;
        }
        return modId;
    }

    @Nullable
    public static ModContainer getModContainerFromClass(Class clazz) {
        String className = clazz.getName();
        String modPackage = className.replace("." + clazz.getSimpleName(), "");
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            if (!mc.getOwnedPackages().contains(modPackage)) continue;
            return mc;
        }
        return null;
    }

    public static void registerCustomEntity(EntityEntry entityEntry) {
        if (EntityTypeRegistryModule.getInstance().entityClassToTypeMappings.get(entityEntry.getEntityClass()) != null) {
            return;
        }
        ModContainer modContainer = StaticMixinForgeHelper.getModContainerFromClass(entityEntry.getEntityClass());
        if (modContainer == null) {
            return;
        }
        StaticMixinForgeHelper.registerCustomEntity(entityEntry.getEntityClass(), entityEntry.getName(), EntityList.getID((Class)entityEntry.getEntityClass()), modContainer);
    }

    public static void registerCustomEntity(Class<? extends Entity> entityClass, String entityName, int id, ModContainer modContainer) {
        if (entityName.contains(".") && entityName.indexOf(".") + 1 < entityName.length()) {
            entityName = entityName.substring(entityName.indexOf(".") + 1, entityName.length());
        }
        if ((entityName = entityName.replace("entity", "")).startsWith("ent")) {
            entityName = entityName.replace("ent", "");
        }
        entityName = entityName.replaceAll("[^A-Za-z0-9]", "");
        String modId = "unknown";
        if (modContainer != null) {
            modId = modContainer.getModId();
        }
        if (!modContainer.equals((Object)SpongeMod.instance)) {
            SpongeEntityType entityType = new SpongeEntityType(id, entityName, modId, entityClass, null);
            EntityTypeRegistryModule.getInstance().registerAdditionalCatalog(entityType);
        }
    }
}

