/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.powercrystals.netherores;

import forge.ITextureProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.World;
import net.minecraft.server.mod_NetherOres;
import net.minecraft.server.powercrystals.netherores.NetherOresCore;

public class BlockNetherOres
extends Block
implements ITextureProvider {
    private static int aggroRange = 32;

    public BlockNetherOres(int i, int j) {
        super(i, j, Block.NETHERRACK.material);
        this.c(5.0f);
        this.b(1.0f);
        this.a("blockNetherOres");
        this.a(h);
        this.j();
    }

    public int a(int i, int j) {
        return j & 7;
    }

    protected int getDropData(int i) {
        if ((i & 8) != 0) {
            i &= 0xFFFFFFF7;
        }
        return i;
    }

    public int a(Random random) {
        return 1;
    }

    public void a(World world, EntityHuman entityplayer, int i, int j, int k, int l) {
        if ((l & 8) != 0) {
            l &= 0xFFFFFFF7;
        }
        super.a(world, entityplayer, i, j, k, l);
        this.angerPigmen(entityplayer, world, i, j, k);
    }

    public void remove(World world, int i, int j, int k) {
        super.remove(world, i, j, k);
        int n = 0;
        while (n < Integer.parseInt(NetherOresCore.explosionChances.value)) {
            int tx = i - 1 + world.random.nextInt(3);
            int ty = j - 1 + world.random.nextInt(3);
            int tz = k - 1 + world.random.nextInt(3);
            if (tx != i && ty != j && tz != k && world.getTypeId(tx, ty, tz) == this.id) {
                world.setData(tx, ty, tz, world.getData(tx, ty, tz) | 8);
                world.c(tx, ty, tz, this.id, 75);
                mod_NetherOres.causeFuseSoundAt(world, i, j, k);
                break;
            }
            ++n;
        }
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if ((world.getData(i, j, k) & 8) == 0) {
            return;
        }
        double d = 0.0625;
        int l = 0;
        while (l < 6) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.r(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.r(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.r(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.r(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.r(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.r(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k || d3 > (double)(k + 1)) {
                world.a("smoke", d1, d2, d3, 0.0, 0.0, 0.0);
            }
            ++l;
        }
    }

    public void a(World world, int x, int y, int z, Random random) {
        if ((world.getData(x, y, z) & 8) > 0) {
            world.createExplosion(null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (float)Integer.parseInt(NetherOresCore.explosionPower.value), true);
        }
    }

    public String getTextureFile() {
        return NetherOresCore.terrainTexture;
    }

    private void angerPigmen(EntityHuman player, World world, int x, int y, int z) {
        List list = world.a(EntityPigZombie.class, AxisAlignedBB.b((double)(x - aggroRange), (double)(y - aggroRange), (double)(z - aggroRange), (double)(x + aggroRange + 1), (double)(y + aggroRange + 1), (double)(z + aggroRange + 1)));
        int j = 0;
        while (j < list.size()) {
            Entity entity1 = (Entity)list.get(j);
            if (entity1 instanceof EntityPigZombie) {
                EntityPigZombie entitypigzombie = (EntityPigZombie)entity1;
                entitypigzombie.damageEntity(DamageSource.playerAttack((EntityHuman)player), 0);
            }
            ++j;
        }
    }
}

