/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.powercrystals.netherores;

import forge.Configuration;
import forge.IOreHandler;
import forge.MinecraftForge;
import forge.Property;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import java.io.File;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.FurnaceRecipes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;
import net.minecraft.server.World;
import net.minecraft.server.powercrystals.netherores.BlockNetherOres;
import net.minecraft.server.powercrystals.netherores.ItemNetherOre;
import net.minecraft.server.powercrystals.netherores.WorldGenNetherOres;

public class NetherOresCore {
    public static String terrainTexture = "/NetherOresSprites/block0.png";
    public static Block blockNetherOres;
    public static Property netherOreBlockId;
    public static Property explosionPower;
    public static Property explosionChances;
    public static Property enableStandardFurnaceRecipes;
    public static Property enableMaceratorRecipes;
    public static boolean foundTin;
    public static boolean foundCopper;
    public static String version;
    public static String priorities;

    static {
        version = "1.2.5R1.2.2";
        priorities = "after:mod_IC2;after:mod_RedPowerCore";
    }

    public static void init(String configPath, boolean onServer) {
        NetherOresCore.loadConfig(configPath);
        blockNetherOres = new BlockNetherOres(Integer.parseInt(NetherOresCore.netherOreBlockId.value), 0);
        ModLoader.registerBlock((Block)blockNetherOres, ItemNetherOre.class);
        MinecraftForge.registerOreHandler((IOreHandler)new NetherOresCore().new OreHandler());
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)1, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)2, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)3, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)4, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)5, (String)"pickaxe", (int)2);
        MinecraftForge.registerOre((String)"oreNetherCoal", (ItemStack)new ItemStack(blockNetherOres, 1, 0));
        MinecraftForge.registerOre((String)"oreNetherDiamond", (ItemStack)new ItemStack(blockNetherOres, 1, 1));
        MinecraftForge.registerOre((String)"oreNetherGold", (ItemStack)new ItemStack(blockNetherOres, 1, 2));
        MinecraftForge.registerOre((String)"oreNetherIron", (ItemStack)new ItemStack(blockNetherOres, 1, 3));
        MinecraftForge.registerOre((String)"oreNetherLapis", (ItemStack)new ItemStack(blockNetherOres, 1, 4));
        MinecraftForge.registerOre((String)"oreNetherRedstone", (ItemStack)new ItemStack(blockNetherOres, 1, 5));
        MinecraftForge.registerOre((String)"oreNetherCopper", (ItemStack)new ItemStack(blockNetherOres, 1, 6));
        MinecraftForge.registerOre((String)"oreNetherTin", (ItemStack)new ItemStack(blockNetherOres, 1, 7));
        if (Boolean.parseBoolean(NetherOresCore.enableMaceratorRecipes.value) && ModLoader.isModLoaded((String)"mod_IC2")) {
            ItemStack goldDust = Items.getItem((String)"goldDust");
            ItemStack ironDust = Items.getItem((String)"ironDust");
            Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 0), (ItemStack)new ItemStack(Item.COAL, 2));
            Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 1), (ItemStack)new ItemStack(Item.DIAMOND, 2));
            if (goldDust != null) {
                Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 2), (ItemStack)new ItemStack(goldDust.id, 4, 0));
            }
            if (ironDust != null) {
                Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 3), (ItemStack)new ItemStack(ironDust.id, 4, 0));
            }
            Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 4), (ItemStack)new ItemStack(Item.INK_SACK, 8, 4));
            Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 5), (ItemStack)new ItemStack(Item.REDSTONE, 6));
            System.out.println("NetherOres: loaded Macerator Recipes");
        }
        if (Boolean.parseBoolean(NetherOresCore.enableStandardFurnaceRecipes.value)) {
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 0, new ItemStack(Item.COAL));
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 1, new ItemStack(Item.DIAMOND));
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 2, new ItemStack(Block.GOLD_ORE));
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 3, new ItemStack(Block.IRON_ORE));
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 4, new ItemStack(Item.INK_SACK, 8, 4));
            FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 5, new ItemStack(Item.REDSTONE, 6));
        }
    }

    private static void loadConfig(String path) {
        File f = new File(path);
        Configuration c = new Configuration(f);
        c.load();
        netherOreBlockId = c.getOrCreateBlockIdProperty("ID.NetherOreBlock", 140);
        explosionPower = c.getOrCreateIntProperty("ExplosionPower", "general", 2);
        NetherOresCore.explosionPower.comment = "How powerful an explosion will be. Creepers are 3, TNT is 4, electrified creepers are 6. This affects both the ability of the explosion to punch through blocks as well as the blast radius.";
        explosionChances = c.getOrCreateIntProperty("ExplosionChances", "general", 3);
        NetherOresCore.explosionChances.comment = "The number of chances a nether ore has to find another one to detonate. When a nether ore block is mined, it searches a random adjacent block. If that block is a nether ore, it becomes armed. This number controls how many times it searches. It will not stop at arming only one if it finds more than one.";
        enableStandardFurnaceRecipes = c.getOrCreateBooleanProperty("EnableStandardFurnaceRecipes", "general", true);
        NetherOresCore.enableStandardFurnaceRecipes.comment = "Set this to false to remove the standard furnace recipes (ie, nether iron ore -> normal iron ore). Provided for compatibility with Metallurgy. If you set this to false and no other mod connects to this mod's ores, they will be useless.";
        enableMaceratorRecipes = c.getOrCreateBooleanProperty("EnableMaceratorRecipes", "general", true);
        NetherOresCore.enableMaceratorRecipes.comment = "Set this to false to disable use of these ores in the IC2 Macerator.";
        c.save();
    }

    public static void generateNether(World world, Random random, int chunkX, int chunkZ) {
        int i = 0;
        while (i < 24) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 0, 12).a(world, random, chunkX + random.nextInt(16), random.nextInt(128), chunkZ + random.nextInt(16));
            ++i;
        }
        i = 0;
        while (i < 3) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 1, 8).a(world, random, chunkX + random.nextInt(16), random.nextInt(32), chunkZ + random.nextInt(16));
            ++i;
        }
        i = 0;
        while (i < 4) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 2, 10).a(world, random, chunkX + random.nextInt(16), random.nextInt(96), chunkZ + random.nextInt(16));
            ++i;
        }
        i = 0;
        while (i < 8) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 3, 14).a(world, random, chunkX + random.nextInt(16), random.nextInt(96), chunkZ + random.nextInt(16));
            ++i;
        }
        i = 0;
        while (i < 6) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 4, 3).a(world, random, chunkX + random.nextInt(16), random.nextInt(128), chunkZ + random.nextInt(16));
            ++i;
        }
        i = 0;
        while (i < 8) {
            new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 5, 9).a(world, random, chunkX + random.nextInt(16), random.nextInt(96), chunkZ + random.nextInt(16));
            ++i;
        }
        if (foundCopper) {
            i = 0;
            while (i < 8) {
                new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 6, 14).a(world, random, chunkX + random.nextInt(16), random.nextInt(96), chunkZ + random.nextInt(16));
                ++i;
            }
        }
        if (foundTin) {
            i = 0;
            while (i < 8) {
                new WorldGenNetherOres(NetherOresCore.blockNetherOres.id, 7, 14).a(world, random, chunkX + random.nextInt(16), random.nextInt(96), chunkZ + random.nextInt(16));
                ++i;
            }
        }
    }

    public class OreHandler
    implements IOreHandler {
        public void registerOre(String oreClass, ItemStack ore) {
            ItemStack smeltedOre;
            if (oreClass == "oreCopper" && !foundCopper) {
                foundCopper = true;
                smeltedOre = ore.cloneItemStack();
                smeltedOre.count = 1;
                MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)6, (String)"pickaxe", (int)1);
                if (Boolean.parseBoolean(NetherOresCore.enableStandardFurnaceRecipes.value)) {
                    FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 6, smeltedOre);
                }
                if (Boolean.parseBoolean(NetherOresCore.enableMaceratorRecipes.value) && ModLoader.isModLoaded((String)"mod_IC2")) {
                    Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 6), (ItemStack)new ItemStack(smeltedOre.getItem(), 2));
                }
            }
            if (oreClass == "oreTin" && !foundTin) {
                foundTin = true;
                smeltedOre = ore.cloneItemStack();
                smeltedOre.count = 1;
                FurnaceRecipes.getInstance().addSmelting(NetherOresCore.blockNetherOres.id, 7, smeltedOre);
                if (Boolean.parseBoolean(NetherOresCore.enableStandardFurnaceRecipes.value)) {
                    MinecraftForge.setBlockHarvestLevel((Block)blockNetherOres, (int)7, (String)"pickaxe", (int)1);
                }
                if (Boolean.parseBoolean(NetherOresCore.enableMaceratorRecipes.value) && ModLoader.isModLoaded((String)"mod_IC2")) {
                    Ic2Recipes.addMaceratorRecipe((ItemStack)new ItemStack(NetherOresCore.blockNetherOres.id, 1, 7), (ItemStack)new ItemStack(smeltedOre.getItem(), 2));
                }
            }
        }
    }
}

