/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;

public class WM_EntityBlunderShot
extends WM_EntityProjectile {
    private double startPosX;
    private double startPosY;
    private double startPosZ;

    public WM_EntityBlunderShot(World world) {
        super(world);
    }

    public WM_EntityBlunderShot(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
        this.startPosX = this.locX;
        this.startPosY = this.locY;
        this.startPosZ = this.locZ;
    }

    public WM_EntityBlunderShot(World world, EntityLiving entityLiving) {
        this(world);
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.b(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.startPosX = this.locX;
        this.startPosY = this.locY;
        this.startPosZ = this.locZ;
        this.setArrowHeading(this.motX, this.motY, this.motZ, 5.0f, 15.0f);
    }

    @Override
    public void F_() {
        super.F_();
        if (this.ticksInAir > 4) {
            this.die();
        }
    }

    @Override
    public void onEntityHit(Entity entity) {
        float f = (float)this.getPassedDistance(entity.locX, entity.locY, entity.locZ);
        int n = MathHelper.d((float)(25.0f - f));
        if (n < 1) {
            n = 1;
        }
        if (n > 20) {
            n = 20;
        }
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        if (entity.damageEntity(damageSource, n)) {
            this.die();
        }
    }

    @Override
    public void onGroundHit(MovingObjectPosition movingObjectPosition) {
        this.xTile = movingObjectPosition.b;
        this.yTile = movingObjectPosition.c;
        this.zTile = movingObjectPosition.d;
        this.inTile = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
        this.inData = this.world.getData(this.xTile, this.yTile, this.zTile);
        Material material = this.world.getMaterial(this.xTile, this.yTile, this.zTile);
        boolean bl = material.equals(Material.STONE);
        boolean bl2 = material.equals(Material.ORE);
        if (this.ticksInAir > 0 && (bl || bl2)) {
            if (bl2) {
                this.locX = this.xTile;
                this.locY = this.yTile;
                this.locZ = this.zTile;
                if (movingObjectPosition.face == 0 || movingObjectPosition.face == 1) {
                    this.motY *= -1.0;
                } else if (movingObjectPosition.face == 2 || movingObjectPosition.face == 3) {
                    this.motZ *= -1.0;
                } else if (movingObjectPosition.face == 4 || movingObjectPosition.face == 5) {
                    this.motX *= -1.0;
                }
                this.motX *= (double)0.6f;
                this.motY *= (double)0.6f;
                this.motZ *= (double)0.6f;
            } else if (bl) {
                this.motX *= (double)(0.5f - this.random.nextFloat());
                this.motY *= (double)(0.5f - this.random.nextFloat());
                this.motZ *= (double)(0.5f - this.random.nextFloat());
            }
            this.world.makeSound((double)this.xTile, (double)this.yTile, (double)this.zTile, "note.hat", 2.0f, this.random.nextFloat() * 0.4f + 0.4f);
        } else {
            this.motX = (float)(movingObjectPosition.pos.a - this.locX);
            this.motY = (float)(movingObjectPosition.pos.b - this.locY);
            this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
            float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
            this.locX -= this.motX / (double)f * 0.05;
            this.locY -= this.motY / (double)f * 0.05;
            this.locZ -= this.motZ / (double)f * 0.05;
            this.inGround = true;
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() >= 2.0 ? 0.0f : 0.04f;
    }

    public double getPassedDistance(double d, double d2, double d3) {
        double d4 = d - this.startPosX;
        double d5 = d2 - this.startPosY;
        double d6 = d3 - this.startPosZ;
        return Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public static void fireSpreadShot(World world, EntityLiving entityLiving) {
        for (int i = 0; i < 10; ++i) {
            world.addEntity((Entity)new WM_EntityBlunderShot(world, entityLiving));
        }
    }

    public static void fireSpreadShot(World world, double d, double d2, double d3) {
        for (int i = 0; i < 10; ++i) {
            world.addEntity((Entity)new WM_EntityBlunderShot(world, d, d2, d3));
        }
    }

    public static void fireFromDispenser(World world, double d, double d2, double d3, int n, int n2) {
        for (int i = 0; i < 10; ++i) {
            WM_EntityBlunderShot wM_EntityBlunderShot = new WM_EntityBlunderShot(world, d, d2, d3);
            wM_EntityBlunderShot.setArrowHeading(n, 0.0, n2, 5.0f, 15.0f);
            world.addEntity((Entity)wM_EntityBlunderShot);
        }
    }
}

