/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityDamageSourceIndirect;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityWeatherLighting;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.ModLoader;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.WM_EntityCannonBall;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityCannon
extends Entity {
    private int loadTimer = 0;
    public boolean isLoading = false;
    public boolean isLoaded = false;
    public boolean isSuperPowered = false;
    public int cannonCurrentDamage = 0;
    public int cannonTimeSinceHit = 0;
    public int cannonRockDirection = 1;

    public WM_EntityCannon(World world) {
        super(world);
        this.bf = true;
        this.pitch = -20.0f;
        this.c(this.yaw, this.pitch);
        this.b(1.5f, 1.0f);
        this.height = this.length / 2.0f;
    }

    public WM_EntityCannon(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motZ = 0.0;
        this.motY = 0.0;
        this.motX = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    protected void b() {
    }

    public AxisAlignedBB b_(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB h() {
        return this.boundingBox;
    }

    public boolean e_() {
        return false;
    }

    public double x_() {
        return 0.15;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic || this.dead) {
            return true;
        }
        if (damageSource instanceof EntityDamageSourceIndirect && ((EntityDamageSource)damageSource).getEntity().equals((Object)this.passenger)) {
            return true;
        }
        this.cannonRockDirection = -this.cannonRockDirection;
        this.cannonTimeSinceHit = 10;
        this.cannonCurrentDamage += n * 5;
        this.aW();
        if (this.cannonCurrentDamage > 100) {
            if (this.passenger != null) {
                this.passenger.mount((Entity)this);
            }
            if (n < 3 && !damageSource.k()) {
                this.dropItemWithChance(mod_WeaponMod.cannon.id, n, 1, 0.0f);
            } else {
                for (int i = 0; i < 6; ++i) {
                    this.dropItemWithChance(Item.IRON_INGOT.id, n, 1, 0.0f);
                }
                this.dropItemWithChance(Item.FLINT.id, n, 1, 0.0f);
                this.dropItemWithChance(Block.LOG.id, n, 1, 0.0f);
            }
            if (this.isLoaded || this.isLoading) {
                this.dropItemWithChance(mod_WeaponMod.cannonBall.id, n, 1, 0.0f);
                this.dropItemWithChance(Item.SULPHUR.id, n, 1, 0.0f);
            }
            this.die();
        }
        return true;
    }

    public void dropItemWithChance(int n, int n2, int n3, float f) {
        if (this.random.nextInt(n2) < 10) {
            this.a(n, n3, f);
        }
    }

    public void performHurtAnimation() {
        this.cannonRockDirection = -this.cannonRockDirection;
        this.cannonTimeSinceHit = 10;
        this.cannonCurrentDamage += this.cannonCurrentDamage * 10;
    }

    public boolean o_() {
        return !this.dead;
    }

    public void F_() {
        int n;
        super.F_();
        if (this.cannonTimeSinceHit > 0) {
            --this.cannonTimeSinceHit;
        }
        if (this.cannonCurrentDamage > 0) {
            this.cannonCurrentDamage -= this.random.nextInt(2);
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        if (this.onGround) {
            this.motX *= 0.1;
            this.motY = 0.0;
            this.motZ *= 0.1;
        } else {
            this.motX *= 0.9;
            this.motZ *= 0.9;
            this.motY -= 0.1;
            this.fallDistance = (float)((double)this.fallDistance + -this.motY);
        }
        if (this.motY < -0.1) {
            this.passenger = null;
        }
        if (this.passenger == null) {
            // empty if block
        }
        this.c(this.yaw, this.pitch);
        this.move(this.motX, this.motY, this.motZ);
        List list = this.world.getEntities((Entity)this, this.boundingBox.grow(0.2, 0.0, 0.2));
        if (list != null && list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                Entity entity = (Entity)list.get(n);
                if (entity == this.passenger || !entity.e_()) continue;
                entity.collide((Entity)this);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n2;
            int n3;
            int n4 = MathHelper.floor((double)(this.locX + ((double)(n % 2) - 0.5) * 0.8));
            if (this.world.getTypeId(n4, n3 = MathHelper.floor((double)this.locY), n2 = MathHelper.floor((double)(this.locZ + ((double)(n / 2) - 0.5) * 0.8))) != Block.SNOW.id) continue;
            this.world.setTypeId(n4, n3, n2, 0);
        }
        if (this.passenger != null) {
            if (this.passenger.dead) {
                this.passenger = null;
            } else if (this.passenger instanceof EntityLiving && ((EntityLiving)this.passenger).aZ) {
                this.shootCannon();
            }
        }
        if (this.isLoading) {
            this.handleReloadTime(this.loadTimer);
            --this.loadTimer;
        }
    }

    protected void a(float f) {
        super.a(f);
        if (!this.onGround) {
            return;
        }
        int n = MathHelper.d((float)f);
        this.damageEntity(DamageSource.FALL, n *= 2);
    }

    public void handleReloadTime(int n) {
        this.loadTimer = n;
        if (this.loadTimer > 0) {
            if (this.loadTimer == 80 || this.loadTimer == 70 || this.loadTimer == 60) {
                this.world.makeSound((Entity)this, "tile.piston.in", 0.5f, 1.2f / (this.random.nextFloat() * 0.8f + 0.6f));
            } else if (this.loadTimer == 40) {
                this.world.makeSound((Entity)this, "random.breath", 0.7f, 1.2f / (this.random.nextFloat() * 0.2f + 10.0f));
            }
        } else {
            this.setReloadInfo(true, false, 0);
        }
    }

    public void shootCannon() {
        if (!this.isLoaded) {
            return;
        }
        if (!this.world.isStatic) {
            WM_EntityCannonBall wM_EntityCannonBall = new WM_EntityCannonBall(this.world, this, this.isSuperPowered);
            this.world.addEntity((Entity)wM_EntityCannonBall);
        }
        this.setReloadInfo(false, false, this.loadTimer);
        this.shootEffects();
    }

    public void shootEffects() {
        this.damageEntity(DamageSource.EXPLOSION, 2);
        if (!this.world.isStatic) {
            byte[] byArray = new byte[]{(byte)(this.id & 0xFF), (byte)(this.id >> 8 & 0xFF), (byte)(this.id >> 16 & 0xFF), (byte)(this.id >> 24 & 0xFF)};
            Packet250CustomPayload packet250CustomPayload = new Packet250CustomPayload();
            packet250CustomPayload.tag = "wpnmodFireCann";
            packet250CustomPayload.length = byArray.length;
            packet250CustomPayload.data = byArray;
            ModLoader.getMinecraftServerInstance().serverConfigurationManager.sendAll((Packet)packet250CustomPayload);
        }
    }

    public void setReloadInfo(boolean bl, boolean bl2, int n) {
        this.isLoaded = bl;
        this.isLoading = bl2;
        this.loadTimer = n;
        this.sendReloadInfo();
    }

    private void sendReloadInfo() {
        if (this.world.isStatic) {
            return;
        }
        byte[] byArray = new byte[8];
        byArray[0] = (byte)(this.id & 0xFF);
        byArray[1] = (byte)(this.id >> 8 & 0xFF);
        byArray[2] = (byte)(this.id >> 16 & 0xFF);
        byArray[3] = (byte)(this.id >> 24 & 0xFF);
        byArray[4] = (byte)(this.isLoaded ? 1 : 0);
        byArray[5] = (byte)(this.isLoading ? 1 : 0);
        byArray[6] = (byte)this.loadTimer;
        Packet250CustomPayload packet250CustomPayload = new Packet250CustomPayload();
        packet250CustomPayload.tag = "wpnmodCannon";
        packet250CustomPayload.length = byArray.length;
        packet250CustomPayload.data = byArray;
        ModLoader.getMinecraftServerInstance().serverConfigurationManager.sendAll((Packet)packet250CustomPayload);
    }

    public void loadCannon() {
        if (this.isLoaded && !this.isLoading) {
            return;
        }
        this.setReloadInfo(false, true, 100);
    }

    public void i_() {
        if (this.passenger == null) {
            return;
        }
        double d = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.85f;
        double d2 = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.85f;
        this.passenger.setPosition(this.locX + d, this.locY + this.x_() + this.passenger.W(), this.locZ + d2);
    }

    public float getShadowSize() {
        return 1.0f;
    }

    protected void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setFloat("FallDistance", this.fallDistance);
        nBTTagCompound.setBoolean("OnGround", this.onGround);
        nBTTagCompound.setBoolean("Powered", this.isSuperPowered);
        nBTTagCompound.setBoolean("Loaded", this.isLoaded);
    }

    protected void a(NBTTagCompound nBTTagCompound) {
        this.isSuperPowered = nBTTagCompound.getBoolean("Powered");
        this.setReloadInfo(nBTTagCompound.getBoolean("Loaded"), this.isLoading, this.loadTimer);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.c(this.yaw, this.pitch);
    }

    public boolean b(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.U();
        if (itemStack != null && itemStack.getItem().id == mod_WeaponMod.cannonBall.id && !this.isLoaded && !this.isLoading && entityHuman.inventory.c(Item.SULPHUR.id)) {
            if (entityHuman.inventory.c(mod_WeaponMod.cannonBall.id)) {
                this.loadCannon();
            } else {
                this.a(Item.SULPHUR.id, 1, 0.0f);
            }
            return true;
        }
        if (this.world.isStatic) {
            return true;
        }
        if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
            return true;
        }
        entityHuman.mount((Entity)this);
        return true;
    }

    public void a(EntityWeatherLighting entityWeatherLighting) {
        this.damageEntity(null, 100);
        this.isSuperPowered = true;
    }
}

