/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.WM_EntityCannon;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_PhysHelper;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityCannonBall
extends WM_EntityProjectile {
    public WM_EntityCannonBall(World world) {
        super(world);
    }

    public WM_EntityCannonBall(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public WM_EntityCannonBall(World world, WM_EntityCannon wM_EntityCannon, boolean bl) {
        this(world);
        this.shootingEntity = wM_EntityCannon.passenger;
        this.doesArrowBelongToPlayer = wM_EntityCannon.passenger instanceof EntityHuman;
        this.b(0.5f, 0.5f);
        this.setPositionRotation(wM_EntityCannon.locX, wM_EntityCannon.locY + 1.0, wM_EntityCannon.locZ, wM_EntityCannon.passenger.yaw, wM_EntityCannon.passenger.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.1;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.height = 0.0f;
        this.motX = -MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.pitch / 180.0f * (float)Math.PI));
        this.locX += this.motX * (double)1.2f;
        this.locY += this.motY * (double)1.2f;
        this.locZ += this.motZ * (double)1.2f;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.isCritical = bl;
        this.setArrowHeading(this.motX, this.motY, this.motZ, bl ? 4.0f : 2.0f, bl ? 0.1f : 2.0f);
    }

    @Override
    public void F_() {
        super.F_();
        double d = Math.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
        double d2 = 8.0;
        if (d > 1.0) {
            int n = 1;
            while ((double)n < d2) {
                this.world.a("smoke", this.locX + this.motX * (double)n / d2, this.locY + this.motY * (double)n / d2, this.locZ + this.motZ * (double)n / d2, 0.0, 0.0, 0.0);
                ++n;
            }
        }
    }

    public void createCrater() {
        if (this.world.isStatic || !this.inGround || this.aU()) {
            return;
        }
        this.die();
        float f = this.isCritical ? 5.0f : 2.5f;
        WM_PhysHelper.createAdvancedExplosion(this.world, this, this.locX, this.locY, this.locZ, f, false, mod_WeaponMod.instance.properties.cannonDoesBlockDamage, true);
    }

    @Override
    public void onEntityHit(Entity entity) {
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : WM_WeaponDamageSource.causeWeaponDamage(this, this.shootingEntity);
        if (entity.damageEntity(damageSource, 30)) {
            this.world.makeSound((Entity)this, "random.damage.hurtflesh", 1.0f, 1.2f / (this.random.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void onGroundHit(MovingObjectPosition movingObjectPosition) {
        this.xTile = movingObjectPosition.b;
        this.yTile = movingObjectPosition.c;
        this.zTile = movingObjectPosition.d;
        this.inTile = this.world.getTypeId(this.xTile, this.yTile, this.zTile);
        this.inData = this.world.getData(this.xTile, this.yTile, this.zTile);
        this.motX = (float)(movingObjectPosition.pos.a - this.locX);
        this.motY = (float)(movingObjectPosition.pos.b - this.locY);
        this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
        float f = MathHelper.sqrt((double)(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ));
        this.locX -= this.motX / (double)f * 0.05;
        this.locY -= this.motY / (double)f * 0.05;
        this.locZ -= this.motZ / (double)f * 0.05;
        this.inGround = true;
        this.createCrater();
    }

    @Override
    public float getAirResistance() {
        return 0.97f;
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    public ItemStack getPickupItem() {
        return new ItemStack(mod_WeaponMod.cannonBall, 1);
    }

    @Override
    public float getShadowSize() {
        return 0.5f;
    }
}

