/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.ModLoader;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.WM_EntityProjectile;
import net.minecraft.server.WM_ItemFlail;
import net.minecraft.server.WM_WeaponDamageSource;
import net.minecraft.server.World;
import net.minecraft.server.mod_WeaponMod;

public class WM_EntityFlail
extends WM_EntityProjectile {
    private WM_ItemFlail itemFlail;
    public EnumToolMaterial enumToolMaterial;
    public boolean isSwinging;
    private int weaponDamage;
    private double distanceTotal;
    private double distanceX;
    private double distanceY;
    private double distanceZ;

    public WM_EntityFlail(World world) {
        super(world);
        this.setSourceItem(mod_WeaponMod.flailWood.id);
        this.distanceTotal = 0.0;
    }

    public WM_EntityFlail(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
    }

    public WM_EntityFlail(World world, EntityLiving entityLiving, int n) {
        this(world);
        this.setSourceItem(n);
        this.shootingEntity = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityHuman;
        this.distanceTotal = 0.0;
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.locY -= 0.4;
        this.locZ -= (double)(MathHelper.sin((float)(this.yaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.swing();
        this.sendItemData();
    }

    public void setSourceItem(int n) {
        this.itemFlail = Item.byId[n] instanceof WM_ItemFlail ? (WM_ItemFlail)Item.byId[n] : null;
        this.enumToolMaterial = this.itemFlail != null ? this.itemFlail.enumToolMaterial : EnumToolMaterial.WOOD;
        this.weaponDamage = (int)(4.0f + (float)this.enumToolMaterial.c() * 2.0f);
    }

    public void sendItemData() {
        Packet250CustomPayload packet250CustomPayload = new Packet250CustomPayload();
        packet250CustomPayload.tag = "wpnmodFlail";
        packet250CustomPayload.data = new byte[8];
        packet250CustomPayload.length = packet250CustomPayload.data.length;
        packet250CustomPayload.data[0] = (byte)(this.id & 0xFF);
        packet250CustomPayload.data[1] = (byte)(this.id >> 8 & 0xFF);
        packet250CustomPayload.data[2] = (byte)(this.id >> 16 & 0xFF);
        packet250CustomPayload.data[3] = (byte)(this.id >> 24 & 0xFF);
        packet250CustomPayload.data[4] = (byte)(this.itemFlail.id & 0xFF);
        packet250CustomPayload.data[5] = (byte)(this.itemFlail.id >> 8 & 0xFF);
        packet250CustomPayload.data[6] = (byte)(this.itemFlail.id >> 16 & 0xFF);
        packet250CustomPayload.data[7] = (byte)(this.itemFlail.id >> 24 & 0xFF);
        ModLoader.getMinecraftServerInstance().serverConfigurationManager.sendAll((Packet)packet250CustomPayload);
    }

    @Override
    public void F_() {
        super.F_();
        if (this.shootingEntity != null) {
            ItemStack itemStack;
            this.distanceX = this.shootingEntity.locX - this.locX;
            this.distanceY = this.shootingEntity.locY - this.locY;
            this.distanceZ = this.shootingEntity.locZ - this.locZ;
            this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
            if (this.distanceTotal > 3.0) {
                this.returnToOwner(this.shootingEntity, true);
            }
            if (this.shootingEntity instanceof EntityHuman && ((itemStack = ((EntityHuman)this.shootingEntity).U()) == null || itemStack.getItem() != this.itemFlail)) {
                this.pickUpByOwner();
            }
        }
        if (this.inGround) {
            this.inGround = false;
            return;
        }
        this.returnToOwner(this.shootingEntity, false);
    }

    public void returnToOwner(Entity entity, boolean bl) {
        if (entity == null) {
            return;
        }
        if (bl) {
            this.inGround = false;
        }
        double d = this.shootingEntity.locX;
        double d2 = this.shootingEntity.boundingBox.b + (double)0.4f;
        double d3 = this.shootingEntity.locZ;
        float f = 27.0f;
        float f2 = 2.0f;
        this.distanceX = (d += -Math.sin((double)((this.shootingEntity.yaw + f) / 180.0f) * Math.PI) * Math.cos((double)(this.shootingEntity.pitch / 180.0f) * Math.PI) * (double)f2) - this.locX;
        this.distanceY = d2 - this.locY;
        this.distanceZ = (d3 += Math.cos((double)((this.shootingEntity.yaw + f) / 180.0f) * Math.PI) * Math.cos((double)(this.shootingEntity.pitch / 180.0f) * Math.PI) * (double)f2) - this.locZ;
        this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
        if (this.distanceTotal > 3.0) {
            this.locX = d;
            this.locY = d2;
            this.locZ = d3;
        } else if (this.distanceTotal > 2.5) {
            this.isSwinging = false;
            this.motX *= -0.5;
            this.motY *= -0.5;
            this.motZ *= -0.5;
        }
        if (!this.isSwinging) {
            float f3 = 0.2f;
            this.motX = this.distanceX * (double)f3 * this.distanceTotal;
            this.motY = this.distanceY * (double)f3 * this.distanceTotal;
            this.motZ = this.distanceZ * (double)f3 * this.distanceTotal;
        }
    }

    public void pickUpByOwner() {
        this.die();
        this.itemFlail.setThrown(false);
    }

    public void swing() {
        if (this.isSwinging) {
            return;
        }
        this.world.makeSound(this.shootingEntity, "random.bow", 0.5f, 0.4f / (this.random.nextFloat() * 0.4f + 0.8f));
        this.motX = -MathHelper.sin((float)(this.shootingEntity.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.shootingEntity.pitch / 180.0f * (float)Math.PI));
        this.motY = -MathHelper.sin((float)(this.shootingEntity.pitch / 180.0f * (float)Math.PI));
        this.motZ = MathHelper.cos((float)(this.shootingEntity.yaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.shootingEntity.pitch / 180.0f * (float)Math.PI));
        this.setArrowHeading(this.motX, this.motY, this.motZ, 0.75f, 3.0f);
        this.isSwinging = true;
        this.inGround = false;
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (entity == this.shootingEntity) {
            return;
        }
        DamageSource damageSource = null;
        damageSource = this.shootingEntity == null ? WM_WeaponDamageSource.causeWeaponDamage(this, this) : DamageSource.mobAttack((EntityLiving)((EntityLiving)this.shootingEntity));
        if (entity.damageEntity(damageSource, this.weaponDamage)) {
            this.playHitSound();
            this.returnToOwner(this.shootingEntity, true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.motX *= -0.8;
        this.motY *= -0.8;
        this.motZ *= -0.8;
        this.yaw += 180.0f;
        this.lastYaw += 180.0f;
        this.ticksInAir = 0;
    }

    @Override
    public void playHitSound() {
        if (this.inGround) {
            return;
        }
        this.world.makeSound((Entity)this, "damage.hurtflesh", 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setByte("damage", (byte)this.weaponDamage);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.weaponDamage = nBTTagCompound.getByte("damage");
    }

    @Override
    public void a_(EntityHuman entityHuman) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getShadowSize() {
        return 0.2f;
    }
}

