/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumToolMaterial;
import net.minecraft.server.ItemStack;
import net.minecraft.server.WM_EnumWeapon;
import net.minecraft.server.WM_ItemWeaponMod;
import net.minecraft.server.WM_ReloadProgress;
import net.minecraft.server.World;

public abstract class WM_ItemReloadable
extends WM_ItemWeaponMod {
    protected int clickDelay = 20;
    protected int reloadClicks;
    protected static final int MAX_DELAY = 72000;

    protected WM_ItemReloadable(int n, EnumToolMaterial enumToolMaterial, WM_EnumWeapon wM_EnumWeapon, int n2) {
        super(n, enumToolMaterial, wM_EnumWeapon);
        this.reloadClicks = n2;
        this.clickDelay = 72000;
    }

    protected final void cycleReloadProgress(ItemStack itemStack, World world, EntityHuman entityHuman) {
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.getReloadProgress(itemStack);
        this.onReloadClick(wM_ReloadProgress.progress, itemStack, world, entityHuman);
        if (wM_ReloadProgress.progress >= this.reloadClicks) {
            wM_ReloadProgress.reloaded = true;
            this.clickDelay = 72000;
        } else {
            this.clickDelay = this.getReloadClickDelay(wM_ReloadProgress.progress, itemStack);
            ++wM_ReloadProgress.progress;
        }
    }

    protected abstract void onReloadClick(int var1, ItemStack var2, World var3, EntityHuman var4);

    public abstract int getReloadClickDelay(int var1, ItemStack var2);

    public abstract int getAmmoItemId();

    public abstract void fire(ItemStack var1, World var2, EntityHuman var3, int var4);

    public void resetReload(ItemStack itemStack) {
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.getReloadProgress(itemStack);
        wM_ReloadProgress.resetReload();
        this.clickDelay = this.getReloadClickDelay(wM_ReloadProgress.progress, itemStack);
    }

    @Override
    public final void a(ItemStack itemStack, World world, EntityHuman entityHuman, int n) {
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.getReloadProgress(itemStack);
        if (wM_ReloadProgress == null) {
            return;
        }
        if (!wM_ReloadProgress.reloaded) {
            this.resetReload(itemStack);
        }
        if (wM_ReloadProgress.reloaded) {
            if (wM_ReloadProgress.isReloading) {
                wM_ReloadProgress.isReloading = false;
            } else {
                if (!entityHuman.abilities.canInstantlyBuild && !entityHuman.inventory.c(this.getAmmoItemId())) {
                    this.resetReload(itemStack);
                    return;
                }
                this.fire(itemStack, world, entityHuman, n);
            }
        }
    }

    @Override
    public final int c(ItemStack itemStack) {
        return this.clickDelay;
    }

    @Override
    public EnumAnimation d(ItemStack itemStack) {
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.getReloadProgress(itemStack);
        return wM_ReloadProgress == null || !wM_ReloadProgress.isReloading ? EnumAnimation.e : EnumAnimation.d;
    }

    @Override
    public final ItemStack a(ItemStack itemStack, World world, EntityHuman entityHuman) {
        if (itemStack.count <= 0) {
            return itemStack;
        }
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.registerItemStack(itemStack);
        if (wM_ReloadProgress == null) {
            return itemStack;
        }
        if (!wM_ReloadProgress.isReloading) {
            if (wM_ReloadProgress.reloaded) {
                this.playChargeSound(itemStack, world, entityHuman);
                entityHuman.a(itemStack, this.c(itemStack));
            } else {
                wM_ReloadProgress.isReloading = true;
            }
        } else if (wM_ReloadProgress.reloaded) {
            wM_ReloadProgress.resetReload();
        }
        if (wM_ReloadProgress.isReloading && !wM_ReloadProgress.reloaded) {
            if (entityHuman.abilities.canInstantlyBuild || entityHuman.inventory.d(this.getAmmoItemId())) {
                this.cycleReloadProgress(itemStack, world, entityHuman);
                entityHuman.a(itemStack, this.c(itemStack));
            } else {
                this.playEmptySound(itemStack, world, entityHuman);
                this.resetReload(itemStack);
            }
        }
        return itemStack;
    }

    public void playEmptySound(ItemStack itemStack, World world, EntityHuman entityHuman) {
        world.makeSound((Entity)entityHuman, "random.click", 1.0f, 1.25f);
    }

    public void playChargeSound(ItemStack itemStack, World world, EntityHuman entityHuman) {
    }

    protected void postShootingEffects(ItemStack itemStack, EntityHuman entityHuman, World world, boolean bl) {
    }
}

