/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.server.Block;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ModLoader;
import net.minecraft.server.WM_WeaponStorage;
import net.minecraft.server.mod_WeaponMod;

public class WM_Properties {
    public boolean cannonDoesBlockDamage;
    public boolean dynamiteDoesBlockDamage;
    public boolean canThrowKnife;
    public boolean canThrowSpear;
    private mod_WeaponMod baseMod;

    public WM_Properties(mod_WeaponMod mod_WeaponMod2) {
        this.baseMod = mod_WeaponMod2;
    }

    public void loadAllProperties() {
        Properties properties = new Properties();
        if (this.loadFromFile(properties)) {
            this.readProperties(properties);
            this.processProperties(properties);
        } else {
            this.setStandardSettings();
            this.createFile(properties);
            this.processProperties(properties);
        }
    }

    private boolean loadFromFile(Properties properties) {
        try {
            String string = mod_WeaponMod.getServerLocation().getCanonicalPath() + "/mods/weaponmod/weaponmod.properties";
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            MinecraftServer.log.warning("[WeaponMod] Unable to read from properties.");
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void readProperties(Properties properties) {
        Object object2;
        int n = 0;
        for (Object object2 : WM_WeaponStorage.propsMap.values()) {
            String string = properties.getProperty(((WM_WeaponStorage)object2).weaponName);
            if (string == null || string.length() == 0) {
                if (((WM_WeaponStorage)object2).isIndependant) {
                    ++n;
                }
                ((WM_WeaponStorage)object2).isEnabled = true;
            } else {
                ((WM_WeaponStorage)object2).isEnabled = Boolean.parseBoolean(string);
            }
            if (!((WM_WeaponStorage)object2).isEnabled && ((WM_WeaponStorage)object2).isIndependant) continue;
            if (((WM_WeaponStorage)object2).useMaterials) {
                int[] nArray = new int[WM_WeaponStorage.materials.length];
                for (int i = 0; i < nArray.length; ++i) {
                    String string2 = WM_WeaponStorage.materials[i] + "-" + ((WM_WeaponStorage)object2).weaponName + "-id";
                    try {
                        nArray[i] = Integer.parseInt(properties.getProperty(string2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ++n;
                    }
                }
                ((WM_WeaponStorage)object2).setItemIDs(nArray);
            } else {
                try {
                    ((WM_WeaponStorage)object2).setItemID(Integer.parseInt(properties.getProperty(((WM_WeaponStorage)object2).weaponName + "-id")));
                }
                catch (NumberFormatException numberFormatException) {
                    ++n;
                }
            }
            if (!((WM_WeaponStorage)object2).isEntity) continue;
            try {
                ((WM_WeaponStorage)object2).entityID = Integer.parseInt(properties.getProperty(((WM_WeaponStorage)object2).weaponName + "-entity"));
            }
            catch (NumberFormatException numberFormatException) {
                ++n;
            }
        }
        object2 = properties.getProperty("cannon-block-damage");
        if (object2 == null || ((String)object2).length() == 0) {
            ++n;
        } else {
            this.cannonDoesBlockDamage = Boolean.parseBoolean((String)object2);
        }
        object2 = properties.getProperty("dynamite-block-damage");
        if (object2 == null || ((String)object2).length() == 0) {
            ++n;
        } else {
            this.dynamiteDoesBlockDamage = Boolean.parseBoolean((String)object2);
        }
        object2 = properties.getProperty("can-throw-knife");
        if (object2 == null || ((String)object2).length() == 0) {
            ++n;
        } else {
            this.canThrowKnife = Boolean.parseBoolean((String)object2);
        }
        object2 = properties.getProperty("can-throw-spear");
        if (object2 == null || ((String)object2).length() == 0) {
            ++n;
        } else {
            this.canThrowSpear = Boolean.parseBoolean((String)object2);
        }
        if (n == 0) {
            MinecraftServer.log.info("[WeaponMod] Properties file read succesfully!");
        } else {
            MinecraftServer.log.warning("[WeaponMod] Properties file read with " + n + " warnings.");
        }
    }

    private void processProperties(Properties properties) {
        for (WM_WeaponStorage wM_WeaponStorage : WM_WeaponStorage.propsMap.values()) {
            if (wM_WeaponStorage.useMaterials) {
                int[] nArray = wM_WeaponStorage.getItemIDs();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        nArray[i] = ModLoader.getUniqueEntityId();
                        continue;
                    }
                    int n = i;
                    nArray[n] = nArray[n] - Block.byId.length;
                    if (nArray[i] >= 0) continue;
                    MinecraftServer.log.warning("[WeaponMod] Item ID is below 4096.");
                }
                wM_WeaponStorage.setItemIDs(nArray);
            } else {
                int n = wM_WeaponStorage.getItemID();
                if (n == 0) {
                    n = ModLoader.getUniqueEntityId();
                } else if ((n -= Block.byId.length) < 0) {
                    MinecraftServer.log.warning("[WeaponMod] Item ID is below 4096.");
                }
                wM_WeaponStorage.setItemID(n);
            }
            if (!wM_WeaponStorage.isEntity || wM_WeaponStorage.entityID != 0) continue;
            wM_WeaponStorage.entityID = ModLoader.getUniqueEntityId();
        }
    }

    private void setStandardSettings() {
        MinecraftServer.log.warning("[WeaponMod] Using standard settings.");
        for (WM_WeaponStorage wM_WeaponStorage : WM_WeaponStorage.propsMap.values()) {
            wM_WeaponStorage.isEnabled = true;
            if (wM_WeaponStorage.useMaterials) {
                wM_WeaponStorage.setItemIDs(new int[]{0, 0, 0, 0, 0});
            } else {
                wM_WeaponStorage.setItemID(0);
            }
            if (!wM_WeaponStorage.isEntity) continue;
            wM_WeaponStorage.entityID = 0;
        }
        this.cannonDoesBlockDamage = true;
        this.dynamiteDoesBlockDamage = true;
        this.canThrowKnife = true;
        this.canThrowSpear = true;
    }

    private void createFile(Properties properties) {
        MinecraftServer.log.info("[WeaponMod] Creating new properties file.\n");
        try {
            String string = mod_WeaponMod.getServerLocation().getCanonicalPath() + "/mods/weaponmod/";
            String string2 = mod_WeaponMod.getServerLocation().getCanonicalPath() + "/mods/weaponmod/weaponmod.properties";
            new File(string).mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            for (WM_WeaponStorage wM_WeaponStorage : WM_WeaponStorage.propsMap.values()) {
                if (wM_WeaponStorage.isIndependant) {
                    properties.setProperty(wM_WeaponStorage.weaponName, String.valueOf(wM_WeaponStorage.isEnabled));
                }
                if (wM_WeaponStorage.useMaterials) {
                    int[] nArray = wM_WeaponStorage.getItemIDs();
                    for (int i = 0; i < WM_WeaponStorage.materials.length; ++i) {
                        properties.setProperty(WM_WeaponStorage.materials[i] + "-" + wM_WeaponStorage.weaponName + "-id", String.valueOf(nArray[i]));
                    }
                } else {
                    properties.setProperty(wM_WeaponStorage.weaponName + "-id", String.valueOf(wM_WeaponStorage.getItemID()));
                }
                if (!wM_WeaponStorage.isEntity) continue;
                properties.setProperty(wM_WeaponStorage.weaponName + "-entity", String.valueOf(wM_WeaponStorage.entityID));
            }
            properties.setProperty("cannon-block-damage", String.valueOf(this.cannonDoesBlockDamage));
            properties.setProperty("dynamite-block-damage", String.valueOf(this.dynamiteDoesBlockDamage));
            properties.setProperty("can-throw-knife", String.valueOf(this.canThrowKnife));
            properties.setProperty("can-throw-spear", String.valueOf(this.canThrowSpear));
            properties.store(fileOutputStream, this.baseMod.getName() + " " + this.baseMod.getVersion() + " - Auto-generated properties file");
            fileOutputStream.close();
            MinecraftServer.log.info("[WeaponMod] New properties file created at " + string2 + "\n");
        }
        catch (IOException iOException) {
            MinecraftServer.log.warning("[WeaponMod] Unable to create new properties file. Move the properties file included in the download to the .minecraft/mods/weaponmod/ folder.\n");
            iOException.printStackTrace();
        }
    }
}

