/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.ItemStack;

public class WM_ReloadProgress {
    public boolean isReloading;
    public boolean reloaded;
    public int progress;
    protected ItemStack itemStack;
    private static Map itemStacks = new HashMap();

    protected WM_ReloadProgress(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.resetReload();
    }

    public void resetReload() {
        this.progress = 0;
        this.reloaded = false;
        this.isReloading = false;
    }

    public static WM_ReloadProgress getReloadProgress(ItemStack itemStack) {
        if (itemStack == null || itemStack.count <= 0) {
            return null;
        }
        return (WM_ReloadProgress)itemStacks.get(itemStack);
    }

    public static WM_ReloadProgress registerItemStack(ItemStack itemStack) {
        WM_ReloadProgress wM_ReloadProgress = WM_ReloadProgress.getReloadProgress(itemStack);
        if (wM_ReloadProgress != null) {
            WM_ReloadProgress.cleanList();
            return wM_ReloadProgress;
        }
        wM_ReloadProgress = new WM_ReloadProgress(itemStack);
        itemStacks.put(itemStack, wM_ReloadProgress);
        WM_ReloadProgress.cleanList();
        return wM_ReloadProgress;
    }

    public static void cleanList() {
        ItemStack[] itemStackArray;
        Object[] objectArray = itemStackArray = itemStacks.keySet().toArray(new ItemStack[0]);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = objectArray[i];
            if (itemStack != null && itemStack.count > 0) continue;
            itemStacks.remove(itemStack);
        }
        for (ItemStack itemStack : objectArray = itemStacks.values().toArray(new WM_ReloadProgress[0])) {
            if (itemStack.reloaded || itemStack.isReloading) continue;
            itemStack.resetReload();
        }
    }
}

