package immibis.tubestuff;

import immibis.core.BlockCombined;
import immibis.core.NonSharedProxy;
import immibis.core.TileCombined;
import java.util.ArrayList;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class BlockTubestuff extends BlockCombined
{
    public static int model;

    public BlockTubestuff(int var1)
    {
        super(var1, Material.ORE, "/immibis/tubestuff/blocks.png");
        this.c(2.0F);

        if (NonSharedProxy.CLIENT)
        {
            this.a(true);
        }
    }

    /**
     * Is this block powering the block on the specified side
     */
    public boolean a(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        TileCombined var6 = (TileCombined)var1.getTileEntity(var2, var3, var4);
        return var6 != null ? var6.redstone_output : false;
    }

    /**
     * Is this block indirectly powering the block on the specified side
     */
    public boolean d(World var1, int var2, int var3, int var4, int var5)
    {
        TileCombined var6 = (TileCombined)var1.getTileEntity(var2, var3, var4);
        return var6 != null ? var6.redstone_output : false;
    }

    /**
     * The type of render function that is called for this block
     */
    public int c()
    {
        return model;
    }

    public TileEntity getBlockEntity(int var1)
    {
        return (TileEntity)(var1 == 0 ? new TileBuffer() : (var1 == 1 ? new TileCraftingTable() : (var1 == 2 ? new TileInfiniteChest() : (var1 == 3 ? new TileIncinerator() : (var1 == 4 ? new TileDuplicator() : (var1 == 5 ? new TileRetrievulator() : null))))));
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        boolean var3 = false;
        return var2 == 0 ? 3 : (var2 == 1 ? (var1 == 0 ? 1 : (var1 == 1 ? 0 : 2)) : (var2 == 2 ? 4 : (var2 == 3 ? (var1 == 1 ? 7 : (var1 == 0 ? 1 : 6)) : (var2 == 4 ? 8 : (var2 == 5 ? (var1 == 1 ? 9 : 10) : 0)))));
    }

    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        int var6 = var1.getData(var2, var3, var4);

        if (var6 == 5)
        {
            TileRetrievulator var7 = (TileRetrievulator)var1.getTileEntity(var2, var3, var4);
            return var5 == var7.outputFace ? 11 : (var5 == (var7.outputFace ^ 1) ? 9 : 10);
        }
        else
        {
            return this.a(var5, var6);
        }
    }

    public void addCreativeItems(ArrayList var1)
    {
        var1.add(new ItemStack(this, 1, 0));
        var1.add(new ItemStack(this, 1, 1));
        var1.add(new ItemStack(this, 1, 2));
        var1.add(new ItemStack(this, 1, 3));
        var1.add(new ItemStack(this, 1, 4));
        var1.add(new ItemStack(this, 1, 5));
    }
}
