package mffs;

import ic2.common.TileEntityNuclearReactor;
import ic2.common.TileEntityReactorChamber;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;

public class TileEntityReaktorField extends TileEntityProjektor
{
    private boolean watercool = false;
    private boolean isreaktor = false;
    private int reactorx = 0;
    private int reactory = 0;
    private int reactorz = 0;
    private int reactordist = 0;
    private int reactorsize = 0;
    private int reactorheat = 0;
    private int maxheat;

    public int[] getUpdate()
    {
        return new int[] {this.watercool ? 1 : 0, this.isreaktor ? 1 : 0, this.reactorx, this.reactory, this.reactorz, this.reactordist, this.reactorsize, this.reactorheat, this.maxheat};
    }

    public void handleUpdate(int[] var1)
    {
        this.watercool = var1[0] != 0;
        this.isreaktor = var1[1] != 0;
        this.reactorx = var1[2];
        this.reactory = var1[3];
        this.reactorz = var1[4];
        this.reactordist = var1[5];
        this.reactorsize = var1[6];
        this.reactorheat = var1[7];
        this.maxheat = var1[8];
    }

    public void handleButton(int var1)
    {
        if (!this.getActive() && var1 == 0)
        {
            this.setWatercool(!this.isWatercool());
        }
    }

    public TileEntityReaktorField()
    {
        this.setDropper(false);
        this.setHardner(false);
        this.specialffmeta = 3;
    }

    public int getReactorx()
    {
        return this.reactorx;
    }

    public int getReactory()
    {
        return this.reactory;
    }

    public int getReactorz()
    {
        return this.reactorz;
    }

    public int getReactordist()
    {
        return this.reactordist;
    }

    public int getReactorsize()
    {
        return this.reactorsize;
    }

    public int getReactorheat()
    {
        return this.reactorheat;
    }

    public boolean isWatercool()
    {
        return this.watercool;
    }

    public void setWatercoolinit(boolean var1)
    {
        this.watercool = var1;
        ++this.updateCount;
    }

    public void setWatercool(boolean var1)
    {
        this.watercool = var1;
        ++this.updateCount;
    }

    public int getReaktorheat()
    {
        return this.reactorheat;
    }

    public void setReaktorheat(int var1)
    {
        this.reactorheat = var1;
        ++this.updateCount;
    }

    public boolean isIsreaktor()
    {
        return this.isreaktor;
    }

    public void setIsreaktor(boolean var1)
    {
        this.isreaktor = var1;
        ++this.updateCount;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.watercool = var1.getBoolean("watercool");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setBoolean("watercool", this.watercool);
    }

    private boolean scanforNuclearReaktor()
    {
        for (int var1 = this.x - 2; var1 <= this.x + 2; ++var1)
        {
            for (int var2 = this.y - 2; var2 <= this.y + 2; ++var2)
            {
                for (int var3 = this.z - 2; var3 <= this.z + 2; ++var3)
                {
                    TileEntity var4 = this.world.getTileEntity(var1, var2, var3);

                    if (var4 instanceof TileEntityNuclearReactor)
                    {
                        this.reactorx = var1;
                        this.reactory = var2;
                        this.reactorz = var3;

                        if (Math.abs(this.x - this.reactorx) <= 1 && Math.abs(this.y - this.reactory) <= 1 && Math.abs(this.z - this.reactorz) <= 1)
                        {
                            this.reactordist = 1;
                        }
                        else
                        {
                            this.reactordist = 2;
                        }

                        return true;
                    }
                }
            }
        }

        return false;
    }

    private int scanforReaktorCamber()
    {
        int var1 = 0;

        if (this.world.getTileEntity(this.reactorx + 1, this.reactory, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx - 1, this.reactory, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory + 1, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory - 1, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz + 1) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz - 1) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        return var1;
    }

    public boolean overrideActivationStatus(boolean var1)
    {
        if (!this.isIsreaktor())
        {
            return false;
        }
        else
        {
            switch (this.reactorsize)
            {
                case 0:
                    this.maxheat = 7500;
                    break;

                case 1:
                    this.maxheat = 8350;
                    break;

                case 2:
                    this.maxheat = 9200;
                    break;

                case 3:
                    this.maxheat = 10050;
                    break;

                case 4:
                    this.maxheat = 10900;
                    break;

                case 5:
                    this.maxheat = 11750;
                    break;

                case 6:
                    this.maxheat = 12600;
            }

            if (this.maxheat < this.reactorheat)
            {
                this.setHardner(true);
                var1 = true;
            }

            if (!this.getActive() && this.reactorsize >= 1 && this.reactordist < 2)
            {
                var1 = false;
            }

            return var1;
        }
    }

    public void onEveryTick()
    {
        if (!this.isIsreaktor())
        {
            this.setIsreaktor(this.scanforNuclearReaktor());
        }
    }

    public void onFieldTick()
    {
        if (this.isreaktor)
        {
            this.reactorsize = this.scanforReaktorCamber();
            TileEntity var1 = this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz);

            if (var1 instanceof TileEntityNuclearReactor)
            {
                this.setReaktorheat(((TileEntityNuclearReactor)var1).heat);

                if (this.getActive())
                {
                    this.refreshwater();
                }
            }
            else
            {
                this.setIsreaktor(false);
            }
        }
    }

    public void refreshwater()
    {
        for (int var1 = 0 - this.reactordist; var1 <= this.reactordist; ++var1)
        {
            for (int var2 = 0 - this.reactordist; var2 <= this.reactordist; ++var2)
            {
                for (int var3 = 0 - this.reactordist; var3 <= this.reactordist; ++var3)
                {
                    if (this.watercool && this.world.getTypeId(this.reactorx + var2, this.reactory + var1, this.reactorz + var3) == 0)
                    {
                        this.world.setTypeId(this.reactorx + var2, this.reactory + var1, this.reactorz + var3, 8);
                        TileEntity var4 = (TileEntity)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()));

                        if (var4 instanceof TileEntityGeneratorCore)
                        {
                            ((TileEntityGeneratorCore)var4).Energylost(1000);
                        }
                    }
                }
            }
        }
    }

    public void onActivateProjector()
    {
        if (this.watercool)
        {
            this.refreshwater();
        }
    }

    public void onDeactivateProjector()
    {
        if (this.watercool)
        {
            for (int var1 = 0 - this.reactordist; var1 <= this.reactordist; ++var1)
            {
                for (int var2 = 0 - this.reactordist; var2 <= this.reactordist; ++var2)
                {
                    for (int var3 = 0 - this.reactordist; var3 <= this.reactordist; ++var3)
                    {
                        if (this.world.getMaterial(this.reactorx + var2, this.reactory + var1, this.reactorz + var3).isLiquid())
                        {
                            this.world.setTypeId(this.reactorx + var2, this.reactory + var1, this.reactorz + var3, 0);
                        }
                    }
                }
            }
        }
    }

    protected void getFieldShape(CoordinateList var1)
    {
        for (int var2 = 0 - this.reactordist; var2 <= this.reactordist; ++var2)
        {
            for (int var3 = 0 - this.reactordist; var3 <= this.reactordist; ++var3)
            {
                for (int var4 = 0 - this.reactordist; var4 <= this.reactordist; ++var4)
                {
                    if (var3 == 0 - this.reactordist || var3 == this.reactordist || var2 == 0 - this.reactordist || var2 == this.reactordist || var4 == 0 - this.reactordist || var4 == this.reactordist)
                    {
                        var1.add(this.reactorx + var3, this.reactory + var2, this.reactorz + var4);
                    }
                }
            }
        }
    }

    public void checkupgrades()
    {
        for (int var1 = -2; var1 <= 2; ++var1)
        {
            for (int var2 = -2; var2 <= 2; ++var2)
            {
                for (int var3 = -2; var3 <= 2; ++var3)
                {
                    if ((var1 == 0 && var2 == 0 && (var3 == -2 || var3 == -1 || var3 == 1 || var3 == 2) || var1 == 0 && var3 == 0 && (var2 == -2 || var2 == -1 || var2 == 1 || var2 == 2) || var3 == 0 && var2 == 0 && (var1 == -2 || var1 == -1 || var1 == 1 || var1 == 2)) && this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);
                        TileEntity var5 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var5 instanceof TileEntityPassivUpgrade)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && var4 == 8)
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2 && ((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                            {
                                ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                            }
                        }
                    }

                    TileEntity var6;

                    if (this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSMaschines.id && this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == 8)
                    {
                        var6 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var6 instanceof TileEntityPassivUpgrade)
                        {
                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == 0)
                            {
                                ((TileEntityPassivUpgrade)var6).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var6).setConnectet_typID((short)2);
                                this.world.k(var6.x, var6.y, var6.z);
                            }

                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var6).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var6).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var6).setActive(this.getActive());
                                    this.world.k(var6.x, var6.y, var6.z);
                                }

                                if (((TileEntityReaktorCooler)var6).isIsreaktor() != this.isIsreaktor())
                                {
                                    ((TileEntityReaktorCooler)var6).setIsreaktor(this.isIsreaktor());
                                }

                                if (((TileEntityReaktorCooler)var6).getMaxheat() != this.maxheat)
                                {
                                    ((TileEntityReaktorCooler)var6).setMaxheat(this.maxheat);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktorx() != this.reactorx)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktorx(this.reactorx);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktory() != this.reactory)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktory(this.reactory);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktorz() != this.reactorz)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktorz(this.reactorz);
                                }
                            }
                        }
                    }

                    if (this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSMaschines.id && this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == 9)
                    {
                        var6 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var6 instanceof TileEntityPassivUpgrade)
                        {
                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == 0)
                            {
                                ((TileEntityPassivUpgrade)var6).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var6).setConnectet_typID((short)2);
                                this.world.k(var6.x, var6.y, var6.z);
                            }

                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var6).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var6).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var6).setActive(this.getActive());
                                    this.world.k(var6.x, var6.y, var6.z);
                                }

                                if (((TileEntityReaktorMonitor)var6).isIsreaktor() != this.isIsreaktor())
                                {
                                    ((TileEntityReaktorMonitor)var6).setIsreaktor(this.isIsreaktor());
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktorx() != this.reactorx)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktorx(this.reactorx);
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktory() != this.reactory)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktory(this.reactory);
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktorz() != this.reactorz)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktorz(this.reactorz);
                                }

                                if (((TileEntityReaktorMonitor)var6).getMaxheat() != this.maxheat)
                                {
                                    ((TileEntityReaktorMonitor)var6).setMaxheat(this.maxheat);
                                }
                            }
                        }
                    }
                }
            }
        }

        this.setffmeta((short)3);
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int estimateBlockCount()
    {
        return this.reactordist * this.reactordist * 24;
    }
}
