package immibis.chunkloader;

import immibis.core.BlockCombined;
import java.util.ArrayList;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class BlockChunkLoader extends BlockCombined
{
    protected BlockChunkLoader(int var1)
    {
        super(var1, Material.ORE, "/immibis/chunkloader/world.png");
    }

    public boolean removeBlockByPlayer(World var1, EntityHuman var2, int var3, int var4, int var5)
    {
        TileChunkLoader var6 = (TileChunkLoader)var1.getTileEntity(var3, var4, var5);

        if (!super.removeBlockByPlayer(var1, var2, var3, var4, var5))
        {
            return false;
        }
        else if (var1.isStatic)
        {
            return true;
        }
        else
        {
            Logging.onRemoved(var6.getLoaderInfo(), var2.name);
            return true;
        }
    }

    /**
     * Called when the block is placed in the world.
     */
    public void postPlace(World var1, int var2, int var3, int var4, EntityLiving var5)
    {
        super.postPlace(var1, var2, var3, var4, var5);

        if (!var1.isStatic)
        {
            TileChunkLoader var6 = (TileChunkLoader)var1.getTileEntity(var2, var3, var4);

            if (var5 instanceof EntityHuman)
            {
                var6.owner = ((EntityHuman)var5).name;
                var6.radius = 0;
            }
            else
            {
                var6.owner = null;
                var6.radius = -1;
            }

            var6.limitRadius();
            var6.loaderChanged(var5 instanceof EntityHuman ? ((EntityHuman)var5).name : var5.toString(), true);
        }
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return 0;
    }

    public TileEntity getBlockEntity(int var1)
    {
        return var1 == 0 ? new TileChunkLoader() : null;
    }

    public void addCreativeItems(ArrayList var1)
    {
        var1.add(new ItemStack(this, 1, 0));
    }
}
