package immibis.chunkloader;

import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

import immibis.core.NonSharedProxy;
import immibis.core.NullInventory;
import immibis.core.net.AbstractSyncedContainer;
import immibis.core.net.IPacket;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;

public class ContainerChunkLoader extends AbstractSyncedContainer
{
    public EntityHuman player;
    public TileChunkLoader tile;
    private String lastOwner = null;
    private int lastMaxQuota = -1;
    private int lastCurQuota = -1;
    private int lastRadius = -2;
    private boolean lastAmIOp;
    private boolean lastServerOwned;
    public boolean ownedByMe;
    public boolean amIOp;
    private int maxQuota;
    private int curQuota;

    public ContainerChunkLoader(EntityHuman var1, final TileChunkLoader var2)
    {
        super(var1, new NullInventory()
        {
            public boolean a(EntityHuman var1)
            {
                return !var2.l() && var1.e((double)var2.x + 0.5D, (double)var2.y + 0.5D, (double)var2.z + 0.5D) <= 64.0D;
            }
        });
        this.player = var1;
        this.tile = var2;
    }

    public boolean canEdit()
    {
        return this.tile.owner != null && (this.ownedByMe && !this.tile.isServerOwned || this.amIOp);
    }

    public void onButtonPressed(int var1)
    {
        if (this.canEdit())
        {
            if (var1 == 3)
            {
                if (this.tile.radius > 0)
                {
                    --this.tile.radius;
                    this.tile.loaderChanged(this.player.name);
                }
            }
            else if (var1 == 4)
            {
                if (this.tile.radius < 4 && Main.instance.canAddQuota(this.tile.owner, (this.tile.radius + 1) * 8))
                {
                    ++this.tile.radius;
                    this.tile.loaderChanged(this.player.name);
                }
            }
            else if (var1 == 5 && this.amIOp)
            {
                this.tile.isServerOwned = !this.tile.isServerOwned;

                if (!this.tile.isServerOwned)
                {
                    this.tile.owner = this.player.name;
                }

                this.tile.loaderChanged(this.player.name);
            }
        }
    }

    public int getMaxQuota()
    {
        return this.tile.world.isStatic ? this.maxQuota : (this.tile.owner == null ? 0 : Main.instance.getMaxQuota(this.tile.owner));
    }

    public int getCurQuota()
    {
        return this.tile.world.isStatic ? this.curQuota : (this.tile.owner == null ? 0 : Main.instance.getCurQuota(this.tile.owner));
    }

    public void updateFields()
    {
        this.maxQuota = this.getMaxQuota();
        this.curQuota = this.getCurQuota();
        this.ownedByMe = this.tile.owner != null && this.tile.owner.equals(this.player.name);
        this.amIOp = NonSharedProxy.isOp(this.player.name) || Bukkit.getPlayer(player.name).hasPermission("chunkloader.op");
    }

    /**
     * Updates crafting matrix; called from onCraftMatrixChanged. Args: none
     */
    public void a()
    {
        this.updateFields();

        if (this.lastOwner != this.tile.owner || this.lastMaxQuota != this.maxQuota || this.lastCurQuota != this.curQuota || this.lastRadius != this.tile.radius || this.lastAmIOp != this.amIOp || this.lastServerOwned != this.tile.isServerOwned)
        {
            PacketGUIUpdate var1 = new PacketGUIUpdate(this.tile.owner == null ? "" : this.tile.owner, this.curQuota, this.maxQuota, this.tile.radius, this.amIOp, this.tile.isServerOwned);
            this.sendUpdatePacket(var1);
            this.lastOwner = this.tile.owner;
            this.lastCurQuota = this.curQuota;
            this.lastMaxQuota = this.maxQuota;
            this.lastRadius = this.tile.radius;
            this.lastAmIOp = this.amIOp;
            this.lastServerOwned = this.tile.isServerOwned;
        }
    }

    public void onUpdatePacket(IPacket var1)
    {
        if (var1 instanceof PacketGUIUpdate)
        {
            PacketGUIUpdate var2 = (PacketGUIUpdate)var1;
            this.tile.owner = var2.owner.equals("") ? null : var2.owner;
            this.tile.radius = var2.radius;
            this.curQuota = var2.curQuota;
            this.maxQuota = var2.maxQuota;
            this.amIOp = var2.amIOp;
            this.tile.isServerOwned = var2.isServerOwned;
            this.ownedByMe = this.tile.owner != null && this.tile.owner.equals(this.player.name);
        }
    }

    public String getChannel()
    {
        return "immibis.chunkldr";
    }
}
