package immibis.core;

import java.util.LinkedList;
import java.util.List;

import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;

public class BasicInventory implements IInventory
{
    public ItemStack[] contents;

    public BasicInventory(int var1)
    {
        this.contents = new ItemStack[var1];
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.contents[var1] != null && this.contents[var1].count != 0)
        {
            if (this.contents[var1].count <= var2)
            {
                ItemStack var3 = this.contents[var1];
                this.contents[var1] = null;
                return var3;
            }
            else
            {
                return this.contents[var1].a(var2);
            }
        }
        else
        {
            return null;
        }
    }

    public boolean mergeStackIntoRange(int var1, int var2, int var3)
    {
        return mergeStackIntoRange(this, this, var1, var2, var3);
    }

    public ItemStack mergeStackIntoRange(ItemStack var1, int var2, int var3)
    {
        return mergeStackIntoRange(var1, this, var2, var3);
    }

    public static ItemStack mergeStackIntoRange(ItemStack var0, IInventory var1, int var2, int var3)
    {
        if (var0 != null && var0.count != 0)
        {
            int var4;

            for (var4 = var2; var4 < var3; ++var4)
            {
                ItemStack var5 = var1.getItem(var4);

                if (var5 != null && var5.id == var0.id && var5.getData() == var0.getData())
                {
                    int var6 = var5.getMaxStackSize();

                    if (var5.count + var0.count <= var6)
                    {
                        var5.count += var0.count;
                        var1.setItem(var4, var5);
                        return null;
                    }

                    int var7 = var6 - var5.count;

                    if (var7 > 0)
                    {
                        var5.count += var7;
                        var0.count -= var7;
                        var1.setItem(var4, var5);
                    }
                }
            }

            if (var0.count == 0)
            {
                return null;
            }
            else
            {
                for (var4 = var2; var4 < var3; ++var4)
                {
                    if (var1.getItem(var4) == null)
                    {
                        var1.setItem(var4, var0);
                        return null;
                    }
                }

                return var0;
            }
        }
        else
        {
            return null;
        }
    }

    public static boolean mergeStackIntoRange(IInventory var0, IInventory var1, int var2, int var3, int var4)
    {
        ItemStack var5 = var0.getItem(var2);

        if (var5 != null && var5.count != 0)
        {
            boolean var6 = false;
            int var7;
            ItemStack var8;

            for (var7 = var3; var7 < var4; ++var7)
            {
                var8 = var1.getItem(var7);

                if (var8 != null && var8.id == var5.id && var8.getData() == var5.getData())
                {
                    int var9 = var8.getMaxStackSize();

                    if (var8.count + var5.count <= var9)
                    {
                        var8.count += var5.count;
                        var0.setItem(var2, (ItemStack)null);
                        var1.setItem(var7, var8);
                        return true;
                    }

                    int var10 = var9 - var8.count;

                    if (var10 > 0)
                    {
                        var8.count += var10;
                        var1.setItem(var7, var8);
                        var5.count -= var10;
                        var6 = true;
                    }
                }
            }

            if (var5.count == 0)
            {
                var0.setItem(var2, (ItemStack)null);
                return var6;
            }
            else
            {
                for (var7 = var3; var7 < var4; ++var7)
                {
                    var8 = var1.getItem(var7);

                    if (var8 == null)
                    {
                        var1.setItem(var7, var5);
                        var0.setItem(var2, (ItemStack)null);
                        return true;
                    }
                }

                var0.setItem(var2, var5);
                return var6;
            }
        }
        else
        {
            return false;
        }
    }

    public void readFromNBT(NBTTagList var1)
    {
        int var2;

        for (var2 = 0; var2 < this.contents.length; ++var2)
        {
            this.contents[var2] = null;
        }

        for (var2 = 0; var2 < var1.size(); ++var2)
        {
            NBTTagCompound var3 = (NBTTagCompound)var1.get(var2);
            int var4 = var3.getByte("Slot") & 255;

            if (var4 >= 0 && var4 < this.contents.length)
            {
                this.contents[var4] = ItemStack.a(var3);
            }
        }
    }

    public NBTTagList writeToNBT()
    {
        NBTTagList var1 = new NBTTagList("Items");

        for (int var2 = 0; var2 < this.contents.length; ++var2)
        {
            if (this.contents[var2] != null)
            {
                NBTTagCompound var3 = new NBTTagCompound();
                this.contents[var2].save(var3);
                var3.setByte("Slot", (byte)var2);
                var1.add(var3);
            }
        }

        return var1;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.contents.length;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.contents[var1];
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.contents[var1] = var2;
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "BasicInventory";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Called when an the contents of an Inventory change, usually
     */
    public void update() {}

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return false;
    }

    public void f() {}

    public void g() {}

	@Override
	public ItemStack[] getContents() {
		return contents;
	}

	@Override
	public InventoryHolder getOwner() {
		return new InventoryHolder() {
			@Override public Inventory getInventory() {
				return new CraftInventory(BasicInventory.this);
			}
		};
	}
	
	private List<HumanEntity> viewers = new LinkedList<HumanEntity>();

	@Override
	public List<HumanEntity> getViewers() {
		return viewers;
	}

	@Override
	public void onClose(CraftHumanEntity arg0) {
		viewers.remove(arg0);
	}

	@Override
	public void onOpen(CraftHumanEntity arg0) {
		viewers.add(arg0);
	}

	@Override
	public void setMaxStackSize(int arg0) {
	}
}
