package immibis.core;

import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.BlockPlaceEvent;

import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemBlock;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public abstract class ItemBlockMultiTile extends ItemBlock
{
    public int max_meta = 0;

    public ItemBlockMultiTile(int var1, int var2)
    {
        super(var1);
        this.max_meta = var2;

        for (int var3 = 0; var3 < var2; ++var3)
        {
            NonSharedProxy.AddLocalization(this.a() + "." + var3 + ".name", this.getName(var3));
        }
    }

    public String a(ItemStack var1)
    {
        return this.a() + "." + var1.getData();
    }

    public abstract TileEntity createTileEntity(int var1);

    public abstract String getName(int var1);
    
    /**
     * Callback for item usage. If the item does something special on right clicking, he will have one of those. Return
     * True if something happen and false if it don't. This is for ITEMS, not BLOCKS !
     */
    public boolean interactWith(ItemStack itemstack, EntityHuman entityhuman, World world, int i, int j, int k, int l) {
        int clickedX = i, clickedY = j, clickedZ = k; // CraftBukkit
        int i1 = world.getTypeId(i, j, k);

        if (i1 == Block.SNOW.id) {
            l = 1;
        } else if (i1 != Block.VINE.id && i1 != Block.LONG_GRASS.id && i1 != Block.DEAD_BUSH.id) {
            if (l == 0) {
                --j;
            }

            if (l == 1) {
                ++j;
            }

            if (l == 2) {
                --k;
            }

            if (l == 3) {
                ++k;
            }

            if (l == 4) {
                --i;
            }

            if (l == 5) {
                ++i;
            }
        }

        if (itemstack.count == 0) {
            return false;
        } else if (!entityhuman.d(i, j, k)) {
            return false;
        } else if (j == 255 && Block.byId[a()].material.isBuildable()) {
            return false;
        }
        // CraftBukkit start
        int id = a();
        if (world.mayPlace(a(), i, j, k, false, l)) {
            Block block = Block.byId[id];

            CraftBlockState replacedBlockState = CraftBlockState.getBlockState(world, i, j, k);

            world.suppressPhysics = true;
            world.setTypeIdAndData(i, j, k, id, this.filterData(itemstack.getData()));
            BlockPlaceEvent event = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, replacedBlockState, clickedX, clickedY, clickedZ);
            id = world.getTypeId(i, j, k);
            int data = world.getData(i, j, k);
            replacedBlockState.update(true);
            world.suppressPhysics = false;

            if (event.isCancelled() || !event.canBuild()) {
                return true;
            }

            if (world.setTypeIdAndData(i, j, k, id, data)) {
                if (world.getTypeId(i, j, k) == id && Block.byId[id] != null) {
                	
                	world.setTileEntity(i, j, k, this.createTileEntity(itemstack.getData()));
                	
                    Block.byId[id].postPlace(world, i, j, k, l);
                    Block.byId[id].postPlace(world, i, j, k, entityhuman);
                    // CraftBukkit end
                }

                world.makeSound((double) ((float) i + 0.5F), (double) ((float) j + 0.5F), (double) ((float) k + 0.5F), block.stepSound.getName(), (block.stepSound.getVolume1() + 1.0F) / 2.0F, block.stepSound.getVolume2() * 0.8F);
                --itemstack.count;
            }

            return true;
        } else {
            return false;
        }
    }
}
