package immibis.core;

import immibis.core.net.IPacket;
import immibis.core.net.OneTwoFiveNetworking;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Packet;
import net.minecraft.server.TileEntity;

public abstract class TileCombined extends TileEntity
{
    public boolean redstone_output = false;

    public void onBlockNeighbourChange() {}

    public boolean onBlockActivated(EntityHuman var1)
    {
        return false;
    }

    public void onBlockRemoval() {}

    public void notifyNeighbouringBlocks()
    {
        this.world.applyPhysics(this.x, this.y, this.z, this.world.getTypeId(this.x, this.y, this.z));
    }

    public void resendDescriptionPacket()
    {
        this.world.notify(this.x, this.y, this.z);
    }

    /**
     * Overriden in a sign to provide the text
     */
    public final Packet d()
    {
        IPacket var1 = this.getDescriptionPacket2();
        return var1 == null ? null : OneTwoFiveNetworking.wrap(var1, this.getDescriptionChannel());
    }

    public String getDescriptionChannel()
    {
        return null;
    }

    public IPacket getDescriptionPacket2()
    {
        return null;
    }

    public void onPlaced(EntityLiving var1, int var2) {}
}
