package immibis.core.net;

import java.io.*;
import java.util.logging.Level;
import java.util.*;

import net.minecraft.server.*;
import forge.*;

public class OneTwoFiveNetworking {

	public static Packet250CustomPayload wrap(IPacket packet, String channel) {
		Packet250CustomPayload p = new Packet250CustomPayload();
		p.tag = channel;
		ByteArrayOutputStream bytes = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(bytes);
		try {
			out.writeByte(packet.getID());
			packet.write(out);
			
			p.data = bytes.toByteArray();
			p.length = p.data.length;
			
			return p;
			
		} catch(IOException e) {
			ModLoader.getLogger().log(Level.SEVERE, "While trying to send packet of type "+packet.getClass().getName(), e);
			return null;
		} finally {
			try {
				out.close();
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	// Sends a packet to a player on a channel.
	// In SSP, calls packet.onReceived directly.
	// On the client, player must be null.
	public static void send(String channel, IPacket packet, EntityHuman player) {
		sendRealPacket(wrap(packet, channel), player);
	}
	
	private static void sendRealPacket(Packet250CustomPayload packet, EntityHuman player) {
		if(packet == null)
			return;
		
		if(player instanceof EntityPlayer)
			((EntityPlayer)player).netServerHandler.networkManager.queue(packet);
	}
	
	private static Map<String, IPacketMap> channels = new HashMap<String, IPacketMap>();
	public static void initReceive(final IPacketMap mod, final String channel) {
		channels.put(channel, mod);
		MinecraftForge.registerConnectionHandler(new IConnectionHandler() {
			@Override
			public void onLogin(NetworkManager network, Packet1Login login) {
				MessageManager.getInstance().registerChannel(network, new IPacketHandler() {
					@Override
					public void onPacketData(NetworkManager network, String channel_, byte[] data) {
						if(!channel_.equals(channel))
							return;
						
						DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
						
						try {
							byte id = in.readByte();
							IPacket packet = mod.createPacket(id);
							if(packet == null)
								return;
							packet.read(in);
							if(!(network.getNetHandler() instanceof NetServerHandler))
								return;
							EntityPlayer source = ((NetServerHandler)network.getNetHandler()).getPlayerEntity();
							if(source == null)
								return;
							packet.onReceived(source);
						} catch(IOException e) {
							ModLoader.getLogger().log(Level.SEVERE, "While trying to receive packet on channel " + channel_, e);
						} finally {
							try {
								in.close();
							} catch(Exception e) {e.printStackTrace();}
						}
					}
				}, channel);
			}
			
			@Override
			public void onDisconnect(NetworkManager network, String message, Object[] args) {
			}
			
			@Override
			public void onConnect(NetworkManager network) {
			}
		});
	}
	
	
}
