/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.geometry;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import org.lwjgl.BufferUtils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class GradientAndArcCalculator$ {
    public static final GradientAndArcCalculator$ MODULE$;

    static {
        new GradientAndArcCalculator$();
    }

    public DoubleBuffer getArcPoints(double startangle, double endangle, double radius, double xoffset, double yoffset, double zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((endangle - startangle) * (double)2 * Math.PI));
        double theta = (endangle - startangle) / (double)numVertices;
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numVertices * 3));
        DoubleRef x = DoubleRef.create((double)(radius * Math.sin(startangle)));
        DoubleRef y = DoubleRef.create((double)(radius * Math.cos(startangle)));
        double tf = Math.tan(theta);
        double rf = Math.cos(theta);
        DoubleRef tx = DoubleRef.create((double)0.0);
        DoubleRef ty = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numVertices).foreach$mVc$sp((Function1)new Serializable(xoffset, yoffset, zoffset, buffer, x, y, tf, rf, tx, ty){
            private final double xoffset$1;
            private final double yoffset$1;
            private final double zoffset$1;
            private final DoubleBuffer buffer$1;
            private final DoubleRef x$1;
            private final DoubleRef y$1;
            private final double tf$1;
            private final double rf$1;
            private final DoubleRef tx$1;
            private final DoubleRef ty$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.buffer$1.put(this.x$1.elem + this.xoffset$1);
                this.buffer$1.put(this.y$1.elem + this.yoffset$1);
                this.buffer$1.put(this.zoffset$1);
                this.tx$1.elem = this.y$1.elem;
                this.ty$1.elem = -this.x$1.elem;
                this.x$1.elem += this.tx$1.elem * this.tf$1;
                this.y$1.elem += this.ty$1.elem * this.tf$1;
                this.x$1.elem *= this.rf$1;
                this.y$1.elem *= this.rf$1;
            }
            {
                this.xoffset$1 = xoffset$1;
                this.yoffset$1 = yoffset$1;
                this.zoffset$1 = zoffset$1;
                this.buffer$1 = buffer$1;
                this.x$1 = x$1;
                this.y$1 = y$1;
                this.tf$1 = tf$1;
                this.rf$1 = rf$1;
                this.tx$1 = tx$1;
                this.ty$1 = ty$1;
            }
        });
        buffer.flip();
        return buffer;
    }

    public List<MusePoint2D> pointsInLine(int num, MusePoint2D a, MusePoint2D b) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        int n = num;
        switch (n) {
            default: {
                MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).foreach((Function1)new Serializable(a, points, step){
                    private final MusePoint2D a$1;
                    private final ArrayList points$1;
                    private final MusePoint2D step$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.points$1.add(this.a$1.plus(this.step$1.times(i + 1)));
                    }
                    {
                        this.a$1 = a$1;
                        this.points$1 = points$1;
                        this.step$1 = step$1;
                    }
                });
                Object object = BoxedUnit.UNIT;
                break;
            }
            case 1: {
                Object object = BoxesRunTime.boxToBoolean((boolean)points.add(b.minus(a).times(0.5).plus(a)));
                break;
            }
            case 0: {
                Object object = BoxedUnit.UNIT;
                break;
            }
            case -1: {
                Object object = BoxedUnit.UNIT;
            }
        }
        return points;
    }

    public DoubleBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numsegments * 4));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numsegments).foreach((Function1)new Serializable(c1, c2, numsegments, buffer){
            private final Colour c1$1;
            private final Colour c2$1;
            private final int numsegments$1;
            private final DoubleBuffer buffer$2;

            public final DoubleBuffer apply(int i) {
                Colour c3 = this.c1$1.interpolate(this.c2$1, i / this.numsegments$1);
                this.buffer$2.put(c3.r);
                this.buffer$2.put(c3.g);
                this.buffer$2.put(c3.b);
                return this.buffer$2.put(c3.a);
            }
            {
                this.c1$1 = c1$1;
                this.c2$1 = c2$1;
                this.numsegments$1 = numsegments$1;
                this.buffer$2 = buffer$2;
            }
        });
        buffer.flip();
        return buffer;
    }

    private GradientAndArcCalculator$() {
        MODULE$ = this;
    }
}

