/*
 * Decompiled with CFR 0.152.
 */
package emasher.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketTileAccess;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class SocketModule {
    public int moduleID;
    public String[] textureFiles;

    public SocketModule(int id, String ... textureFiles) {
        this.moduleID = id;
        this.textureFiles = textureFiles;
    }

    public void addRecipe() {
    }

    public abstract String getLocalizedName();

    public void getToolTip(List<Object> l) {
    }

    public void getIndicatorKey(List<Object> l) {
    }

    public boolean hasTankIndicator() {
        return false;
    }

    public boolean hasInventoryIndicator() {
        return false;
    }

    public boolean hasRSIndicator() {
        return false;
    }

    public boolean hasLatchIndicator() {
        return false;
    }

    public final boolean hasIndicator(int index) {
        switch (index) {
            case 0: {
                return this.hasTankIndicator();
            }
            case 1: {
                return this.hasInventoryIndicator();
            }
            case 2: {
                return this.hasRSIndicator();
            }
            case 3: {
                return this.hasLatchIndicator();
            }
        }
        return false;
    }

    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
    }

    public int getCurrentTexture(SideConfig config) {
        return 0;
    }

    public int getCurrentTexture(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        return this.getCurrentTexture(config);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon[] getAdditionalOverlays(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return new IIcon[0];
    }

    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return "eng_toolbox:inner_black";
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_black"};
    }

    @SideOnly(value=Side.CLIENT)
    public boolean flipBottomOverlay() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTextToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void doCustomRendering(SocketTileAccess ts, SideConfig config, ForgeDirection side, Tessellator tess, RenderBlocks bRenderer) {
    }

    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        return true;
    }

    public boolean isMachine() {
        return false;
    }

    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void onRemoved(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void onAdjChange(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void onAdjChangeSide(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void onSideActivated(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player) {
    }

    public void onSideActivated(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player, float subX, float subY, float subZ) {
        this.onSideActivated(ts, config, side, player);
    }

    public void onSideActivatedClient(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player) {
    }

    public void onSideActivatedClient(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player, float subX, float subY, float subZ) {
        this.onSideActivatedClient(ts, config, side, player);
    }

    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
    }

    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side, float subX, float subY, float subZ) {
        this.onGenericRemoteSignal(ts, config, side);
    }

    public void changeColour(int colour, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
    }

    public void onEntityWalkOn(SocketTileAccess ts, SideConfig config, ForgeDirection side, Entity entitiy) {
    }

    public boolean isFluidInterface() {
        return false;
    }

    public boolean canInsertFluid() {
        return false;
    }

    public boolean canExtractFluid() {
        return false;
    }

    public int fluidFill(FluidStack fluid, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        return 0;
    }

    public FluidStack fluidExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        return null;
    }

    public void onTankChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
    }

    public boolean isGasInterface() {
        return false;
    }

    public int gasFill(FluidStack gas, SocketTileAccess ts) {
        return 0;
    }

    public boolean isItemInterface() {
        return false;
    }

    public boolean canInsertItems() {
        return false;
    }

    public boolean canExtractItems() {
        return true;
    }

    public boolean canDirectlyInsertItems(SideConfig config, SocketTileAccess ts) {
        return false;
    }

    public boolean canDirectlyExtractItems(SideConfig config, SocketTileAccess ts) {
        return false;
    }

    public int itemFill(ItemStack item, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        return 0;
    }

    public ItemStack itemExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        return null;
    }

    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
    }

    public boolean isEnergyInterface(SideConfig config) {
        return false;
    }

    public int receiveEnergy(int amount, boolean simulate, SideConfig config, SocketTileAccess ts) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate, SideConfig config, SocketTileAccess ts) {
        return 0;
    }

    public boolean isRedstoneInterface() {
        return false;
    }

    public void updateRestone(boolean on, SideConfig config, SocketTileAccess ts) {
    }

    public boolean isOutputtingRedstone(SideConfig config, SocketTileAccess ts) {
        return false;
    }

    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
    }

    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
    }

    public void onSocketPlaced(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
    }

    public void onSocketRemoved(SideConfig config, SocketTileAccess ts, ForgeDirection side, boolean wrenched) {
        if (!wrenched) {
            this.onRemoved(ts, config, side);
        }
    }

    public boolean canModuleBeDyed() {
        return false;
    }

    public boolean renderEnergyAmount() {
        return false;
    }

    public void onSocketLoad(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
    }

    public void onSocketSave(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
    }
}

