/*
 * Decompiled with CFR 0.152.
 */
package emasher.api;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emasher.EngineersToolbox;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.packethandling.AdapterSideMessage;
import emasher.packethandling.ChangerSideMessage;
import emasher.tileentities.TileAdapterBase;
import emasher.tileentities.TileDirectionChanger;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class Util {
    static boolean checkArrays(int[] arr1, int[] arr2) {
        if (arr1 == null || arr2 == null) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            for (int j = 0; j < arr2.length; ++j) {
                if (arr1[i] != arr2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static EntityPlayer createFakePlayer(World world, int x, int y, int z) {
        EntityPlayer player = new EntityPlayer(world, new GameProfile(UUID.randomUUID(), "Engineer's Toolbox")){

            public void func_145747_a(IChatComponent p_145747_1_) {
            }

            public boolean func_70003_b(int var1, String var2) {
                return false;
            }

            public ChunkCoordinates func_82114_b() {
                return null;
            }
        };
        player.field_70165_t = x;
        player.field_70163_u = y;
        player.field_70161_v = z;
        player.field_70169_q = x;
        player.field_70167_r = y;
        player.field_70166_s = z;
        return player;
    }

    public static boolean swapBlocks(World world, int x, int y, int z, int nx, int ny, int nz) {
        SocketModule m;
        ForgeDirection side;
        SocketModule m2;
        ForgeDirection d;
        int i;
        TileEntity te;
        Block b1 = world.func_147439_a(x, y, z);
        int meta1 = world.func_72805_g(x, y, z);
        Block b2 = world.func_147439_a(nx, ny, nz);
        int meta2 = world.func_72805_g(nx, ny, nz);
        if (b1 == emasher.blocks.Blocks.miniPortal()) {
            return false;
        }
        if (b2 == emasher.blocks.Blocks.miniPortal()) {
            return false;
        }
        if (b1 != null && b1.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (b2 != null && b2.func_149712_f(world, nx, ny, nz) < 0.0f) {
            return false;
        }
        TileEntity te1 = world.func_147438_o(x, y, z);
        NBTTagCompound nbt1 = new NBTTagCompound();
        if (te1 != null) {
            te1.func_145841_b(nbt1);
        }
        world.func_147475_p(x, y, z);
        world.func_147468_f(x, y, z);
        TileEntity te2 = world.func_147438_o(nx, ny, nz);
        NBTTagCompound nbt2 = new NBTTagCompound();
        if (te2 != null) {
            te2.func_145841_b(nbt2);
        }
        world.func_147475_p(nx, ny, nz);
        world.func_147468_f(nx, ny, nz);
        world.func_147465_d(x, y, z, b2, meta2, 3);
        if (b2 instanceof BlockContainer && (te = world.func_147438_o(x, y, z)) != null) {
            te.func_145839_a(nbt2);
            te.field_145851_c = x;
            te.field_145848_d = y;
            te.field_145849_e = z;
            if (te instanceof SocketTileAccess) {
                for (i = 0; i < 6; ++i) {
                    d = ForgeDirection.getOrientation((int)i);
                    m2 = ((SocketTileAccess)te).getSide(d);
                    m2.onSocketPlaced(((SocketTileAccess)te).getConfigForSide(d), (SocketTileAccess)te, d);
                }
            }
        }
        world.func_147465_d(nx, ny, nz, b1, meta1, 3);
        if (b1 instanceof BlockContainer && (te = world.func_147438_o(nx, ny, nz)) != null) {
            te.func_145839_a(nbt1);
            te.field_145851_c = nx;
            te.field_145848_d = ny;
            te.field_145849_e = nz;
            if (te instanceof SocketTileAccess) {
                for (i = 0; i < 6; ++i) {
                    d = ForgeDirection.getOrientation((int)i);
                    m2 = ((SocketTileAccess)te).getSide(d);
                    m2.onSocketPlaced(((SocketTileAccess)te).getConfigForSide(d), (SocketTileAccess)te, d);
                }
            }
        }
        if ((te = world.func_147438_o(x, y, z)) != null) {
            if (te instanceof SocketTileAccess) {
                SocketTileAccess ts = (SocketTileAccess)te;
                for (int i2 = 0; i2 < 6; ++i2) {
                    side = ForgeDirection.getOrientation((int)i2);
                    m = ts.getSide(side);
                    m.onSocketPlaced(ts.getConfigForSide(side), ts, side);
                    ts.sendClientSideState(i2);
                }
            }
            if (te instanceof TileAdapterBase) {
                TileAdapterBase ta = (TileAdapterBase)te;
                for (int i3 = 0; i3 < 6; ++i3) {
                    EngineersToolbox.network().sendToDimension((IMessage)new AdapterSideMessage(ta, (byte)i3), world.field_73011_w.field_76574_g);
                }
            }
            if (te instanceof TileDirectionChanger) {
                TileDirectionChanger td = (TileDirectionChanger)te;
                for (int i4 = 0; i4 < 6; ++i4) {
                    EngineersToolbox.network().sendToDimension((IMessage)new ChangerSideMessage(td, (byte)i4), world.field_73011_w.field_76574_g);
                }
            }
        }
        if ((te = world.func_147438_o(nx, ny, nz)) != null) {
            if (te instanceof SocketTileAccess) {
                SocketTileAccess ts = (SocketTileAccess)te;
                for (int i5 = 0; i5 < 6; ++i5) {
                    side = ForgeDirection.getOrientation((int)i5);
                    m = ts.getSide(side);
                    m.onSocketPlaced(ts.getConfigForSide(side), ts, side);
                    ts.sendClientSideState(i5);
                }
            }
            if (te instanceof TileAdapterBase) {
                TileAdapterBase ta = (TileAdapterBase)te;
                for (int i6 = 0; i6 < 6; ++i6) {
                    EngineersToolbox.network().sendToDimension((IMessage)new AdapterSideMessage(ta, (byte)i6), world.field_73011_w.field_76574_g);
                }
            }
            if (te instanceof TileDirectionChanger) {
                TileDirectionChanger td = (TileDirectionChanger)te;
                for (int i7 = 0; i7 < 6; ++i7) {
                    EngineersToolbox.network().sendToDimension((IMessage)new ChangerSideMessage(td, (byte)i7), world.field_73011_w.field_76574_g);
                }
            }
        }
        return true;
    }

    public static boolean canMoveBlock(World world, int x, int y, int z, int nx, int ny, int nz) {
        if (ny >= 255 || ny <= 0) {
            return false;
        }
        if (!Util.isBlockReplaceable(world, nx, ny, nz)) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b == emasher.blocks.Blocks.miniPortal()) {
            return false;
        }
        return b == null || !(b.func_149712_f(world, x, y, z) < 0.0f);
    }

    public static boolean moveBlock(World world, int x, int y, int z, int nx, int ny, int nz) {
        return Util.moveBlock(world, x, y, z, nx, ny, nz, true);
    }

    public static boolean moveBlock(World world, int x, int y, int z, int nx, int ny, int nz, boolean updateSocket) {
        if (ny >= 255 || ny <= 0) {
            return false;
        }
        if (!Util.isBlockReplaceable(world, nx, ny, nz)) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b == emasher.blocks.Blocks.miniPortal()) {
            return false;
        }
        if (b != null && b.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        NBTTagCompound nbt = new NBTTagCompound();
        if (te != null) {
            te.func_145841_b(nbt);
            world.func_147475_p(x, y, z);
        }
        world.func_147468_f(x, y, z);
        world.func_147465_d(nx, ny, nz, b, meta, 3);
        List ents = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 3), (double)(z + 1)));
        for (Object e : ents) {
            if (!(e instanceof Entity)) continue;
            Entity ent = (Entity)e;
            ent.func_70107_b(ent.field_70165_t + (double)(nx - x), ent.field_70163_u + (double)(ny - y), ent.field_70161_v + (double)(nz - z));
        }
        te = world.func_147438_o(nx, ny, nz);
        if (te != null) {
            te.func_145839_a(nbt);
            te.field_145851_c = nx;
            te.field_145848_d = ny;
            te.field_145849_e = nz;
            if (updateSocket && te instanceof SocketTileAccess) {
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection d = ForgeDirection.getOrientation((int)i);
                    SocketModule m = ((SocketTileAccess)te).getSide(d);
                    m.onSocketPlaced(((SocketTileAccess)te).getConfigForSide(d), (SocketTileAccess)te, d);
                }
            }
        }
        return true;
    }

    public static boolean isBlockReplaceable(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return world.func_147437_c(x, y, z) || b == Blocks.field_150395_bd || b == Blocks.field_150329_H || b == Blocks.field_150330_I || b == Blocks.field_150480_ab || b == Blocks.field_150358_i || b == Blocks.field_150355_j || b == Blocks.field_150356_k || b == Blocks.field_150353_l || b.isReplaceable((IBlockAccess)world, x, y, z) || b instanceof BlockFluidBase;
    }
}

