/*
 * Decompiled with CFR 0.152.
 */
package emasher.microcontrollers;

import emasher.api.SideConfig;
import emasher.microcontrollers.BlueGreenIndicatorState$;
import emasher.microcontrollers.RedPurpleIndicatorState;
import emasher.microcontrollers.SideState;
import emasher.microcontrollers.SocketState;
import emasher.tileentities.TileSocket;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class SocketState$
implements Serializable {
    public static final SocketState$ MODULE$;

    static {
        new SocketState$();
    }

    public SocketState generateFromTileEntity(TileSocket te) {
        return new SocketState((List<SideState>)((List)((List)Predef$.MODULE$.refArrayOps((Object[])te.configs).toList().zip((GenIterable)Predef$.MODULE$.intArrayOps(te.sides).toList(), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){

            public final SideState apply(Tuple2<SideConfig, Object> x0$1) {
                Tuple2<SideConfig, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    SideConfig config = (SideConfig)tuple2._1();
                    int side = tuple2._2$mcI$sp();
                    if (config != null) {
                        SideConfig sideConfig = config;
                        int n = side;
                        SideState sideState = SocketState$.MODULE$.emasher$microcontrollers$SocketState$$generateSideFromConfig(sideConfig, n);
                        return sideState;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public SideState emasher$microcontrollers$SocketState$$generateSideFromConfig(SideConfig config, int side) {
        return new SideState(side, config.meta, this.intToBlueGreenState(config.tank), this.intToBlueGreenState(config.inventory), this.boolArrayToRedPurpleState(config.rsControl), this.boolArrayToRedPurpleState(config.rsLatch));
    }

    private Enumeration.Value intToBlueGreenState(int state) {
        Enumeration.Value value;
        int n = state;
        switch (n) {
            default: {
                value = BlueGreenIndicatorState$.MODULE$.INVALID();
                break;
            }
            case 2: {
                value = BlueGreenIndicatorState$.MODULE$.TWO();
                break;
            }
            case 1: {
                value = BlueGreenIndicatorState$.MODULE$.ONE();
                break;
            }
            case 0: {
                value = BlueGreenIndicatorState$.MODULE$.ZERO();
            }
        }
        return value;
    }

    private RedPurpleIndicatorState boolArrayToRedPurpleState(boolean[] state) {
        return new RedPurpleIndicatorState(state[0], state[1], state[2]);
    }

    public SocketState apply(List<SideState> sides) {
        return new SocketState(sides);
    }

    public Option<List<SideState>> unapply(SocketState x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.sides());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SocketState$() {
        MODULE$ = this;
    }
}

