/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModCharger
extends SocketModule {
    public ModCharger(int id) {
        super(id, "eng_toolbox:charger", "eng_toolbox:discharger");
    }

    @Override
    public String getLocalizedName() {
        return "Charger";
    }

    public void getToolTip(List l) {
        l.add("Used to charge electric items");
        l.add("Compatible with RF and EU");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory containing item to charge");
        l.add(Config.PREF_AQUA() + "Item dependent power requirement");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return "eng_toolbox:inner_charger";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_charger"};
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ggg", "slr", " b ", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('s'), Items.field_151114_aO, Character.valueOf('l'), "dyeLime", Character.valueOf('r'), Items.field_151043_k, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public int getCurrentTexture(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.tank == -1) {
            return 0;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon[] getAdditionalOverlays(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return new IIcon[]{emasher.blocks.Blocks.socket().chargeInd[config.meta]};
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.tank = config.tank == -1 ? 0 : -1;
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.getStackInInventorySlot(config.inventory);
        }
        return null;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        ItemStack is;
        if (config.inventory != -1 && ts.getStackInInventorySlot(config.inventory) != null && (is = ts.getStackInInventorySlot(config.inventory)).func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem ieci = (IEnergyContainerItem)is.func_77973_b();
            if (config.tank == -1) {
                int amnt = ieci.receiveEnergy(is, ts.useEnergy(100, true), false);
                ts.useEnergy(amnt, false);
            } else {
                int amnt = ts.addEnergy(ieci.extractEnergy(is, 100, true), false);
                ieci.extractEnergy(is, amnt, false);
            }
            this.updateMeta(ts, config, side);
        }
    }

    @Override
    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.inventory) {
            ts.sendClientInventorySlot(index);
            this.updateMeta(ts, config, side);
        }
    }

    @Override
    public void onSideActivated(SocketTileAccess ts, SideConfig config, ForgeDirection side, EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        int added = 0;
        boolean flag = false;
        if (config.inventory != -1) {
            ItemStack stack;
            if (is != null) {
                added = ts.addItemInternal(is, true, config.inventory);
                is.field_77994_a -= added;
            }
            if ((stack = ts.getStackInInventorySlot(config.inventory)) != null && is != null) {
                flag = !stack.func_77969_a(is);
            } else {
                boolean bl = flag = stack != null;
            }
            if (added == 0 && stack != null && flag) {
                int xo = ts.field_145851_c + side.offsetX;
                int yo = ts.field_145848_d + side.offsetY;
                int zo = ts.field_145849_e + side.offsetZ;
                int dropped = 0;
                dropped = config.meta == 1 ? Math.min(stack.field_77994_a, stack.func_77976_d()) : 1;
                ItemStack dropStack = stack.func_77946_l();
                dropStack.field_77994_a = dropped;
                this.dropItemsOnSide(ts, config, side, xo, yo, zo, dropStack);
                ts.extractItemInternal(true, config.inventory, dropped);
            }
            ts.sendClientInventorySlot(config.inventory);
        }
    }

    public void dropItemsOnSide(SocketTileAccess ts, SideConfig config, ForgeDirection side, int xo, int yo, int zo, ItemStack stack) {
        if (!ts.func_145831_w().field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(ts.func_145831_w(), (double)xo + d0, (double)yo + d1, (double)zo + d2, stack);
            entityitem.field_145804_b = 1;
            ts.func_145831_w().func_72838_d((Entity)entityitem);
        }
    }

    public void updateMeta(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        ItemStack is;
        if (config.inventory != -1 && ts.getStackInInventorySlot(config.inventory) != null && (is = ts.getStackInInventorySlot(config.inventory)).func_77973_b() instanceof IEnergyContainerItem) {
            int newMeta;
            IEnergyContainerItem ieci = (IEnergyContainerItem)is.func_77973_b();
            int maxCharge = ieci.getMaxEnergyStored(is);
            int currCharge = ieci.getEnergyStored(is);
            int oldMeta = config.meta;
            config.meta = newMeta = (int)((float)currCharge / (float)maxCharge * 12.0f);
            if (oldMeta != newMeta) {
                ts.sendClientSideState(side.ordinal());
            }
            return;
        }
        boolean wasZero = config.meta == 0;
        config.meta = 0;
        if (!wasZero) {
            ts.sendClientSideState(side.ordinal());
        }
    }

    @Override
    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            ts.sendClientInventorySlot(config.inventory);
        }
    }
}

