/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class ModFluidOutput
extends SocketModule {
    public ModFluidOutput(int id) {
        super(id, "eng_toolbox:fluidOutput");
    }

    @Override
    public String getLocalizedName() {
        return "Fluid Output";
    }

    public void getToolTip(List l) {
        l.add("Outputs fluid from its configured");
        l.add("tank to adjacent pipes/tanks/etc.");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to output from");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"d", "u", "b", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('d'), Blocks.field_150411_aY, Character.valueOf('u'), Blocks.field_150409_cd, Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.tank < 0 || config.tank > 2) {
            return;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    ts.tryInsertFluid(config.tank, side);
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                ts.tryInsertFluid(config.tank, side);
                return;
            }
            allOff = false;
        }
        if (allOff) {
            ts.tryInsertFluid(config.tank, side);
        }
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isFluidInterface() {
        return true;
    }

    @Override
    public boolean canExtractFluid() {
        return true;
    }

    @Override
    public FluidStack fluidExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        if (config.tank != -1) {
            return ts.drainInternal(config.tank, amount, doExtract);
        }
        return null;
    }

    @Override
    public void onTankChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.tank) {
            ts.sendClientTankSlot(index);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTankToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        return config.tank;
    }
}

