/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.util.ForgeDirection;

public class ModFurnace
extends SocketModule {
    public ModFurnace(int id) {
        super(id, "eng_toolbox:furnaceIdle", "eng_toolbox:furnaceActive");
    }

    @Override
    public String getLocalizedName() {
        return "Furnace";
    }

    public void getToolTip(List l) {
        l.add("Uses energy to smelt items");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Input inventory");
        l.add(Config.PREF_YELLOW() + "Outputs to Machine Output");
        l.add(Config.PREF_AQUA() + "Requires 10 RF/t");
        l.add("Cannot be installed on a socket with other machines");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{" h ", "iui", " b ", Character.valueOf('i'), Blocks.field_150336_V, Character.valueOf('h'), Items.psu(), Character.valueOf('u'), Blocks.field_150460_al, Character.valueOf('b'), Items.blankSide()});
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean isMachine() {
        return true;
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        for (int i = 0; i < 6; ++i) {
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)i));
            if (m == null || !m.isMachine()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onRemoved(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        ts.sideInventory.func_70299_a(side.ordinal(), null);
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean updateClient = false;
        if (config.inventory >= 0 && config.inventory <= 2) {
            if (ts.sideInventory.func_70301_a(side.ordinal()) == null) {
                if (ts.getStackInInventorySlot(config.inventory) != null) {
                    ItemStack toIntake = ts.getStackInInventorySlot(config.inventory);
                    ItemStack product = FurnaceRecipes.func_77602_a().func_151395_a(toIntake);
                    if (product != null) {
                        ts.extractItemInternal(true, config.inventory, 1);
                        ts.sideInventory.func_70299_a(side.ordinal(), product.func_77946_l());
                        config.meta = 180;
                        config.rsControl[0] = false;
                        updateClient = true;
                    }
                }
            } else if (ts.useEnergy(10, true) >= 10 && config.meta > 0) {
                ts.useEnergy(10, false);
                --config.meta;
                if (config.meta == 0) {
                    updateClient = true;
                }
                if (!config.rsControl[0] && config.meta > 0) {
                    config.rsControl[0] = true;
                    updateClient = true;
                }
            } else if (config.rsControl[0]) {
                config.rsControl[0] = false;
                updateClient = true;
            }
            if (config.meta == 0 && ts.sideInventory.func_70301_a(side.ordinal()) != null) {
                int num = ts.forceOutputItem(ts.sideInventory.func_70301_a(side.ordinal()));
                ts.sideInventory.func_70301_a((int)side.ordinal()).field_77994_a -= num;
                if (ts.sideInventory.func_70301_a((int)side.ordinal()).field_77994_a <= 0) {
                    ts.sideInventory.func_70299_a(side.ordinal(), null);
                }
            }
            if (updateClient) {
                ts.sendClientSideState(side.ordinal());
            }
        }
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        if (config.meta == 0 || !config.rsControl[0]) {
            return 0;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.meta == 0 || !config.rsControl[0]) {
            return "eng_toolbox:inner_black";
        }
        return "eng_toolbox:inner_fire_blue";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_fire_blue"};
    }
}

