/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModItemInput
extends SocketModule {
    public ModItemInput(int id) {
        super(id, "eng_toolbox:itemInput");
    }

    @Override
    public String getLocalizedName() {
        return "Item Input";
    }

    public void getToolTip(List l) {
        l.add("Accepts items from adjacent automation");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory to input to");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"h", "b", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('h'), Blocks.field_150415_aT, Character.valueOf('u'), Blocks.field_150415_aT, Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canInsertItems() {
        return true;
    }

    @Override
    public boolean canDirectlyInsertItems(SideConfig config, SocketTileAccess ts) {
        if (config.inventory < 0 || config.inventory > 2) {
            return false;
        }
        boolean canIntake = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canIntake = false;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canIntake = false;
        }
        return canIntake;
    }

    @Override
    public int itemFill(ItemStack item, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean canIntake = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canIntake = false;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canIntake = false;
        }
        if (canIntake && config.inventory != -1) {
            return ts.addItemInternal(item, doFill, config.inventory);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.getStackInInventorySlot(config.inventory);
        }
        return null;
    }

    @Override
    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.inventory) {
            ts.sendClientInventorySlot(index);
        }
    }
}

