/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModMachineOutput
extends SocketModule {
    public ModMachineOutput(int id) {
        super(id, "eng_toolbox:machineOutput", "eng_toolbox:machineOutputEject");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{"h", "d", "b", Character.valueOf('d'), Blocks.field_150367_z, Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('u'), Blocks.field_150415_aT, Character.valueOf('b'), Items.blankSide()});
    }

    @Override
    public String getLocalizedName() {
        return "Machine Output";
    }

    public void getToolTip(List l) {
        l.add("Recieves item and fluid");
        l.add("output from certain machines");
        l.add("and places it in selected");
        l.add("inventory and/or tank");
        l.add("Outputs items and fluids into");
        l.add("adjacent tanks/inventories/pipes");
        l.add("as well as ejects items");
        l.add("into the world when configured");
        l.add("to do so");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Output tank");
        l.add(Config.PREF_GREEN() + "Output inventory");
        l.add(Config.PREF_WHITE() + "Configure if output ejects into the world");
        l.add("Only one can be installed per socket");
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        return config.meta;
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        for (int i = 0; i < 6; ++i) {
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)i));
            if (m.moduleID != this.moduleID) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        ++config.meta;
        if (config.meta == 2) {
            config.meta = 0;
        }
        ts.sendClientSideState(side.ordinal());
        ts.updateAdj(side);
    }

    @Override
    public boolean isFluidInterface() {
        return true;
    }

    @Override
    public boolean canExtractFluid() {
        return true;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canExtractItems() {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        this.FluidInsert(ts, config, side);
        this.ItemInsert(ts, config, side);
        if (config.meta == 1) {
            if (config.inventory < 0 || config.inventory > 2) {
                return;
            }
            if (ts.getStackInInventorySlot(config.inventory) == null) {
                return;
            }
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            if (!ts.func_145831_w().func_147437_c(xo, yo, zo)) {
                return;
            }
            this.dropItemsOnSide(ts, config, side, xo, yo, zo, ts.getStackInInventorySlot(config.inventory));
        }
    }

    private void FluidInsert(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.tank < 0 || config.tank > 2) {
            return;
        }
        ts.tryInsertFluid(config.tank, side);
    }

    private void ItemInsert(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory < 0 || config.inventory > 2) {
            return;
        }
        if (ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
            ts.extractItemInternal(true, config.inventory, 1);
        }
    }

    public void dropItemsOnSide(SocketTileAccess ts, SideConfig config, ForgeDirection side, int xo, int yo, int zo, ItemStack stack) {
        if (!ts.func_145831_w().field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(ts.func_145831_w(), (double)xo + d0, (double)yo + d1, (double)zo + d2, stack.func_77946_l());
            entityitem.field_145804_b = 1;
            ts.func_145831_w().func_72838_d((Entity)entityitem);
            ts.extractItemInternal(true, config.inventory, ts.getStackInInventorySlot((int)config.inventory).field_77994_a);
        }
    }

    @Override
    public boolean canDirectlyExtractItems(SideConfig config, SocketTileAccess ts) {
        if (config.inventory < 0 || config.inventory > 2) {
            return false;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    return true;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                return true;
            }
            allOff = false;
        }
        return allOff;
    }
}

