/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.modules.ModMagnet;
import emasher.util.Config;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class ModMagnetInput
extends ModMagnet {
    public ModMagnetInput(int id) {
        super(id, "eng_toolbox:magnetInput");
    }

    @Override
    public String getLocalizedName() {
        return "Magnet Input";
    }

    @Override
    public void getToolTip(List l) {
        l.add("Combined Magnet, Fluid, Item, and Energy input modules");
    }

    @Override
    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to input to");
        l.add(Config.PREF_GREEN() + "Inventory to input to");
        l.add(Config.PREF_RED() + "Magnet Enabled");
        l.add(Config.PREF_DARK_PURPLE() + "Magnet Enabled");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{new ItemStack(Items.module(), 1, 9), new ItemStack(Items.module(), 1, 47)});
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isEnergyInterface(SideConfig config) {
        return true;
    }

    @Override
    public int receiveEnergy(int amount, boolean simulate, SideConfig config, SocketTileAccess ts) {
        return ts.addEnergy(amount, simulate);
    }

    @Override
    public boolean isFluidInterface() {
        return true;
    }

    @Override
    public boolean canInsertFluid() {
        return true;
    }

    @Override
    public int fluidFill(FluidStack fluid, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.tank != -1) {
            return ts.fillInternal(config.tank, fluid, doFill);
        }
        return 0;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canInsertItems() {
        return true;
    }

    @Override
    public boolean canDirectlyInsertItems(SideConfig config, SocketTileAccess ts) {
        return config.inventory >= 0 && config.inventory <= 2;
    }

    @Override
    public int itemFill(ItemStack item, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.addItemInternal(item, doFill, config.inventory);
        }
        return 0;
    }
}

