/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class ModMultiOutput
extends SocketModule {
    public ModMultiOutput(int id) {
        super(id, "eng_toolbox:multiOutput");
    }

    @Override
    public String getLocalizedName() {
        return "Multi Output";
    }

    public void getToolTip(List l) {
        l.add("Combined Fluid, Item, and Energy output modules");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to output from");
        l.add(Config.PREF_GREEN() + "Inventory to output from");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{new ItemStack(Items.module(), 1, 2), new ItemStack(Items.module(), 1, 5), new ItemStack(Items.module(), 1, 8)});
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isEnergyInterface(SideConfig config) {
        return true;
    }

    @Override
    public boolean isFluidInterface() {
        return true;
    }

    @Override
    public boolean canExtractFluid() {
        return true;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canExtractItems() {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        this.EnergyInsert(ts, config, side);
        this.FluidInsert(ts, config, side);
        this.ItemInsert(ts, config, side);
    }

    private void EnergyInsert(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    ts.outputEnergy(1000, side);
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                ts.outputEnergy(1000, side);
                return;
            }
            allOff = false;
        }
        if (allOff) {
            ts.outputEnergy(1000, side);
        }
    }

    private void FluidInsert(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.tank < 0 || config.tank > 2) {
            return;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    ts.tryInsertFluid(config.tank, side);
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                ts.tryInsertFluid(config.tank, side);
                return;
            }
            allOff = false;
        }
        if (allOff) {
            ts.tryInsertFluid(config.tank, side);
        }
    }

    private void ItemInsert(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory < 0 || config.inventory > 2) {
            return;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    if (ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
                        ts.extractItemInternal(true, config.inventory, 1);
                    }
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                if (ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
                    ts.extractItemInternal(true, config.inventory, 1);
                }
                return;
            }
            allOff = false;
        }
        if (allOff && ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
            ts.extractItemInternal(true, config.inventory, 1);
        }
    }

    @Override
    public FluidStack fluidExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        if (config.tank != -1) {
            return ts.drainInternal(config.tank, amount, doExtract);
        }
        return null;
    }

    @Override
    public ItemStack itemExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        if (config.inventory != -1) {
            return ts.extractItemInternal(doExtract, config.inventory, amount);
        }
        return null;
    }

    @Override
    public int extractEnergy(int amount, boolean simulate, SideConfig config, SocketTileAccess ts) {
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    return ts.useEnergy(amount, simulate);
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                return ts.useEnergy(amount, simulate);
            }
            allOff = false;
        }
        if (allOff) {
            return ts.useEnergy(amount, simulate);
        }
        return 0;
    }

    @Override
    public boolean canDirectlyExtractItems(SideConfig config, SocketTileAccess ts) {
        if (config.inventory < 0 || config.inventory > 2) {
            return false;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    return true;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                return true;
            }
            allOff = false;
        }
        return allOff;
    }
}

