/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.modules.ModRangeSelector;
import emasher.util.Config;
import emasher.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModPump
extends SocketModule {
    public ModPump(int id) {
        super(id, "eng_toolbox:pump");
    }

    @Override
    public String getLocalizedName() {
        return "Enderic Fluid Pump";
    }

    public void getToolTip(List l) {
        l.add("Pumps fluid blocks below it");
        l.add("within a radius set by");
        l.add("a Range Selector Module");
        l.add("and stores it in an internal");
        l.add("tank");
        l.add("Note that this module may");
        l.add("still be buggy!");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Input Tank");
        l.add(Config.PREF_AQUA() + "Uses 10 RF/t");
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"uuu", "cbc", "ded", Character.valueOf('u'), Items.field_151133_ar, Character.valueOf('c'), "ingotCopper", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        return side == ForgeDirection.DOWN;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.meta == 0) {
            config.meta = 8;
            if (config.tank >= 0 && config.tank <= 2 && ts.getEnergyStored() >= 10 && !config.tags.func_74764_b("pump_complete")) {
                if (!config.tags.func_74764_b("pump_valid")) {
                    this.init(ts, config, side);
                } else {
                    int iteration = config.tags.func_74762_e("iteration");
                    if (config.tags.func_74764_b("x" + iteration)) {
                        int x = config.tags.func_74762_e("x" + iteration);
                        int z = config.tags.func_74762_e("z" + iteration);
                        int y = config.tags.func_74762_e("currY");
                        if (this.drainCurrentBlock(config, ts, side, x, y, z)) {
                            config.tags.func_82580_o("iteration");
                            config.tags.func_82580_o("x" + iteration);
                            config.tags.func_82580_o("z" + iteration);
                            config.tags.func_74768_a("iteration", iteration + 1);
                            ts.useEnergy(10, false);
                        }
                    } else {
                        this.onLower(config, ts, side);
                    }
                }
            }
        } else {
            --config.meta;
        }
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.meta = 0;
        config.tags.func_82580_o("currY");
        config.tags.func_74768_a("currY", ts.field_145848_d - 1);
        config.tags.func_82580_o("pump_complete");
        config.tags.func_74757_a("pump_valid", true);
        config.tags.func_82580_o("iteration");
        this.generateLayer(config, ts, side);
        config.tags.func_74768_a("iteration", 0);
    }

    @Override
    public void onSocketPlaced(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        this.init(ts, config, side);
    }

    public void onLower(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        int y = config.tags.func_74762_e("currY");
        config.tags.func_82580_o("currY");
        config.tags.func_74768_a("currY", y - 1);
        config.tags.func_82580_o("iteration");
        this.generateLayer(config, ts, side);
        config.tags.func_74768_a("iteration", 0);
    }

    public void generateLayer(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        int i;
        int radius = this.getRadius(ts);
        int y = config.tags.func_74762_e("currY");
        Fluid filterFluid = this.getFilterFluid(ts, config);
        int filterID = -1;
        if (filterFluid != null) {
            filterID = filterFluid.getID();
        }
        ArrayList<Tuple> allQuards = new ArrayList<Tuple>();
        for (i = ts.field_145851_c - radius; i <= ts.field_145851_c + radius; ++i) {
            for (int j = ts.field_145849_e - radius; j <= ts.field_145849_e + radius; ++j) {
                if (!this.isFluidBlock(config, ts, side, i, y, j) || filterFluid != null && (this.getBlockFluid(ts, i, y, j) == null || filterID != -1 && filterID != this.getBlockFluid(ts, i, y, j).getID())) continue;
                allQuards.add(new Tuple(i, y, j));
            }
        }
        if (allQuards.size() == 0 || y == 0) {
            config.tags.func_74757_a("pump_complete", true);
            return;
        }
        i = 0;
        while (allQuards.size() > 0) {
            int rnd = ts.func_145831_w().field_73012_v.nextInt(allQuards.size());
            Tuple quards = (Tuple)allQuards.remove(rnd);
            config.tags.func_74768_a("x" + i, quards.x());
            config.tags.func_74768_a("z" + i, quards.z());
            ++i;
        }
    }

    public boolean drainCurrentBlock(SideConfig config, SocketTileAccess ts, ForgeDirection side, int x, int y, int z) {
        IFluidBlock fb;
        FluidStack fs;
        Block b = ts.func_145831_w().func_147439_a(x, y, z);
        Fluid filterFluid = this.getFilterFluid(ts, config);
        int filterID = -1;
        if (filterFluid != null) {
            filterID = filterFluid.getID();
        }
        if (b == Blocks.field_150355_j) {
            FluidStack fs2 = new FluidStack(FluidRegistry.WATER, 1000);
            if (fs2 != null && ts.fillInternal(config.tank, fs2, false) == fs2.amount && (filterID == -1 || filterID == fs2.getFluidID())) {
                ts.fillInternal(config.tank, fs2, true);
                ts.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
                return true;
            }
            return false;
        }
        if (b == Blocks.field_150353_l) {
            FluidStack fs3 = new FluidStack(FluidRegistry.LAVA, 1000);
            if (fs3 != null && ts.fillInternal(config.tank, fs3, false) == fs3.amount && (filterID == -1 || filterID == fs3.getFluidID())) {
                ts.fillInternal(config.tank, fs3, true);
                ts.func_145831_w().func_147449_b(x, y, z, Blocks.field_150348_b);
                return true;
            }
            return false;
        }
        if (b != null && b instanceof IFluidBlock && (fs = (fb = (IFluidBlock)b).drain(ts.func_145831_w(), x, y, z, false)) != null && ts.fillInternal(config.tank, fs, false) == fs.amount && (filterID == -1 || filterID == fs.getFluidID())) {
            ts.fillInternal(config.tank, fb.drain(ts.func_145831_w(), x, y, z, true), true);
            ts.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
            ts.func_145831_w().func_147475_p(x, y, z);
            return true;
        }
        Fluid f = null;
        if (b != null && b instanceof IFluidBlock) {
            f = ((IFluidBlock)b).getFluid();
        }
        return b == null || b != null && !(b instanceof IFluidBlock) || f != null && f.getID() != filterID;
    }

    public boolean isFluidBlock(SideConfig config, SocketTileAccess ts, ForgeDirection side, int x, int y, int z) {
        Block b = ts.func_145831_w().func_147439_a(x, y, z);
        if (b == Blocks.field_150355_j || b == Blocks.field_150353_l) {
            return true;
        }
        return b != null && b instanceof IFluidBlock;
    }

    public Fluid getBlockFluid(SocketTileAccess ts, int x, int y, int z) {
        Block b = ts.func_145831_w().func_147439_a(x, y, z);
        if (b == Blocks.field_150355_j) {
            return FluidRegistry.WATER;
        }
        if (b == Blocks.field_150353_l) {
            return FluidRegistry.LAVA;
        }
        if (b != null && b instanceof IFluidBlock) {
            return ((IFluidBlock)b).getFluid();
        }
        return null;
    }

    public Fluid getFilterFluid(SocketTileAccess ts, SideConfig config) {
        if (config.inventory >= 0 && config.inventory <= 2) {
            ItemStack is = ts.getStackInInventorySlot(config.inventory);
            if (is == null) {
                return null;
            }
            if (is.func_77973_b() == Items.field_151131_as) {
                return FluidRegistry.WATER;
            }
            if (is.func_77973_b() == Items.field_151129_at) {
                return FluidRegistry.LAVA;
            }
            if (is.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)is.func_77973_b()).getFluid(is).getFluid();
            }
        }
        return null;
    }

    public int getRadius(SocketTileAccess ts) {
        for (int i = 0; i < 6; ++i) {
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)i));
            if (m == null || !(m instanceof ModRangeSelector)) continue;
            return ts.getConfigForSide((ForgeDirection)ForgeDirection.getOrientation((int)i)).meta;
        }
        return 7;
    }
}

