/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModSpinningWheel
extends SocketModule {
    public ModSpinningWheel(int id) {
        super(id, "eng_toolbox:spinningWheel", "eng_toolbox:spinningWheelActive");
    }

    @Override
    public String getLocalizedName() {
        return "Spinning Wheel";
    }

    public void getToolTip(List l) {
        l.add("Spins wool into string");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Input inventory");
        l.add(Config.PREF_YELLOW() + "Outputs to Machine Output");
        l.add(Config.PREF_AQUA() + "Requires 10 RF/t");
        l.add("Cannot be installed on a socket with other machines");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{" hs", "sws", "sb ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('h'), emasher.items.Items.psu(), Character.valueOf('w'), "plankWood", Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean isMachine() {
        return true;
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        for (int i = 0; i < 6; ++i) {
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)i));
            if (m == null || !m.isMachine()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onRemoved(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        ts.sideInventory.func_70299_a(side.ordinal(), null);
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean updateClient = false;
        if (config.inventory >= 0 && config.inventory <= 2) {
            if (ts.sideInventory.func_70301_a(side.ordinal()) == null) {
                if (ts.getStackInInventorySlot(config.inventory) != null) {
                    ItemStack toIntake = ts.getStackInInventorySlot(config.inventory);
                    ItemStack product = null;
                    if (toIntake.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                        product = new ItemStack(Items.field_151007_F, 4, 0);
                    }
                    if (product != null) {
                        ts.extractItemInternal(true, config.inventory, 1);
                        ts.sideInventory.func_70299_a(side.ordinal(), product.func_77946_l());
                        config.meta = 180;
                        config.rsControl[0] = false;
                        updateClient = true;
                    }
                }
            } else if (ts.useEnergy(10, true) >= 10 && config.meta > 0) {
                ts.useEnergy(10, false);
                --config.meta;
                if (config.meta == 0) {
                    updateClient = true;
                }
                if (!config.rsControl[0] && config.meta > 0) {
                    config.rsControl[0] = true;
                    updateClient = true;
                }
            } else if (config.rsControl[0]) {
                config.rsControl[0] = false;
                updateClient = true;
            }
            if (config.meta == 0 && ts.sideInventory.func_70301_a(side.ordinal()) != null) {
                int num = ts.forceOutputItem(ts.sideInventory.func_70301_a(side.ordinal()));
                ts.sideInventory.func_70301_a((int)side.ordinal()).field_77994_a -= num;
                if (ts.sideInventory.func_70301_a((int)side.ordinal()).field_77994_a <= 0) {
                    ts.sideInventory.func_70299_a(side.ordinal(), null);
                }
            }
            if (updateClient) {
                ts.sendClientSideState(side.ordinal());
            }
        }
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        if (config.meta == 0 || !config.rsControl[0]) {
            return 0;
        }
        return 1;
    }
}

