/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModStirlingGenerator
extends SocketModule {
    private static final int ACTIVE = 1;
    private static final int HIGH_POWER = 2;

    public ModStirlingGenerator(int id) {
        super(id, "eng_toolbox:stirlingGenIdle0", "eng_toolbox:stirlingGenIdle1");
    }

    @Override
    public String getLocalizedName() {
        return "Stirling Generator";
    }

    public void getToolTip(List l) {
        l.add("Generates power using");
        l.add("furnace fuel");
        l.add("High power mode uses");
        l.add("more than double the fuel");
        l.add("to produce double the power");
        l.add("per tick");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Input inventory");
        l.add(Config.PREF_WHITE() + "Toggles high power mode");
        l.add(Config.PREF_AQUA() + "Produces 10 or 20 RF/t");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Items.module(), 1, this.moduleID), new Object[]{"ggg", " F ", " b ", Character.valueOf('g'), Blocks.field_150348_b, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('b'), Items.blankSide()}));
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.tank ^= 2;
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean updateClient = false;
        if (config.inventory >= 0 && config.inventory <= 2) {
            ItemStack toIntake;
            int time;
            boolean canStoreEnergy;
            boolean roomForMoreFuel = ts.sideInventory.func_70301_a(side.ordinal()) == null;
            boolean moreFuelAvail = ts.getStackInInventorySlot(config.inventory) != null;
            boolean bl = canStoreEnergy = ts.getEnergyStored() < ts.getMaxEnergyStored();
            if (moreFuelAvail && roomForMoreFuel && canStoreEnergy && config.meta <= 0 && (time = TileEntityFurnace.func_145952_a((ItemStack)(toIntake = ts.getStackInInventorySlot(config.inventory)))) > 0) {
                if (time % 2 != 0) {
                    ++time;
                }
                ts.extractItemInternal(true, config.inventory, 1);
                config.meta = time;
            }
            if (canStoreEnergy && config.meta > 0) {
                if ((config.tank & 2) != 2) {
                    --config.meta;
                    ts.addEnergy(10, false);
                } else {
                    config.meta -= 2;
                    if (ts.func_145831_w().field_73012_v.nextBoolean()) {
                        --config.meta;
                    }
                    ts.addEnergy(20, false);
                }
                if (config.meta == 0) {
                    config.tank &= 0xFFFFFFFE;
                    updateClient = true;
                } else {
                    if ((config.tank & 1) != 1) {
                        updateClient = true;
                    }
                    config.tank |= 1;
                }
            } else if (!canStoreEnergy && config.meta > 0) {
                config.tank &= 0xFFFFFFFE;
                updateClient = true;
            }
        }
        if (updateClient) {
            ts.sendClientSideState(side.ordinal());
        }
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.tank = 0;
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        if ((config.tank & 2) == 2) {
            return 1;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if ((config.tank & 1) == 1) {
            if ((config.tank & 2) == 2) {
                return "eng_toolbox:inner_fire_blue";
            }
            return "eng_toolbox:inner_fire_orange";
        }
        return "eng_toolbox:inner_black";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_fire_blue", "eng_toolbox:inner_fire_orange"};
    }
}

